/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.string;

import java.util.ArrayList;

public abstract class StringConverter {
    public static ArrayList<StringConverter> converters = new ArrayList();
    public static ArrayList<String> splitters = new ArrayList();
    public static final String splitcode = "/s";
    public final String UUID;

    public static String getSplitterCode(int index, String splitter) {
        String Number2 = "" + index;
        if (index < 10) {
            Number2 = "0" + Number2;
        }
        return splitter + Number2;
    }

    public static String getSplitterCode(int index) {
        return StringConverter.getSplitterCode(index, splitcode);
    }

    public static String loadString(String input) {
        String splitter = splitcode;
        if (input.contains("&Split")) {
            splitter = "&Split";
        }
        String result = input.substring(0);
        for (int i = 0; i < splitters.size(); ++i) {
            result = result.replace(StringConverter.getSplitterCode(i, splitter), splitters.get(i));
        }
        return result;
    }

    public static String saveString(String input) {
        String result = input.substring(0);
        for (int i = 0; i < splitters.size(); ++i) {
            result = result.replace(splitters.get(i), StringConverter.getSplitterCode(i));
        }
        return result;
    }

    public static StringConverter getConverter(Class ObjectClass) {
        for (int i = 0; i < converters.size(); ++i) {
            if (!converters.get(i).isConverter(ObjectClass)) continue;
            return converters.get(i);
        }
        return null;
    }

    public static StringConverter getConverter(String UUID) {
        for (int i = 0; i < converters.size(); ++i) {
            if (!StringConverter.converters.get((int)i).UUID.equals(UUID)) continue;
            return converters.get(i);
        }
        return null;
    }

    public static boolean containsConverter(String UUID) {
        return StringConverter.getConverter(UUID) != null;
    }

    public static boolean registerConverter(StringConverter converter) {
        if (StringConverter.containsConverter(converter.UUID)) {
            System.out.println("The UUID: '" + converter.UUID + "' is already taken!");
            return false;
        }
        converters.add(converter);
        String[] split = converter.getSplitter();
        for (int i = 0; i < split.length; ++i) {
            if (splitters.contains(split[i])) continue;
            splitters.add(split[i]);
        }
        return true;
    }

    public boolean isConverter(Class ObjectClass) {
        return this.getClassOfObject().isAssignableFrom(ObjectClass);
    }

    public StringConverter(String UUID) {
        this.UUID = UUID;
    }

    public abstract Class getClassOfObject();

    public abstract String toString(Object var1);

    public abstract Object parseObject(String var1);

    public abstract String[] getSplitter();
}

