/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.RoutingFocusParadigm;
import WayofTime.alchemicalWizardry.api.RoutingFocusPosAndFacing;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.common.items.routing.InputRoutingFocus;
import WayofTime.alchemicalWizardry.common.items.routing.OutputRoutingFocus;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RitualEffectItemRouting
extends RitualEffect {
    private static final Int3[] INPUT_BUFFER_LOCATIONS = new Int3[]{new Int3(1, 0, 0), new Int3(-1, 0, 0), new Int3(0, 0, 1), new Int3(0, 0, -1)};
    private static final Int3[] OUTPUT_BUFFER_LOCATIONS = new Int3[]{new Int3(2, 0, 2), new Int3(-2, 0, 2), new Int3(2, 0, -2), new Int3(-2, 0, -2)};

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        if (world.func_82737_E() % 20L != 0L) {
            return;
        }
        List<IInventory> outputFocusChests = this.findBufferChests(world, x, y, z, OUTPUT_BUFFER_LOCATIONS);
        if (outputFocusChests.isEmpty()) {
            return;
        }
        List<IInventory> inputFocusChests = this.findBufferChests(world, x, y, z, INPUT_BUFFER_LOCATIONS);
        if (inputFocusChests.isEmpty()) {
            return;
        }
        for (IInventory outputFoci : outputFocusChests) {
            this.processOutputFoci(world, outputFoci, inputFocusChests);
        }
    }

    private void processOutputFoci(World world, IInventory outputFoci, List<IInventory> inputFocusChests) {
        RoutingFocusParadigm paradigm = new RoutingFocusParadigm();
        boolean lastItemWasFocus = true;
        for (int i = 0; i < outputFoci.func_70302_i_(); ++i) {
            ItemStack keyStack = outputFoci.func_70301_a(i);
            if (keyStack == null) continue;
            Item item = keyStack.func_77973_b();
            if (item instanceof OutputRoutingFocus) {
                OutputRoutingFocus outputFocus = (OutputRoutingFocus)item;
                if (!lastItemWasFocus) {
                    paradigm.clear();
                }
                paradigm.addRoutingFocusPosAndFacing(outputFocus.getPosAndFacing(keyStack));
                paradigm.addLogic(outputFocus.getLogic(keyStack));
                paradigm.addName(outputFocus.getName(keyStack));
                lastItemWasFocus = true;
                continue;
            }
            lastItemWasFocus = false;
            for (RoutingFocusPosAndFacing posAndFacing : paradigm.locationList) {
                if (posAndFacing == null) continue;
                ForgeDirection inputDirection = posAndFacing.facing;
                TileEntity outputTarget = world.func_147438_o(posAndFacing.location.xCoord, posAndFacing.location.yCoord, posAndFacing.location.zCoord);
                if (!(outputTarget instanceof IInventory)) continue;
                IInventory outputInventory = (IInventory)outputTarget;
                for (IInventory inputFoci : inputFocusChests) {
                    this.processInputFoci(world, inputFoci, keyStack, paradigm, outputInventory, inputDirection);
                }
            }
        }
    }

    private void processInputFoci(World world, IInventory inputFoci, ItemStack keyStack, RoutingFocusParadigm paradigm, IInventory outputInventory, ForgeDirection inputDirection) {
        for (int i = 0; i < inputFoci.func_70302_i_(); ++i) {
            TileEntity inputTarget;
            InputRoutingFocus inputFocus;
            Item item;
            ItemStack inputFocusStack = inputFoci.func_70301_a(i);
            if (inputFocusStack == null || !((item = inputFocusStack.func_77973_b()) instanceof InputRoutingFocus) || !paradigm.doesNameMatch((inputFocus = (InputRoutingFocus)item).getName(inputFocusStack)) || !((inputTarget = world.func_147438_o(inputFocus.xCoord(inputFocusStack), inputFocus.yCoord(inputFocusStack), inputFocus.zCoord(inputFocusStack))) instanceof IInventory)) continue;
            IInventory inputChest = (IInventory)inputTarget;
            boolean[] slotList = this.checkSlots(inputChest, inputFocus.getSetDirection(inputFocusStack));
            for (int j = 0; j < inputChest.func_70302_i_(); ++j) {
                ItemStack syphonedStack;
                if (!slotList[j] || !this.canExtractItem(inputChest, j, syphonedStack = inputChest.func_70301_a(j), inputFocus.getSetDirection(inputFocusStack)) || !paradigm.doesItemMatch(keyStack, syphonedStack)) continue;
                ItemStack newStack = this.insertStackWithLimit(syphonedStack, outputInventory, inputDirection, paradigm.maximumAmount);
                inputChest.func_70299_a(j, newStack != null && newStack.field_77994_a > 0 ? newStack : null);
            }
        }
    }

    private boolean[] checkSlots(IInventory inventory, ForgeDirection direction) {
        boolean[] result = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] validSlots;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            for (int slot : validSlots = sidedInv.func_94128_d(direction.ordinal())) {
                result[slot] = true;
            }
        } else {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                result[i] = true;
            }
        }
        return result;
    }

    private boolean canExtractItem(IInventory inventory, int slot, ItemStack stack, ForgeDirection direction) {
        return stack != null && (!(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_102008_b(slot, stack, direction.ordinal()));
    }

    private ItemStack insertStackWithLimit(ItemStack stack, IInventory inventory, ForgeDirection direction, int maxAmount) {
        return maxAmount <= 0 ? SpellHelper.insertStackIntoInventory(stack, inventory, direction) : SpellHelper.insertStackIntoInventory(stack, inventory, direction, maxAmount);
    }

    private List<IInventory> findBufferChests(World world, int x, int y, int z, Int3[] locations) {
        ArrayList<IInventory> chestList = new ArrayList<IInventory>();
        for (Int3 chestLocation : locations) {
            TileEntity tileEntity = world.func_147438_o(x + chestLocation.xCoord, y + chestLocation.yCoord, z + chestLocation.zCoord);
            if (!(tileEntity instanceof IInventory)) continue;
            IInventory inv = (IInventory)tileEntity;
            chestList.add(inv);
        }
        return chestList;
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostPhantomHands[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> itemRoutingRitual = new ArrayList<RitualComponent>();
        this.addCornerRunes(itemRoutingRitual, 1, 0, 0);
        this.addOffsetRunes(itemRoutingRitual, 2, 1, 0, 2);
        this.addParallelRunes(itemRoutingRitual, 4, 0, 1);
        this.addParallelRunes(itemRoutingRitual, 5, 0, 3);
        this.addCornerRunes(itemRoutingRitual, 4, 0, 1);
        return itemRoutingRitual;
    }
}

