/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ISaveState;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class ItemIdentifierInventory
implements IInventory,
ISaveState,
ILPCCTypeHolder,
Iterable<Pair<ItemIdentifierStack, Integer>> {
    private Object ccType;
    private final ItemIdentifierStack[] _contents;
    private final String _name;
    private final int _stackLimit;
    private final HashMap<ItemIdentifier, Integer> _contentsMap;
    private final HashSet<ItemIdentifier> _contentsUndamagedSet;
    private final HashSet<ItemIdentifier> _contentsNoNBTSet;
    private final HashSet<ItemIdentifier> _contentsUndamagedNoNBTSet;
    private final boolean isLiquidInvnetory;
    private final LinkedList<ISimpleInventoryEventHandler> _listener = new LinkedList();

    public ItemIdentifierInventory(int size, String name, int stackLimit, boolean liquidInv) {
        this._contents = new ItemIdentifierStack[size];
        this._name = name;
        this._stackLimit = stackLimit;
        this._contentsMap = new HashMap((int)((double)size * 1.5));
        this._contentsUndamagedSet = new HashSet((int)((double)size * 1.5));
        this._contentsNoNBTSet = new HashSet((int)((double)size * 1.5));
        this._contentsUndamagedNoNBTSet = new HashSet((int)((double)size * 1.5));
        this.isLiquidInvnetory = liquidInv;
    }

    public ItemIdentifierInventory(int size, String name, int stackLimit) {
        this(size, name, stackLimit, false);
    }

    public int func_70302_i_() {
        return this._contents.length;
    }

    @Deprecated
    public ItemStack func_70301_a(int i) {
        if (this._contents[i] == null) {
            return null;
        }
        return this._contents[i].makeNormalStack();
    }

    public ItemIdentifierStack getIDStackInSlot(int i) {
        return this._contents[i];
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this._contents[slot] == null) {
            return null;
        }
        if (this._contents[slot].getStackSize() > count) {
            ItemStack ret = this._contents[slot].makeNormalStack();
            ret.field_77994_a = count;
            this._contents[slot].setStackSize(this._contents[slot].getStackSize() - count);
            this.updateContents();
            return ret;
        }
        ItemStack ret = this._contents[slot].makeNormalStack();
        this._contents[slot] = null;
        this.updateContents();
        return ret;
    }

    public ItemIdentifierStack decrIDStackSize(int slot, int count) {
        if (this._contents[slot] == null) {
            return null;
        }
        if (this._contents[slot].getStackSize() > count) {
            ItemIdentifierStack ret = this._contents[slot].clone();
            ret.setStackSize(count);
            this._contents[slot].setStackSize(this._contents[slot].getStackSize() - count);
            this.updateContents();
            return ret;
        }
        ItemIdentifierStack ret = this._contents[slot];
        this._contents[slot] = null;
        this.updateContents();
        return ret;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (itemstack == null) {
            this._contents[i] = null;
        } else {
            if (!this.isValidStack(itemstack)) {
                if (LPConstants.DEBUG) {
                    new UnsupportedOperationException("Not valid for this Inventory: (" + itemstack + ")").printStackTrace();
                }
                return;
            }
            this._contents[i] = ItemIdentifierStack.getFromStack(itemstack);
        }
        this.updateContents();
    }

    public void setInventorySlotContents(int i, ItemIdentifierStack itemstack) {
        if (itemstack == null) {
            this._contents[i] = null;
        } else {
            if (!this.isValidStack(itemstack)) {
                if (LPConstants.DEBUG) {
                    new UnsupportedOperationException("Not valid for this Inventory: (" + itemstack + ")").printStackTrace();
                }
                return;
            }
            this._contents[i] = itemstack;
        }
        this.updateContents();
    }

    public String func_145825_b() {
        return this._name;
    }

    public int func_70297_j_() {
        return this._stackLimit;
    }

    public void func_70296_d() {
        this.updateContents();
        for (ISimpleInventoryEventHandler handler : this._listener) {
            handler.InventoryChanged(this);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound, "");
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(prefix + "items", (int)nbttagcompound.func_74732_a());
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound itemTag = nbttaglist.func_150305_b(j);
            int index = itemTag.func_74762_e("index");
            if (index < this._contents.length) {
                ItemIdentifierStack itemstack;
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
                if (stack == null || !this.isValidStack(itemstack = ItemIdentifierStack.getFromStack(stack))) continue;
                this._contents[index] = itemstack;
                continue;
            }
            LogisticsPipes.log.fatal("SimpleInventory: java.lang.ArrayIndexOutOfBoundsException: " + index + " of " + this._contents.length);
        }
        this.updateContents();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound, "");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String prefix) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this._contents.length; ++j) {
            if (this._contents[j] == null || this._contents[j].getStackSize() <= 0) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)itemTag);
            itemTag.func_74768_a("index", j);
            this._contents[j].unsafeMakeNormalStack().func_77955_b(itemTag);
        }
        nbttagcompound.func_74782_a(prefix + "items", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a(prefix + "itemsCount", this._contents.length);
    }

    public void dropContents(World worldObj, int posX, int posY, int posZ) {
        if (MainProxy.isServer(worldObj)) {
            for (int i = 0; i < this._contents.length; ++i) {
                while (this._contents[i] != null) {
                    ItemStack todrop = this.func_70298_a(i, this._contents[i].getItem().getMaxStackSize());
                    ItemIdentifierInventory.dropItems(worldObj, todrop, posX, posY, posZ);
                }
            }
            this.updateContents();
        }
    }

    public static void dropItems(World world, ItemStack stack, int i, int j, int k) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.field_145804_b = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public void addListener(ISimpleInventoryEventHandler listner) {
        if (!this._listener.contains(listner)) {
            this._listener.add(listner);
        }
    }

    public void removeListener(ISimpleInventoryEventHandler listner) {
        this._listener.remove(listner);
    }

    public ItemStack func_70304_b(int i) {
        if (this._contents[i] == null) {
            return null;
        }
        ItemStack stackToTake = this._contents[i].makeNormalStack();
        this._contents[i] = null;
        this.updateContents();
        return stackToTake;
    }

    public void handleItemIdentifierList(Collection<ItemIdentifierStack> _allItems) {
        int i = 0;
        for (ItemIdentifierStack stack : _allItems) {
            if (this._contents.length <= i) break;
            this._contents[i] = stack;
            ++i;
        }
        this.func_70296_d();
    }

    private int tryAddToSlot(int i, ItemStack stack, int realstacklimit) {
        if (!this.isValidStack(stack)) {
            if (LPConstants.DEBUG) {
                new UnsupportedOperationException("Not valid for this Inventory: (" + stack + ")").printStackTrace();
            }
            return 0;
        }
        ItemIdentifierStack slot = this._contents[i];
        if (slot == null) {
            this._contents[i] = ItemIdentifierStack.getFromStack(stack);
            this._contents[i].setStackSize(Math.min(this._contents[i].getStackSize(), realstacklimit));
            return this._contents[i].getStackSize();
        }
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        ItemIdentifier slotIdent = slot.getItem();
        if (slotIdent.equals(stackIdent)) {
            slot.setStackSize(slot.getStackSize() + stack.field_77994_a);
            if (slot.getStackSize() > realstacklimit) {
                int ans = stack.field_77994_a - (slot.getStackSize() - realstacklimit);
                slot.setStackSize(realstacklimit);
                return ans;
            }
            return stack.field_77994_a;
        }
        return 0;
    }

    public int addCompressed(ItemStack stack, boolean ignoreMaxStackSize) {
        int added;
        int i;
        if (stack == null) {
            return 0;
        }
        if (!this.isValidStack(stack)) {
            if (LPConstants.DEBUG) {
                new UnsupportedOperationException("Not valid for this Inventory: (" + stack + ")").printStackTrace();
            }
            return stack.field_77994_a;
        }
        stack = stack.func_77946_l();
        ItemIdentifier stackIdent = ItemIdentifier.get(stack);
        int stacklimit = this._stackLimit;
        if (!ignoreMaxStackSize) {
            stacklimit = Math.min(stacklimit, stackIdent.getMaxStackSize());
        }
        for (i = 0; i < this._contents.length && stack.field_77994_a > 0; ++i) {
            if (this._contents[i] == null) continue;
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.field_77994_a -= added;
        }
        for (i = 0; i < this._contents.length && stack.field_77994_a > 0; ++i) {
            added = this.tryAddToSlot(i, stack, stacklimit);
            stack.field_77994_a -= added;
        }
        this.func_70296_d();
        return stack.field_77994_a;
    }

    private void updateContents() {
        this._contentsMap.clear();
        this._contentsUndamagedSet.clear();
        this._contentsNoNBTSet.clear();
        this._contentsUndamagedNoNBTSet.clear();
        for (ItemIdentifierStack _content : this._contents) {
            if (_content == null) continue;
            ItemIdentifier itemId = _content.getItem();
            this._contentsMap.merge(itemId, _content.getStackSize(), Integer::sum);
            this._contentsUndamagedSet.add(itemId.getUndamaged());
            this._contentsNoNBTSet.add(itemId.getIgnoringNBT());
            this._contentsUndamagedNoNBTSet.add(itemId.getIgnoringNBT().getUndamaged());
        }
    }

    public int itemCount(ItemIdentifier item) {
        Integer i = this._contentsMap.get(item);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        return this._contentsMap;
    }

    public boolean containsItem(ItemIdentifier item) {
        return this._contentsMap.containsKey(item);
    }

    public boolean containsUndamagedItem(ItemIdentifier item) {
        return this._contentsUndamagedSet.contains(item);
    }

    public boolean containsExcludeNBTItem(ItemIdentifier item) {
        return this._contentsNoNBTSet.contains(item);
    }

    public boolean containsUndamagedExcludeNBTItem(ItemIdentifier item) {
        return this._contentsUndamagedNoNBTSet.contains(item);
    }

    public boolean isEmpty() {
        return this._contentsMap.isEmpty();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void clearInventorySlotContents(int i) {
        this._contents[i] = null;
        this.updateContents();
    }

    public void compact_first(int size) {
        int i;
        for (i = 0; i < size; ++i) {
            ItemIdentifierStack stackInSlot = this.getIDStackInSlot(i);
            if (stackInSlot == null) continue;
            ItemIdentifier itemInSlot = stackInSlot.getItem();
            for (int j = i + 1; j < size; ++j) {
                ItemIdentifierStack stackInOtherSlot = this.getIDStackInSlot(j);
                if (stackInOtherSlot == null || !itemInSlot.equals(stackInOtherSlot.getItem())) continue;
                stackInSlot.setStackSize(stackInSlot.getStackSize() + stackInOtherSlot.getStackSize());
                this.clearInventorySlotContents(j);
            }
            this.setInventorySlotContents(i, stackInSlot);
        }
        block2: for (i = 0; i < size; ++i) {
            if (this.func_70301_a(i) != null) continue;
            for (int j = i + 1; j < size; ++j) {
                if (this.func_70301_a(j) == null) continue;
                this.func_70299_a(i, this.func_70301_a(j));
                this.clearInventorySlotContents(j);
                continue block2;
            }
        }
    }

    public void recheckStackLimit() {
        for (ItemIdentifierStack _content : this._contents) {
            if (_content == null) continue;
            _content.setStackSize(Math.min(_content.getStackSize(), this._stackLimit));
        }
    }

    private boolean isValidStack(ItemStack stack) {
        if (this.isLiquidInvnetory) {
            return FluidIdentifier.get(stack) != null;
        }
        return true;
    }

    private boolean isValidStack(ItemIdentifierStack stack) {
        if (this.isLiquidInvnetory) {
            return FluidIdentifier.get(stack.getItem()) != null;
        }
        return true;
    }

    @Override
    public void setCCType(Object type) {
        this.ccType = type;
    }

    @Override
    public Object getCCType() {
        return this.ccType;
    }

    @Override
    public Iterator<Pair<ItemIdentifierStack, Integer>> iterator() {
        final Iterator<ItemIdentifierStack> iter = Arrays.asList(this._contents).iterator();
        return new Iterator<Pair<ItemIdentifierStack, Integer>>(){
            int pos = -1;

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Pair<ItemIdentifierStack, Integer> next() {
                ++this.pos;
                return new Pair<ItemIdentifierStack, Integer>((ItemIdentifierStack)iter.next(), this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void clearGrid() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this._contents[i] = null;
        }
        this.updateContents();
    }
}

