/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import appeng.util.Platform;
import codechicken.nei.ItemsTooltipLineHandler;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.nei.NEETerminalOverlayButton;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketArcaneRecipe;
import com.github.vfyjxf.nee.utils.Ingredient;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import com.github.vfyjxf.nee.utils.ItemUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thaumicenergistics.client.gui.GuiArcaneCraftingTerminal;

public class NEEKnowledgeInscriberHandler
implements IOverlayHandler {
    public static final NEEKnowledgeInscriberHandler instance = new NEEKnowledgeInscriberHandler();
    private Class<?> knowledgeInscriberClz;
    private Class<?> itemAspectClz;

    private NEEKnowledgeInscriberHandler() {
        try {
            this.knowledgeInscriberClz = Class.forName("thaumicenergistics.client.gui.GuiKnowledgeInscriber");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.itemAspectClz = Class.forName("com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void overlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        if (this.knowledgeInscriberClz != null && this.knowledgeInscriberClz.isInstance(firstGui)) {
            NEENetworkHandler.getInstance().sendToServer((IMessage)this.packetArcaneRecipe(recipe, recipeIndex));
        }
    }

    private PacketArcaneRecipe packetArcaneRecipe(IRecipeHandler recipe, int recipeIndex) {
        NBTTagCompound recipeInputs = new NBTTagCompound();
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        if (this.itemAspectClz != null) {
            ingredients.removeIf(positionedStack -> this.itemAspectClz.isInstance(positionedStack.item.func_77973_b()));
        }
        for (PositionedStack positionedStack2 : ingredients) {
            if (positionedStack2.items == null || positionedStack2.items.length <= 0) continue;
            int slotIndex = this.getSlotIndex(positionedStack2.relx * 100 + positionedStack2.rely);
            ItemStack[] currentStackList = positionedStack2.items;
            ItemStack stack = positionedStack2.item;
            for (ItemStack currentStack : currentStackList) {
                if (!Platform.isRecipePrioritized((ItemStack)currentStack)) continue;
                stack = currentStack.func_77946_l();
            }
            recipeInputs.func_74782_a("#" + slotIndex, (NBTBase)ItemUtils.writeItemStackToNBT(stack, stack.field_77994_a));
        }
        return new PacketArcaneRecipe(recipeInputs);
    }

    private int getSlotIndex(int xy) {
        switch (xy) {
            case 7533: {
                return 1;
            }
            case 10333: {
                return 2;
            }
            case 4960: {
                return 3;
            }
            case 7660: {
                return 4;
            }
            case 10360: {
                return 5;
            }
            case 4987: {
                return 6;
            }
            case 7687: {
                return 7;
            }
            case 10387: {
                return 8;
            }
        }
        return 0;
    }

    @SubscribeEvent
    public void onActionPerformedEventPost(GuiRecipeButton.UpdateRecipeButtonsEvent.Post event) {
        block2: {
            GuiRecipe guiRecipe;
            block3: {
                GuiScreen guiScreen;
                if (!NEEConfig.noShift || !((guiScreen = event.gui) instanceof GuiRecipe)) break block2;
                guiRecipe = (GuiRecipe)guiScreen;
                if (!this.isGuiArcaneCraftingTerm(guiRecipe)) break block3;
                for (int i = 0; i < event.buttonList.size(); ++i) {
                    Object e = event.buttonList.get(i);
                    if (!(e instanceof GuiOverlayButton)) continue;
                    GuiOverlayButton btn = (GuiOverlayButton)e;
                    event.buttonList.set(i, new NEEArcaneOverlayButton(btn));
                }
                break block2;
            }
            if (!this.isGuiKnowledgeInscriber(guiRecipe)) break block2;
            for (int i = 0; i < event.buttonList.size(); ++i) {
                Object e = event.buttonList.get(i);
                if (!(e instanceof GuiOverlayButton)) continue;
                GuiOverlayButton btn = (GuiOverlayButton)e;
                btn.setRequireShiftForOverlayRecipe(false);
            }
        }
    }

    private boolean isGuiKnowledgeInscriber(GuiRecipe<?> gui) {
        return gui.firstGui != null && this.getClass().isInstance(gui.getHandler().getOverlayHandler(gui.firstGui, 0));
    }

    private boolean isGuiArcaneCraftingTerm(GuiRecipe<?> gui) {
        return Loader.isModLoaded((String)"thaumicenergistics") && gui.firstGui instanceof GuiArcaneCraftingTerminal;
    }

    public class NEEArcaneOverlayButton
    extends NEETerminalOverlayButton {
        public NEEArcaneOverlayButton(GuiOverlayButton button) {
            super(button.firstGui, button.handlerRef, button.field_146128_h, button.field_146129_i);
        }

        protected List<GuiOverlayButton.ItemOverlayState> ingredientsOverlay() {
            List ingredients = this.handlerRef.handler.getIngredientStacks(this.handlerRef.recipeIndex);
            if (this.itemPresenceCache.size() != ingredients.size()) {
                this.itemPresenceCache.clear();
                IngredientTracker tracker = new IngredientTracker(this.firstGui, this.handlerRef.handler, this.handlerRef.recipeIndex);
                for (Ingredient ingredient : tracker.getIngredients()) {
                    this.itemPresenceCache.add(new NEETerminalOverlayButton.NEEItemOverlayState(ingredient, true));
                }
                List items = this.itemPresenceCache.stream().filter(state -> !state.isPresent()).map(state -> state.getSlot().item).collect(Collectors.toList());
                this.missedMaterialsTooltipLineHandler = !items.isEmpty() ? new ItemsTooltipLineHandler(NEIClientUtils.translate((String)"recipe.overlay.missing", (Object[])new Object[0]), items, true, Integer.MAX_VALUE) : null;
            }
            return this.itemPresenceCache;
        }
    }
}

