/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.network;

import gcewing.architecture.common.network.ClassCache;
import gcewing.architecture.common.network.ClientMessageHandler;
import gcewing.architecture.common.network.MethodCache;
import gcewing.architecture.common.network.ServerMessageHandler;
import java.lang.reflect.Method;

enum HandlerMap {
    SERVER(ServerMessageHandler.class){

        @Override
        protected String annotationValue(Object a) {
            return ((ServerMessageHandler)a).value();
        }
    }
    ,
    CLIENT(ClientMessageHandler.class){

        @Override
        protected String annotationValue(Object a) {
            return ((ClientMessageHandler)a).value();
        }
    };

    protected final Class type;
    protected final ClassCache classCache = new ClassCache();

    private HandlerMap(Class type) {
        this.type = type;
    }

    protected abstract String annotationValue(Object var1);

    public Method get(Object handler, String message) {
        Class<?> cls = handler.getClass();
        MethodCache cache = this.classCache.get(cls);
        Method meth = (Method)cache.get(message);
        if (meth == null) {
            for (Method m : cls.getMethods()) {
                Object a = m.getAnnotation(this.type);
                if (a == null || !this.annotationValue(a).equals(message)) continue;
                cache.put(message, m);
                meth = m;
                break;
            }
        }
        return meth;
    }
}

