/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.savedata;

import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.savedata.WorldSavefile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public final class WorldDataHandler {
    private static WorldDataHandler instance;
    private final Map<Class<? extends WorldSavefile>, WorldSavefile> cache = new IdentityHashMap<Class<? extends WorldSavefile>, WorldSavefile>();
    private File worldSaveDir;
    private String worldIdentifier = "";

    public static void register() {
        if (instance == null) {
            instance = new WorldDataHandler();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    public static <T> T get(Class<? extends WorldSavefile> cls) {
        Stopwatch.timeAverage("WorldDataHandler - get", 160000);
        WorldSavefile savefile = WorldDataHandler.instance.cache.get(cls);
        if (savefile == null) {
            try {
                savefile = cls.newInstance();
                WorldDataHandler.instance.cache.put(cls, savefile);
                File file = new File(WorldDataHandler.instance.worldSaveDir, savefile.filename);
                if (file.exists()) {
                    try {
                        Stopwatch.time("WorldDataHandler - load " + savefile.filename);
                        savefile.loadFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
                        Stopwatch.finish("WorldDataHandler - load " + savefile.filename);
                    }
                    catch (IOException ioe) {
                        Log.throwable(ioe, "Error reading NBT file - $0", cls.getName());
                    }
                } else {
                    savefile.loadFromNBT(new NBTTagCompound());
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Could not construct a new instance of WorldSavefile - " + cls.getName(), e);
            }
        }
        Stopwatch.finish("WorldDataHandler - get");
        return (T)savefile;
    }

    public static String getWorldIdentifier(World world) {
        return world.func_72860_G().func_75760_g() + world.func_72912_H().func_76065_j() + world.func_72912_H().func_76063_b();
    }

    public static void forceSave() {
        instance.saveModified();
    }

    private WorldDataHandler() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (e.world.field_72995_K) {
            return;
        }
        String id = WorldDataHandler.getWorldIdentifier(e.world);
        if (!this.worldIdentifier.equals(id)) {
            Log.debug("Clearing cache - old $0, new $1", this.worldIdentifier, id);
            this.cache.clear();
            this.worldIdentifier = id;
            File root = DimensionManager.getCurrentSaveRootDirectory();
            if (root != null) {
                this.worldSaveDir = new File(root, "hee");
                if (!this.worldSaveDir.exists()) {
                    this.worldSaveDir.mkdirs();
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save e) {
        this.saveModified();
    }

    private void saveModified() {
        if (this.worldSaveDir == null) {
            return;
        }
        for (WorldSavefile savefile : this.cache.values()) {
            if (!savefile.wasModified()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            savefile.saveToNBT(nbt);
            try {
                Stopwatch.time("WorldDataHandler - save " + savefile.filename);
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(new File(this.worldSaveDir, savefile.filename)));
                Stopwatch.finish("WorldDataHandler - save " + savefile.filename);
            }
            catch (Exception ex) {
                Log.throwable(ex, "Error writing WorldData file $0", savefile.getClass());
            }
        }
    }
}

