/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.mixins.late.config;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.config.settings.IntSetting;
import dev.rndmorris.salisarcana.lib.ObfuscationInfo;
import dev.rndmorris.salisarcana.lib.R;
import dev.rndmorris.salisarcana.lib.pojo.PotionInfo;
import dev.rndmorris.salisarcana.notifications.StartupNotifications;
import java.util.Arrays;
import net.minecraft.potion.Potion;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.common.config.Config;

@Mixin(value={Config.class}, remap=false)
public abstract class MixinConfig_PotionIds {
    @Inject(method={"initPotions"}, at={@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;info(Ljava/lang/String;)V", ordinal=0)})
    private static void initPotions(CallbackInfo ci, @Local(name={"potionOffset"}) LocalIntRef potionOffsetRef, @Share(value="potionIndex") LocalIntRef potionIndexRef, @Share(value="potionInfo") LocalRef<PotionInfo[]> potionInfoRef) {
        SalisArcana.LOG.info("Overriding Thaumcraft's potion id assignement.");
        PotionInfo[] potionIdInfo = new PotionInfo[]{PotionInfo.taintPoison(), PotionInfo.fluxFlu(), PotionInfo.fluxPhage(), PotionInfo.unnaturalHunger(), PotionInfo.warpWard(), PotionInfo.deadlyGaze(), PotionInfo.blurredVision(), PotionInfo.sunScorned(), PotionInfo.thaumarhia()};
        potionInfoRef.set((Object)potionIdInfo);
        int maxId = Arrays.stream(potionIdInfo).mapToInt(PotionInfo::id).max().getAsInt();
        int arrayLengthLimit = SalisConfig.thaum.potionIdLimitRaised.isEnabled() ? Integer.MAX_VALUE : 127;
        int minRequiredSize = 32 + potionIdInfo.length;
        int expandTo = 1 + Math.min(Math.max(maxId, minRequiredSize), arrayLengthLimit);
        if (!MixinConfig_PotionIds.sa$expandPotionArray(expandTo)) {
            potionIndexRef.set(-1);
            return;
        }
        potionIndexRef.set(0);
        potionOffsetRef.set(Integer.MAX_VALUE);
    }

    @WrapOperation(method={"initPotions"}, at={@At(value="INVOKE", target="Lthaumcraft/common/config/Config;getNextPotionId(I)I")})
    private static int wrapPotionId(int _start, Operation<Integer> original, @Share(value="potionIndex") LocalIntRef potionIndexRef, @Share(value="lastAutoId") LocalIntRef lastAutoIdRef, @Share(value="potionInfo") LocalRef<PotionInfo[]> potionInfoRef) {
        int autoId;
        int potionIndex = potionIndexRef.get();
        if (potionIndex == -1) {
            return -1;
        }
        potionIndexRef.set(potionIndex + 1);
        PotionInfo potionInfo = ((PotionInfo[])potionInfoRef.get())[potionIndex];
        IntSetting setting = potionInfo.setting;
        int potionId = setting.getValue();
        if (setting.isEnabled()) {
            boolean isInLimit;
            boolean bl = isInLimit = potionId < (SalisConfig.thaum.potionIdLimitRaised.isEnabled() ? Integer.MAX_VALUE : 127);
            if (isInLimit) {
                if (Potion.field_76425_a[potionId] == null) {
                    return potionId;
                }
                MixinConfig_PotionIds.sa$logPotionIdClaimed(potionInfo);
            } else {
                MixinConfig_PotionIds.sa$logPotionIdAboveSafeLimit(potionInfo);
            }
        }
        if ((autoId = MixinConfig_PotionIds.sa$findNextOpenId(lastAutoIdRef, potionInfo.loggingName)) == -1) {
            potionIndexRef.set(-1);
            return -1;
        }
        return autoId;
    }

    @Unique
    private static int sa$findNextOpenId(LocalIntRef lastAutoRef, String potionName) {
        int startIndex = 32;
        for (int index = Math.max(lastAutoRef.get() + 1, 32); index < Potion.field_76425_a.length; ++index) {
            if (Potion.field_76425_a[index] != null) continue;
            lastAutoRef.set(index);
            SalisArcana.LOG.info("Found unassigned potion id {}. Assigning it to {}.", new Object[]{index, potionName});
            return index;
        }
        SalisArcana.LOG.info("Hit the potion array limit at {}, requesting +1 expansion.", new Object[]{Potion.field_76425_a.length});
        int nextId = Potion.field_76425_a.length;
        if (MixinConfig_PotionIds.sa$expandPotionArray(nextId + 1)) {
            lastAutoRef.set(nextId);
            return nextId;
        }
        MixinConfig_PotionIds.sa$logArrayTooLong();
        return -1;
    }

    @Unique
    private static boolean sa$expandPotionArray(int increaseTo) {
        Potion[] oldArray = Potion.field_76425_a;
        if (oldArray.length >= increaseTo) {
            SalisArcana.LOG.info("Requested increasing the potion array to {} but the array is already of length {}.", new Object[]{increaseTo, oldArray.length});
            return true;
        }
        boolean limitRaised = SalisConfig.thaum.potionIdLimitRaised.isEnabled();
        if (!limitRaised && increaseTo > 127) {
            return false;
        }
        SalisArcana.LOG.info("Expanding potion array to {}", new Object[]{increaseTo});
        Potion[] newArray = new Potion[increaseTo];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        R.of(Potion.class).set(ObfuscationInfo.POTION_TYPES.getName(), newArray);
        return true;
    }

    @Unique
    private static void sa$logArrayTooLong() {
        SalisArcana.LOG.error("No unassigned potion ids could be found within the safe limit.");
        StartupNotifications.queueError((IChatComponent)new ChatComponentTranslation("salisaracan:error.potion_array_too_long", new Object[0]));
    }

    @Unique
    private static void sa$logPotionIdClaimed(PotionInfo potionInfo) {
        SalisArcana.LOG.error("{} could not be given id {} as configured because that id has been assigned to a different potion effect.", new Object[]{potionInfo.loggingName, potionInfo.id()});
        StartupNotifications.queueError((IChatComponent)new ChatComponentTranslation("salisarcana:error.potion_id_claimed", new Object[]{new ChatComponentTranslation(potionInfo.langKey, new Object[0]), potionInfo.id()}));
    }

    @Unique
    private static void sa$logPotionIdAboveSafeLimit(PotionInfo potionInfo) {
        SalisArcana.LOG.error("{} was assigned id {}, which is above the safe limit of 127. If the limit has been raised through another mod, please set _uncapped_potion_ids to `true` in the Salis Arcana feature configs.", new Object[]{potionInfo.loggingName, potionInfo.id()});
        StartupNotifications.queueError((IChatComponent)new ChatComponentTranslation("salisarcana:error.potion_id_limit", new Object[]{new ChatComponentTranslation(potionInfo.langKey, new Object[0]), potionInfo.id()}));
    }
}

