/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity;

import com.rwtema.extrautils.texture.LiquidColorRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityDrum
extends TileEntity
implements IFluidHandler {
    public static final int numBuckets = 256;
    public static final int defaultCapacity = 256000;
    private FluidTank tank = new FluidTank(256000);
    public static int numTicksTilDisplayEmpty = 100;
    public boolean recentlyDrained = false;
    public boolean recentlyFilled = false;
    public FluidStack prevFluid = null;
    boolean sided = false;

    public TileEntityDrum() {
    }

    public TileEntityDrum(int metadata) {
        this.field_145847_g = metadata;
        this.setCapacityFromMetadata(metadata);
    }

    public static int getCapacityFromMetadata(int meta) {
        if (meta == 1) {
            return 65536000;
        }
        return 256000;
    }

    public void setCapacityFromMetadata(int meta) {
        if (meta == 1) {
            this.tank.setCapacity(TileEntityDrum.getCapacityFromMetadata(meta));
        }
    }

    public void loadDrumFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.tank.setFluid(null);
        this.tank.readFromNBT(par1NBTTagCompound.func_74775_l("tank"));
    }

    public void writeDrumToNBT(NBTTagCompound par1NBTTagCompound) {
        NBTTagCompound tag = new NBTTagCompound();
        this.tank.writeToNBT(tag);
        par1NBTTagCompound.func_74782_a("tank", (NBTBase)tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.loadDrumFromNBT(tag);
        this.tank.setCapacity(tag.func_74775_l("tank").func_74762_e("capacity"));
        if (this.tank.getFluid() != null) {
            this.prevFluid = this.tank.getFluid().copy();
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeDrumToNBT(tag);
        NBTTagCompound tag2 = tag.func_74775_l("tank");
        tag2.func_74768_a("capacity", this.tank.getCapacity());
        tag.func_74782_a("tank", (NBTBase)tag2);
    }

    public boolean canUpdate() {
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound t = new NBTTagCompound();
        this.writeDrumToNBT(t);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 4, t);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.loadDrumFromNBT(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void ticked() {
        if (this.recentlyDrained) {
            this.recentlyDrained = false;
            if (this.recentlyFilled) {
                this.recentlyFilled = false;
                this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), numTicksTilDisplayEmpty);
            } else {
                this.prevFluid = null;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.sided && from.ordinal() > 1) {
            return 0;
        }
        boolean t2 = this.tank.getFluid() == null;
        int t = this.tank.fill(resource, doFill);
        if (doFill) {
            if (t2 && this.tank.getFluid() != null && !this.tank.getFluid().isFluidEqual(this.prevFluid)) {
                this.prevFluid = this.tank.getFluid().copy();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (t != 0) {
                this.recentlyFilled = true;
                this.func_70296_d();
            }
        }
        return t;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.sided && from.ordinal() > 1 || resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        if (doDrain) {
            this.func_70296_d();
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!(this.sided && from.ordinal() > 1 || this.tank.getFluidAmount() <= 0)) {
            FluidStack t = this.tank.drain(maxDrain, doDrain);
            if (doDrain && t != null) {
                if (this.tank.getFluidAmount() == 0) {
                    this.recentlyFilled = false;
                    this.recentlyDrained = true;
                    this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), numTicksTilDisplayEmpty);
                }
                this.func_70296_d();
            }
            return t;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.sided || from.ordinal() <= 1;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor() {
        return LiquidColorRegistry.getFluidColor(this.tank.getFluid());
    }
}

