/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block.bush;

import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.block.bush.AbstractSapling;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class PodSapling
extends AbstractSapling {
    protected int widthRadius = 4;
    protected int height = 10;

    public PodSapling(String name, String texture) {
        super(name, texture);
    }

    protected boolean canGenerateHere(World world, Random rand, int x, int y, int z, int height, double outerRadius) {
        for (int curY = -1; curY < height + 3; ++curY) {
            int curX = (int)(-outerRadius);
            while ((double)curX <= outerRadius) {
                int curZ = (int)(-outerRadius);
                while ((double)curZ <= outerRadius) {
                    Block block;
                    if (curY == -1 ? (block = world.func_147439_a(curX + x, curY + y, curZ + z)).func_149688_o() != Material.field_151578_c && block.func_149688_o() != Material.field_151577_b && !this.isBlockReplaceable(block) : !this.canReplaceBlock(world, curX + x, curY + y, curZ + z)) {
                        return false;
                    }
                    ++curZ;
                }
                ++curX;
            }
        }
        return true;
    }

    @Override
    public boolean generate(World world, Random rand, int x, int y, int z, boolean notify) {
        int curY;
        double heightHalf = Math.ceil(this.height / 2) + (double)rand.nextInt(3);
        double centerOffset = 3 + rand.nextInt(2);
        double outerRadius = this.widthRadius + rand.nextInt(3);
        double innerRadius = outerRadius - 1.0;
        double innerHeightRadius = heightHalf - 1.0;
        int topMostY = 0;
        if (!this.canGenerateHere(world, rand, x, y, z, this.height, outerRadius)) {
            return false;
        }
        for (curY = -1; curY < this.height + 3; ++curY) {
            int curX = (int)(-outerRadius);
            while ((double)curX <= outerRadius) {
                int curZ = (int)(-outerRadius);
                while ((double)curZ <= outerRadius) {
                    if (Math.pow((double)curX / outerRadius, 2.0) + Math.pow(((double)curY - centerOffset) / heightHalf, 2.0) + Math.pow((double)curZ / outerRadius, 2.0) <= 1.0) {
                        if (curY > -1 && Math.pow((double)curX / innerRadius, 2.0) + Math.pow(((double)curY - centerOffset) / innerHeightRadius, 2.0) + Math.pow((double)curZ / innerRadius, 2.0) < 1.0) {
                            if ((double)curY <= centerOffset) {
                                this.setBlockAndNotifyAdequately(world, curX + x, curY + y, curZ + z, this.leaves.getBlock(), this.leaves.getMetadata(), notify);
                            } else {
                                this.setBlockAndNotifyAdequately(world, curX + x, curY + y, curZ + z, Blocks.field_150350_a, 0, notify);
                            }
                        } else {
                            this.setBlockAndNotifyAdequately(world, curX + x, curY + y, curZ + z, this.wood.getBlock(), this.wood.getMetadata(), notify);
                            if (topMostY < curY) {
                                topMostY = curY;
                            }
                        }
                    }
                    ++curZ;
                }
                ++curX;
            }
        }
        for (curY = 0; curY < 3; ++curY) {
            this.setBlockAndNotifyAdequately(world, x, curY + topMostY + y - 1, z, Blocks.field_150350_a, 0, notify);
            if (curY <= 0) continue;
            this.setBlockAndNotifyAdequately(world, x - 1, curY + topMostY + y - 1, z, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x + 1, curY + topMostY + y - 1, z, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x, curY + topMostY + y - 1, z - 1, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x, curY + topMostY + y - 1, z + 1, this.wood.getBlock(), this.wood.getMetadata(), notify);
            if (curY != 1) continue;
            this.setBlockAndNotifyAdequately(world, x + 1, curY + topMostY + y - 1, z - 1, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x - 1, curY + topMostY + y - 1, z - 1, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x + 1, curY + topMostY + y - 1, z + 1, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x - 1, curY + topMostY + y - 1, z + 1, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x - 2, curY + topMostY + y - 1, z, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x + 2, curY + topMostY + y - 1, z, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x, curY + topMostY + y - 1, z - 2, this.wood.getBlock(), this.wood.getMetadata(), notify);
            this.setBlockAndNotifyAdequately(world, x, curY + topMostY + y - 1, z + 2, this.wood.getBlock(), this.wood.getMetadata(), notify);
        }
        return true;
    }

    @Override
    public boolean canPlaceOn(Block blockToCheck, int metaToCheck, int meta) {
        return blockToCheck == ARBlocks.blockMethaneDirt.getBlock() && metaToCheck == ARBlocks.blockMethaneDirt.getMetadata() || blockToCheck == ARBlocks.blockMethaneGrass.getBlock() && metaToCheck == ARBlocks.blockMethaneGrass.getMetadata() || blockToCheck == ARBlocks.blockVacuumGrass.getBlock() && metaToCheck == ARBlocks.blockVacuumGrass.getMetadata();
    }
}

