/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.block;

import appeng.api.config.SecurityPermissions;
import appeng.util.Platform;
import com.glodblock.github.client.render.RenderBlockLevelMaintainer;
import com.glodblock.github.common.block.FCBaseBlock;
import com.glodblock.github.common.item.FCBaseItemBlock;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.NameConst;
import com.glodblock.github.util.RenderUtil;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLevelMaintainer
extends FCBaseBlock {
    public BlockLevelMaintainer() {
        super(Material.field_151573_f, "level_maintainer");
        this.setFullBlock(true);
        this.setOpaque(true);
        this.setTileEntity(TileLevelMaintainer.class);
    }

    @Override
    public BlockLevelMaintainer register() {
        GameRegistry.registerBlock((Block)this, FCBaseItemBlock.class, (String)"level_maintainer");
        GameRegistry.registerTileEntity(TileLevelMaintainer.class, (String)"level_maintainer");
        this.func_149647_a(FluidCraftingTabs.INSTANCE);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockLevelMaintainer getRenderer() {
        return new RenderBlockLevelMaintainer();
    }

    public boolean onActivated(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileLevelMaintainer tile = (TileLevelMaintainer)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile != null) {
            if (Platform.isServer()) {
                if (Util.hasPermission(player, SecurityPermissions.CRAFT, tile)) {
                    InventoryHandler.openGui(player, world, new BlockPos(x, y, z), ForgeDirection.getOrientation((int)facing), GuiType.LEVEL_MAINTAINER);
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("You don't have permission to view."));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> toolTip, boolean advancedToolTips) {
        if (GuiScreen.func_146272_n() && GuiScreen.func_146271_m()) {
            toolTip.add(NameConst.i18n("ae2fc.tooltip.level_maintainer.Who_Am_I"));
        } else if (GuiScreen.func_146272_n()) {
            toolTip.addAll(RenderUtil.listFormattedStringToWidth(NameConst.i18n("ae2fc.tooltip.level_maintainer.desc")));
        } else {
            toolTip.add(NameConst.i18n("ae2fc.tooltip.shift_for_more"));
        }
    }
}

