/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import serverutils.ranks.ICommandWithPermission;

public abstract class CommandTreeBase
extends CommandBase {
    private final Map<String, ICommand> commandMap = new HashMap<String, ICommand>();
    private final Map<String, ICommand> commandAliasMap = new HashMap<String, ICommand>();

    public void addSubcommand(ICommand command) {
        this.commandMap.put(command.func_71517_b(), command);
        if (command.func_71514_a() == null) {
            return;
        }
        for (String alias : command.func_71514_a()) {
            this.commandAliasMap.put(alias, command);
        }
    }

    public Collection<ICommand> getSubCommands() {
        return this.commandMap.values();
    }

    @Nullable
    public ICommand getSubCommand(String command) {
        ICommand cmd = this.commandMap.get(command);
        if (cmd != null) {
            return cmd;
        }
        return this.commandAliasMap.get(command);
    }

    public Map<String, ICommand> getCommandMap() {
        return Collections.unmodifiableMap(this.commandMap);
    }

    public List<ICommand> getSortedCommandList() {
        ArrayList<ICommand> list = new ArrayList<ICommand>(this.getSubCommands());
        Collections.sort(list);
        return list;
    }

    private static String[] shiftArgs(@Nullable String[] s) {
        if (s == null || s.length == 0) {
            return new String[0];
        }
        String[] s1 = new String[s.length - 1];
        System.arraycopy(s, 1, s1, 0, s1.length);
        return s1;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> keys = new ArrayList<String>();
            for (ICommand c : this.getSubCommands()) {
                if (!this.canUseSubcommand(sender, c)) continue;
                keys.add(c.func_71517_b());
            }
            keys.sort(null);
            return CommandTreeBase.func_71531_a((String[])args, keys);
        }
        ICommand cmd = this.getSubCommand(args[0]);
        if (cmd != null) {
            return cmd.func_71516_a(sender, CommandTreeBase.shiftArgs(args));
        }
        return super.func_71516_a(sender, args);
    }

    public boolean func_82358_a(String[] args, int index) {
        ICommand cmd;
        if (index > 0 && args.length > 1 && (cmd = this.getSubCommand(args[0])) != null) {
            return cmd.func_82358_a(CommandTreeBase.shiftArgs(args), index - 1);
        }
        return false;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            String subCommandsString = this.getAvailableSubCommandsString(sender);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.tree_base.available_subcommands", new Object[]{subCommandsString}));
        } else {
            ICommand cmd = this.getSubCommand(args[0]);
            if (cmd == null) {
                String subCommandsString = this.getAvailableSubCommandsString(sender);
                throw new CommandException("commands.tree_base.invalid_cmd.list_subcommands", new Object[]{args[0], subCommandsString});
            }
            if (!this.canUseSubcommand(sender, cmd)) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            cmd.func_71515_b(sender, CommandTreeBase.shiftArgs(args));
        }
    }

    private String getAvailableSubCommandsString(ICommandSender sender) {
        ArrayList<String> availableCommands = new ArrayList<String>();
        for (ICommand command : this.getSubCommands()) {
            if (!this.canUseSubcommand(sender, command)) continue;
            availableCommands.add(command.func_71517_b());
        }
        return CommandBase.func_96333_a(availableCommands);
    }

    private boolean canUseSubcommand(ICommandSender sender, ICommand command) {
        if (command instanceof ICommandWithPermission) {
            ICommandWithPermission permCmd = (ICommandWithPermission)command;
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                return permCmd.serverutilities$hasPermission(player);
            }
        }
        return command.func_71519_b(sender);
    }
}

