/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.api.MCHelper;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.factory.GuiManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class SimpleGuiFactory
extends AbstractUIFactory<GuiData> {
    private final Supplier<IGuiHolder<GuiData>> guiHolderSupplier;
    private IGuiHolder<GuiData> guiHolder;

    public SimpleGuiFactory(String name, IGuiHolder<GuiData> guiHolder) {
        this(name, () -> guiHolder);
    }

    public SimpleGuiFactory(String name, Supplier<IGuiHolder<GuiData>> guiHolderSupplier) {
        super(name);
        this.guiHolderSupplier = guiHolderSupplier;
        GuiManager.registerFactory(this);
    }

    public void init() {
    }

    public void open(EntityPlayerMP player) {
        GuiManager.open(this, new GuiData((EntityPlayer)player), player);
    }

    @SideOnly(value=Side.CLIENT)
    public void openClient() {
        GuiManager.openFromClient(this, new GuiData((EntityPlayer)MCHelper.getPlayer()));
    }

    @Override
    public void writeGuiData(GuiData guiData, PacketBuffer buffer) {
    }

    @Override
    @NotNull
    public GuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new GuiData(player);
    }

    @Override
    @NotNull
    public IGuiHolder<GuiData> getGuiHolder(GuiData data) {
        if (this.guiHolder == null) {
            this.guiHolder = this.guiHolderSupplier.get();
            Objects.requireNonNull(this.guiHolder, "IGuiHolder must not be null");
        }
        return this.guiHolder;
    }
}

