/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import mrtjp.projectred.core.libmc.fx.ParticleLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.MathHelper;

public class ParticleLogicApproachEntity
extends ParticleLogic {
    private final Entity target;
    private final double approachSpeed;
    private final double targetDistance;

    public ParticleLogicApproachEntity(Entity approachEntity, double approachSpeed, double targetDistance) {
        this.target = approachEntity;
        this.approachSpeed = approachSpeed;
        this.targetDistance = targetDistance;
    }

    @Override
    public void doUpdate() {
        double deltaY;
        double angle;
        if (this.target == null) {
            this.finishLogic();
            return;
        }
        double distanceToTarget = this.particle.func_70068_e(this.target);
        double deltaX = this.target.field_70165_t - this.particle.field_70165_t;
        double deltaZ = this.target.field_70161_v - this.particle.field_70161_v;
        double radians = angle = Math.atan2(deltaZ, deltaX);
        double posX = this.particle.field_70165_t + this.approachSpeed * Math.cos(radians);
        double posY = this.particle.field_70163_u;
        double posZ = this.particle.field_70161_v + this.approachSpeed * Math.sin(radians);
        if (this.target instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)this.target;
            deltaY = posY - (entityliving.field_70163_u + (double)entityliving.func_70047_e());
        } else {
            deltaY = this.target instanceof EntityItem ? posY - this.target.field_70163_u : (this.target.field_70121_D.field_72338_b + this.target.field_70121_D.field_72337_e) / 2.0 - posY;
        }
        double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
        double pitchRadians = pitchRotation;
        posY = this.particle.field_70163_u - this.approachSpeed * Math.sin(pitchRadians);
        if (distanceToTarget <= this.targetDistance * this.targetDistance) {
            this.finishLogic();
        } else {
            this.particle.func_70107_b(posX, posY, posZ);
        }
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicApproachEntity(this.target, this.approachSpeed, this.targetDistance).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

