function Strings( config ) {

	const language = config.getKey( 'language' );

	const values = {

		en: {

			'menubar/file': 'File',
			'menubar/file/new': 'New',
			'menubar/file/import': 'Import',
			'menubar/file/export/drc': 'Export DRC',
			'menubar/file/export/glb': 'Export GLB',
			'menubar/file/export/gltf': 'Export GLTF',
			'menubar/file/export/obj': 'Export OBJ',
			'menubar/file/export/ply': 'Export PLY',
			'menubar/file/export/ply_binary': 'Export PLY (Binary)',
			'menubar/file/export/stl': 'Export STL',
			'menubar/file/export/stl_binary': 'Export STL (Binary)',
			'menubar/file/export/usdz': 'Export USDZ',

			'menubar/edit': 'Edit',
			'menubar/edit/undo': 'Undo (Ctrl+Z)',
			'menubar/edit/redo': 'Redo (Ctrl+Shift+Z)',
			'menubar/edit/center': 'Center',
			'menubar/edit/clone': 'Clone',
			'menubar/edit/delete': 'Delete (Del)',

			'menubar/add': 'Add',
			'menubar/add/group': 'Group',
			'menubar/add/plane': 'Plane',
			'menubar/add/box': 'Box',
			'menubar/add/capsule': 'Capsule',
			'menubar/add/circle': 'Circle',
			'menubar/add/cylinder': 'Cylinder',
			'menubar/add/ring': 'Ring',
			'menubar/add/sphere': 'Sphere',
			'menubar/add/dodecahedron': 'Dodecahedron',
			'menubar/add/icosahedron': 'Icosahedron',
			'menubar/add/octahedron': 'Octahedron',
			'menubar/add/tetrahedron': 'Tetrahedron',
			'menubar/add/torus': 'Torus',
			'menubar/add/tube': 'Tube',
			'menubar/add/torusknot': 'TorusKnot',
			'menubar/add/lathe': 'Lathe',
			'menubar/add/sprite': 'Sprite',
			'menubar/add/pointlight': 'PointLight',
			'menubar/add/spotlight': 'SpotLight',
			'menubar/add/directionallight': 'DirectionalLight',
			'menubar/add/hemispherelight': 'HemisphereLight',
			'menubar/add/ambientlight': 'AmbientLight',
			'menubar/add/perspectivecamera': 'PerspectiveCamera',
			'menubar/add/orthographiccamera': 'OrthographicCamera',

			'menubar/status/autosave': 'autosave',

			'menubar/examples': 'Examples',
			'menubar/examples/Arkanoid': 'Arkanoid',
			'menubar/examples/Camera': 'Camera',
			'menubar/examples/Particles': 'Particles',
			'menubar/examples/Pong': 'Pong',
			'menubar/examples/Shaders': 'Shaders',

			'menubar/view': 'View',
			'menubar/view/fullscreen': 'Fullscreen',

			'menubar/help': 'Help',
			'menubar/help/source_code': 'Source Code',
			'menubar/help/icons': 'Icon Pack',
			'menubar/help/about': 'About',
			'menubar/help/manual': 'Manual',

			'sidebar/animations': 'Animations',
			'sidebar/animations/play': 'Play',
			'sidebar/animations/stop': 'Stop',
			'sidebar/animations/timescale': 'Time Scale',

			'sidebar/scene': 'Scene',
			'sidebar/scene/background': 'Background',
			'sidebar/scene/environment': 'Environment',
			'sidebar/scene/fog': 'Fog',

			'sidebar/properties/object': 'Object',
			'sidebar/properties/geometry': 'Geometry',
			'sidebar/properties/material': 'Material',
			'sidebar/properties/script': 'Script',

			'sidebar/object/type': 'Type',
			'sidebar/object/new': 'New',
			'sidebar/object/uuid': 'UUID',
			'sidebar/object/name': 'Name',
			'sidebar/object/position': 'Position',
			'sidebar/object/rotation': 'Rotation',
			'sidebar/object/scale': 'Scale',
			'sidebar/object/fov': 'Fov',
			'sidebar/object/left': 'Left',
			'sidebar/object/right': 'Right',
			'sidebar/object/top': 'Top',
			'sidebar/object/bottom': 'Bottom',
			'sidebar/object/near': 'Near',
			'sidebar/object/far': 'Far',
			'sidebar/object/intensity': 'Intensity',
			'sidebar/object/color': 'Color',
			'sidebar/object/groundcolor': 'Ground Color',
			'sidebar/object/distance': 'Distance',
			'sidebar/object/angle': 'Angle',
			'sidebar/object/penumbra': 'Penumbra',
			'sidebar/object/decay': 'Decay',
			'sidebar/object/shadow': 'Shadow',
			'sidebar/object/shadowBias': 'Shadow Bias',
			'sidebar/object/shadowNormalBias': 'Shadow Normal Bias',
			'sidebar/object/shadowRadius': 'Shadow Radius',
			'sidebar/object/cast': 'cast',
			'sidebar/object/receive': 'receive',
			'sidebar/object/visible': 'Visible',
			'sidebar/object/frustumcull': 'Frustum Cull',
			'sidebar/object/renderorder': 'Render Order',
			'sidebar/object/userdata': 'User data',
			'sidebar/object/export': 'Export JSON',

			'sidebar/geometry/type': 'Type',
			'sidebar/geometry/new': 'New',
			'sidebar/geometry/uuid': 'UUID',
			'sidebar/geometry/name': 'Name',
			'sidebar/geometry/bounds': 'Bounds',
			'sidebar/geometry/show_vertex_normals': 'Show Vertex Normals',
			'sidebar/geometry/compute_vertex_normals': 'Compute Vertex Normals',
			'sidebar/geometry/compute_vertex_tangents': 'Compute Tangents',
			'sidebar/geometry/center': 'Center',
			'sidebar/geometry/export': 'Export JSON',

			'sidebar/geometry/box_geometry/width': 'Width',
			'sidebar/geometry/box_geometry/height': 'Height',
			'sidebar/geometry/box_geometry/depth': 'Depth',
			'sidebar/geometry/box_geometry/widthseg': 'Width Seg',
			'sidebar/geometry/box_geometry/heightseg': 'Height Seg',
			'sidebar/geometry/box_geometry/depthseg': 'Depth Seg',

			'sidebar/geometry/buffer_geometry/attributes': 'Attributes',
			'sidebar/geometry/buffer_geometry/index': 'index',
			'sidebar/geometry/buffer_geometry/morphAttributes': 'Morph Attributes',
			'sidebar/geometry/buffer_geometry/morphRelative': 'Morph Relative',

			'sidebar/geometry/capsule_geometry/radius': 'Radius',
			'sidebar/geometry/capsule_geometry/length': 'Length',
			'sidebar/geometry/capsule_geometry/capseg': 'Cap Seg',
			'sidebar/geometry/capsule_geometry/radialseg': 'Radial Seg',

			'sidebar/geometry/circle_geometry/radius': 'Radius',
			'sidebar/geometry/circle_geometry/segments': 'Segments',
			'sidebar/geometry/circle_geometry/thetastart': 'Theta start',
			'sidebar/geometry/circle_geometry/thetalength': 'Theta length',

			'sidebar/geometry/cylinder_geometry/radiustop': 'Radius top',
			'sidebar/geometry/cylinder_geometry/radiusbottom': 'Radius bottom',
			'sidebar/geometry/cylinder_geometry/height': 'Height',
			'sidebar/geometry/cylinder_geometry/radialsegments': 'Radial segments',
			'sidebar/geometry/cylinder_geometry/heightsegments': 'Height segments',
			'sidebar/geometry/cylinder_geometry/openended': 'Open ended',

			'sidebar/geometry/extrude_geometry/curveSegments': 'Curve Segments',
			'sidebar/geometry/extrude_geometry/steps': 'Steps',
			'sidebar/geometry/extrude_geometry/depth': 'Depth',
			'sidebar/geometry/extrude_geometry/bevelEnabled': 'Bevel?',
			'sidebar/geometry/extrude_geometry/bevelThickness': 'Thickness',
			'sidebar/geometry/extrude_geometry/bevelSize': 'Size',
			'sidebar/geometry/extrude_geometry/bevelOffset': 'Offset',
			'sidebar/geometry/extrude_geometry/bevelSegments': 'Segments',
			'sidebar/geometry/extrude_geometry/shape': 'Convert to Shape',

			'sidebar/geometry/dodecahedron_geometry/radius': 'Radius',
			'sidebar/geometry/dodecahedron_geometry/detail': 'Detail',

			'sidebar/geometry/icosahedron_geometry/radius': 'Radius',
			'sidebar/geometry/icosahedron_geometry/detail': 'Detail',

			'sidebar/geometry/octahedron_geometry/radius': 'Radius',
			'sidebar/geometry/octahedron_geometry/detail': 'Detail',

			'sidebar/geometry/tetrahedron_geometry/radius': 'Radius',
			'sidebar/geometry/tetrahedron_geometry/detail': 'Detail',

			'sidebar/geometry/lathe_geometry/segments': 'Segments',
			'sidebar/geometry/lathe_geometry/phistart': 'Phi start (°)',
			'sidebar/geometry/lathe_geometry/philength': 'Phi length (°)',
			'sidebar/geometry/lathe_geometry/points': 'Points',

			'sidebar/geometry/plane_geometry/width': 'Width',
			'sidebar/geometry/plane_geometry/height': 'Height',
			'sidebar/geometry/plane_geometry/widthsegments': 'Width segments',
			'sidebar/geometry/plane_geometry/heightsegments': 'Height segments',

			'sidebar/geometry/ring_geometry/innerRadius': 'Inner radius',
			'sidebar/geometry/ring_geometry/outerRadius': 'Outer radius',
			'sidebar/geometry/ring_geometry/thetaSegments': 'Theta segments',
			'sidebar/geometry/ring_geometry/phiSegments': 'Phi segments',
			'sidebar/geometry/ring_geometry/thetastart': 'Theta start',
			'sidebar/geometry/ring_geometry/thetalength': 'Theta length',

			'sidebar/geometry/shape_geometry/curveSegments': 'Curve Segments',
			'sidebar/geometry/shape_geometry/extrude': 'Extrude',

			'sidebar/geometry/sphere_geometry/radius': 'Radius',
			'sidebar/geometry/sphere_geometry/widthsegments': 'Width segments',
			'sidebar/geometry/sphere_geometry/heightsegments': 'Height segments',
			'sidebar/geometry/sphere_geometry/phistart': 'Phi start',
			'sidebar/geometry/sphere_geometry/philength': 'Phi length',
			'sidebar/geometry/sphere_geometry/thetastart': 'Theta start',
			'sidebar/geometry/sphere_geometry/thetalength': 'Theta length',

			'sidebar/geometry/torus_geometry/radius': 'Radius',
			'sidebar/geometry/torus_geometry/tube': 'Tube',
			'sidebar/geometry/torus_geometry/radialsegments': 'Radial segments',
			'sidebar/geometry/torus_geometry/tubularsegments': 'Tubular segments',
			'sidebar/geometry/torus_geometry/arc': 'Arc',

			'sidebar/geometry/torusKnot_geometry/radius': 'Radius',
			'sidebar/geometry/torusKnot_geometry/tube': 'Tube',
			'sidebar/geometry/torusKnot_geometry/tubularsegments': 'Tubular segments',
			'sidebar/geometry/torusKnot_geometry/radialsegments': 'Radial segments',
			'sidebar/geometry/torusKnot_geometry/p': 'P',
			'sidebar/geometry/torusKnot_geometry/q': 'Q',

			'sidebar/geometry/tube_geometry/path': 'Path',
			'sidebar/geometry/tube_geometry/radius': 'Radius',
			'sidebar/geometry/tube_geometry/tube': 'Tube',
			'sidebar/geometry/tube_geometry/tubularsegments': 'Tubular segments',
			'sidebar/geometry/tube_geometry/radialsegments': 'Radial segments',
			'sidebar/geometry/tube_geometry/closed': 'Closed',
			'sidebar/geometry/tube_geometry/curvetype': 'Curve Type',
			'sidebar/geometry/tube_geometry/tension': 'Tension',

			'sidebar/material/new': 'New',
			'sidebar/material/copy': 'Copy',
			'sidebar/material/paste': 'Paste',
			'sidebar/material/slot': 'Slot',
			'sidebar/material/type': 'Type',
			'sidebar/material/uuid': 'UUID',
			'sidebar/material/name': 'Name',
			'sidebar/material/program': 'Program',
			'sidebar/material/info': 'Info',
			'sidebar/material/vertex': 'Vert',
			'sidebar/material/fragment': 'Frag',
			'sidebar/material/color': 'Color',
			'sidebar/material/depthPacking': 'Depth Packing',
			'sidebar/material/roughness': 'Roughness',
			'sidebar/material/metalness': 'Metalness',
			'sidebar/material/reflectivity': 'Reflectivity',
			'sidebar/material/emissive': 'Emissive',
			'sidebar/material/specular': 'Specular',
			'sidebar/material/shininess': 'Shininess',
			'sidebar/material/clearcoat': 'Clearcoat',
			'sidebar/material/clearcoatroughness': 'Clearcoat Roughness',
			'sidebar/material/iridescence': 'Iridescence',
			'sidebar/material/iridescenceIOR': 'Thin-Film IOR',
			'sidebar/material/iridescenceThicknessMax': 'Thin-Film Thickness',
			'sidebar/material/sheen': 'Sheen',
			'sidebar/material/sheenroughness': 'Sheen Roughness',
			'sidebar/material/sheencolor': 'Sheen Color',
			'sidebar/material/transmission': 'Transmission',
			'sidebar/material/attenuationDistance': 'Attenuation Distance',
			'sidebar/material/attenuationColor': 'Attenuation Color',
			'sidebar/material/thickness': 'Thickness',
			'sidebar/material/vertexcolors': 'Vertex Colors',
			'sidebar/material/matcap': 'Matcap',
			'sidebar/material/map': 'Map',
			'sidebar/material/alphamap': 'Alpha Map',
			'sidebar/material/bumpmap': 'Bump Map',
			'sidebar/material/normalmap': 'Normal Map',
			'sidebar/material/clearcoatmap': 'Clearcoat Map',
			'sidebar/material/clearcoatnormalmap': 'Clearcoat Normal Map',
			'sidebar/material/clearcoatroughnessmap': 'Clearcoat Roughness Map',
			'sidebar/material/displacementmap': 'Displace Map',
			'sidebar/material/roughnessmap': 'Rough. Map',
			'sidebar/material/metalnessmap': 'Metal. Map',
			'sidebar/material/specularmap': 'Specular Map',
			'sidebar/material/iridescencemap': 'Irid. Map',
			'sidebar/material/iridescencethicknessmap': 'Thin-Film Thickness Map',
			'sidebar/material/sheencolormap': 'Sheen Color Map',
			'sidebar/material/sheenroughnessmap': 'Sheen Rough. Map',
			'sidebar/material/envmap': 'Env Map',
			'sidebar/material/lightmap': 'Light Map',
			'sidebar/material/aomap': 'AO Map',
			'sidebar/material/emissivemap': 'Emissive Map',
			'sidebar/material/gradientmap': 'Gradient Map',
			'sidebar/material/transmissionmap': 'Transmission Map',
			'sidebar/material/thicknessmap': 'Thickness Map',
			'sidebar/material/side': 'Side',
			'sidebar/material/size': 'Size',
			'sidebar/material/sizeAttenuation': 'Size Attenuation',
			'sidebar/material/flatShading': 'Flat Shading',
			'sidebar/material/blending': 'Blending',
			'sidebar/material/opacity': 'Opacity',
			'sidebar/material/transparent': 'Transparent',
			'sidebar/material/forcesinglepass': 'Force Single Pass',
			'sidebar/material/alphatest': 'Alpha Test',
			'sidebar/material/depthtest': 'Depth Test',
			'sidebar/material/depthwrite': 'Depth Write',
			'sidebar/material/wireframe': 'Wireframe',
			'sidebar/material/userdata': 'User data',
			'sidebar/material/export': 'Export JSON',

			'sidebar/script/new': 'New',
			'sidebar/script/edit': 'Edit',
			'sidebar/script/remove': 'Remove',

			'sidebar/project': 'Project',
			'sidebar/project/antialias': 'Antialias',
			'sidebar/project/shadows': 'Shadows',
			'sidebar/project/toneMapping': 'Tonemapping',
			'sidebar/project/materials': 'Materials',
			'sidebar/project/Assign': 'Assign',

			'sidebar/project/app': 'App',
			'sidebar/project/app/play': 'Play',
			'sidebar/project/app/stop': 'Stop',
			'sidebar/project/app/title': 'Title',
			'sidebar/project/app/editable': 'Editable',
			'sidebar/project/app/publish': 'Publish',

			'sidebar/project/image': 'Image',
			'sidebar/project/video': 'Video',

			'sidebar/project/shading': 'Shading',
			'sidebar/project/resolution': 'Resolution',
			'sidebar/project/duration': 'Duration',
			'sidebar/project/render': 'Render',

			'sidebar/settings': 'Settings',
			'sidebar/settings/language': 'Language',

			'sidebar/settings/shortcuts': 'Shortcuts',
			'sidebar/settings/shortcuts/translate': 'Translate',
			'sidebar/settings/shortcuts/rotate': 'Rotate',
			'sidebar/settings/shortcuts/scale': 'Scale',
			'sidebar/settings/shortcuts/undo': 'Undo',
			'sidebar/settings/shortcuts/focus': 'Focus',

			'sidebar/history': 'History',
			'sidebar/history/clear': 'Clear',
			'sidebar/history/persistent': 'Persistent',

			'toolbar/translate': 'Translate',
			'toolbar/rotate': 'Rotate',
			'toolbar/scale': 'Scale',
			'toolbar/local': 'Local',

			'viewport/controls/grid': 'Grid',
			'viewport/controls/helpers': 'Helpers',

			'viewport/info/objects': 'Objects',
			'viewport/info/vertices': 'Vertices',
			'viewport/info/triangles': 'Triangles',
			'viewport/info/rendertime': 'Render time'

		},

		fr: {

			'menubar/file': 'Fichier',
			'menubar/file/new': 'Nouveau',
			'menubar/file/import': 'Importer',
			'menubar/file/export/drc': 'Exporter DRC',
			'menubar/file/export/glb': 'Exporter GLB',
			'menubar/file/export/gltf': 'Exporter GLTF',
			'menubar/file/export/obj': 'Exporter OBJ',
			'menubar/file/export/ply': 'Exporer PLY',
			'menubar/file/export/ply_binary': 'Exporter PLY (Binaire)',
			'menubar/file/export/stl': 'Exporter STL',
			'menubar/file/export/stl_binary': 'Exporter STL (Binaire)',
			'menubar/file/export/usdz': 'Exporter USDZ',

			'menubar/edit': 'Edition',
			'menubar/edit/undo': 'Annuler (Ctrl+Z)',
			'menubar/edit/redo': 'Refaire (Ctrl+Shift+Z)',
			'menubar/edit/center': 'Center',
			'menubar/edit/clone': 'Cloner',
			'menubar/edit/delete': 'Supprimer (Supp)',

			'menubar/add': 'Ajouter',
			'menubar/add/group': 'Groupe',
			'menubar/add/plane': 'Plan',
			'menubar/add/box': 'Cube',
			'menubar/add/capsule': 'Capsule',
			'menubar/add/circle': 'Cercle',
			'menubar/add/cylinder': 'Cylindre',
			'menubar/add/ring': 'Bague',
			'menubar/add/sphere': 'Sphère',
			'menubar/add/dodecahedron': 'Dodécaèdre',
			'menubar/add/icosahedron': 'Icosaèdre',
			'menubar/add/octahedron': 'Octaèdre',
			'menubar/add/tetrahedron': 'Tétraèdre',
			'menubar/add/torus': 'Torus',
			'menubar/add/tube': 'Tube',
			'menubar/add/torusknot': 'Noeud Torus',
			'menubar/add/lathe': 'Tour',
			'menubar/add/sprite': 'Sprite',
			'menubar/add/pointlight': 'Lumière ponctuelle',
			'menubar/add/spotlight': 'Projecteur',
			'menubar/add/directionallight': 'Lumière directionnelle',
			'menubar/add/hemispherelight': 'Lumière hémisphérique',
			'menubar/add/ambientlight': 'Lumière ambiante',
			'menubar/add/perspectivecamera': 'Caméra perspective',
			'menubar/add/orthographiccamera': 'Caméra orthographique',

			'menubar/status/autosave': 'enregistrement automatique',

			'menubar/examples': 'Exemples',
			'menubar/examples/Arkanoid': 'Arkanoid',
			'menubar/examples/Camera': 'Camera',
			'menubar/examples/Particles': 'Particles',
			'menubar/examples/Pong': 'Pong',
			'menubar/examples/Shaders': 'Shaders',

			'menubar/view': 'View',
			'menubar/view/fullscreen': 'Fullscreen',

			'menubar/help': 'Aide',
			'menubar/help/source_code': 'Code Source',
			'menubar/help/icons': 'Icon Pack',
			'menubar/help/about': 'A propos',
			'menubar/help/manual': 'Manual',

			'sidebar/animations': 'Animations',
			'sidebar/animations/play': 'Play',
			'sidebar/animations/stop': 'Stop',
			'sidebar/animations/timescale': 'Time Scale',

			'sidebar/scene': 'Scène',
			'sidebar/scene/background': 'Arrière Plan',
			'sidebar/scene/environment': 'Environment',
			'sidebar/scene/fog': 'Brouillard',

			'sidebar/properties/object': 'Objet',
			'sidebar/properties/geometry': 'Géométrie',
			'sidebar/properties/material': 'Matériaux',
			'sidebar/properties/script': 'Script',

			'sidebar/object/type': 'Type',
			'sidebar/object/new': 'Nouveau',
			'sidebar/object/uuid': 'UUID',
			'sidebar/object/name': 'Nom',
			'sidebar/object/position': 'Position',
			'sidebar/object/rotation': 'Rotation',
			'sidebar/object/scale': 'Échelle',
			'sidebar/object/fov': 'Champ de vision',
			'sidebar/object/left': 'Gauche',
			'sidebar/object/right': 'Droite',
			'sidebar/object/top': 'Haut',
			'sidebar/object/bottom': 'Bas',
			'sidebar/object/near': 'Près',
			'sidebar/object/far': 'Loin',
			'sidebar/object/intensity': 'Intensité',
			'sidebar/object/color': 'Couleur',
			'sidebar/object/groundcolor': 'Couleur de fond',
			'sidebar/object/distance': 'Distance',
			'sidebar/object/angle': 'Angle',
			'sidebar/object/penumbra': 'Pénombre',
			'sidebar/object/decay': 'Affaiblissement',
			'sidebar/object/shadow': 'Ombre',
			'sidebar/object/shadowBias': 'Biais directionnel des ombres',
			'sidebar/object/shadowNormalBias': 'Shadow Normal Bias',
			'sidebar/object/shadowRadius': 'Rayon de l\'ombre',
			'sidebar/object/cast': 'Projète',
			'sidebar/object/receive': 'Reçoit',
			'sidebar/object/visible': 'Visible',
			'sidebar/object/frustumcull': 'Culling',
			'sidebar/object/renderorder': 'Ordre de rendus',
			'sidebar/object/userdata': 'Données utilisateur',
			'sidebar/object/export': 'Exporter JSON',

			'sidebar/geometry/type': 'Type',
			'sidebar/geometry/new': 'Nouveau',
			'sidebar/geometry/uuid': 'UUID',
			'sidebar/geometry/name': 'Nom',
			'sidebar/geometry/bounds': 'Limites',
			'sidebar/geometry/show_vertex_normals': 'Afficher normales',
			'sidebar/geometry/compute_vertex_normals': 'Compute Vertex Normals',
			'sidebar/geometry/compute_vertex_tangents': 'Compute Tangents',
			'sidebar/geometry/center': 'Center',
			'sidebar/geometry/export': 'Exporter JSON',

			'sidebar/geometry/box_geometry/width': 'Largeur',
			'sidebar/geometry/box_geometry/height': 'Hauteur',
			'sidebar/geometry/box_geometry/depth': 'Profondeur',
			'sidebar/geometry/box_geometry/widthseg': 'Segments en Largeur',
			'sidebar/geometry/box_geometry/heightseg': 'Segments en Hauteur',
			'sidebar/geometry/box_geometry/depthseg': 'Segments en Profondeur',

			'sidebar/geometry/buffer_geometry/attributes': 'Attributs',
			'sidebar/geometry/buffer_geometry/index': 'index',
			'sidebar/geometry/buffer_geometry/morphAttributes': 'Morph Attributes',
			'sidebar/geometry/buffer_geometry/morphRelative': 'Morph Relative',

			'sidebar/geometry/capsule_geometry/radius': 'Radius',
			'sidebar/geometry/capsule_geometry/length': 'Length',
			'sidebar/geometry/capsule_geometry/capseg': 'Cap Seg',
			'sidebar/geometry/capsule_geometry/radialseg': 'Radial Seg',

			'sidebar/geometry/circle_geometry/radius': 'Rayon',
			'sidebar/geometry/circle_geometry/segments': 'Segments',
			'sidebar/geometry/circle_geometry/thetastart': 'Début Thêta (°)',
			'sidebar/geometry/circle_geometry/thetalength': 'Longueur Thêta (°)',

			'sidebar/geometry/cylinder_geometry/radiustop': 'Rayon supérieur',
			'sidebar/geometry/cylinder_geometry/radiusbottom': 'Rayon inférieur',
			'sidebar/geometry/cylinder_geometry/height': 'Hauteur',
			'sidebar/geometry/cylinder_geometry/radialsegments': 'Segments radiaux',
			'sidebar/geometry/cylinder_geometry/heightsegments': 'Segments en hauteur',
			'sidebar/geometry/cylinder_geometry/openended': 'Extrémités ouvertes',

			'sidebar/geometry/extrude_geometry/curveSegments': 'Segments de courbe',
			'sidebar/geometry/extrude_geometry/steps': 'Pas',
			'sidebar/geometry/extrude_geometry/depth': 'Profondeur',
			'sidebar/geometry/extrude_geometry/bevelEnabled': 'Biseau',
			'sidebar/geometry/extrude_geometry/bevelThickness': 'Épaisseur',
			'sidebar/geometry/extrude_geometry/bevelSize': 'Taille',
			'sidebar/geometry/extrude_geometry/bevelOffset': 'Décalage',
			'sidebar/geometry/extrude_geometry/bevelSegments': 'Segments',
			'sidebar/geometry/extrude_geometry/shape': 'Convertir en forme',

			'sidebar/geometry/dodecahedron_geometry/radius': 'Rayon',
			'sidebar/geometry/dodecahedron_geometry/detail': 'Détail',

			'sidebar/geometry/icosahedron_geometry/radius': 'Rayon',
			'sidebar/geometry/icosahedron_geometry/detail': 'Détail',

			'sidebar/geometry/octahedron_geometry/radius': 'Rayon',
			'sidebar/geometry/octahedron_geometry/detail': 'Détail',

			'sidebar/geometry/tetrahedron_geometry/radius': 'Rayon',
			'sidebar/geometry/tetrahedron_geometry/detail': 'Détail',

			'sidebar/geometry/lathe_geometry/segments': 'Segments',
			'sidebar/geometry/lathe_geometry/phistart': 'Début Phi (°)',
			'sidebar/geometry/lathe_geometry/philength': 'Longueur Phi (°)',
			'sidebar/geometry/lathe_geometry/points': 'Points',

			'sidebar/geometry/plane_geometry/width': 'Largeur',
			'sidebar/geometry/plane_geometry/height': 'Hauteur',
			'sidebar/geometry/plane_geometry/widthsegments': 'Segments en Largeur',
			'sidebar/geometry/plane_geometry/heightsegments': 'Segments en Hauteur',

			'sidebar/geometry/ring_geometry/innerRadius': 'Rayon intérieur',
			'sidebar/geometry/ring_geometry/outerRadius': 'Rayon extérieur',
			'sidebar/geometry/ring_geometry/thetaSegments': 'Segments Thêta',
			'sidebar/geometry/ring_geometry/phiSegments': 'Phi segments',
			'sidebar/geometry/ring_geometry/thetastart': 'Début Thêta',
			'sidebar/geometry/ring_geometry/thetalength': 'Longueur Thêta',

			'sidebar/geometry/shape_geometry/curveSegments': 'Segments de courbe',
			'sidebar/geometry/shape_geometry/extrude': 'Extruder',

			'sidebar/geometry/sphere_geometry/radius': 'Rayon',
			'sidebar/geometry/sphere_geometry/widthsegments': 'Segments en Largeur',
			'sidebar/geometry/sphere_geometry/heightsegments': 'Segments en Hauteur',
			'sidebar/geometry/sphere_geometry/phistart': 'Début Phi (°)',
			'sidebar/geometry/sphere_geometry/philength': 'Longueur Phi (°)',
			'sidebar/geometry/sphere_geometry/thetastart': 'Début Thêta',
			'sidebar/geometry/sphere_geometry/thetalength': 'Longueur Thêta',

			'sidebar/geometry/torus_geometry/radius': 'Rayon',
			'sidebar/geometry/torus_geometry/tube': 'Tube',
			'sidebar/geometry/torus_geometry/radialsegments': 'Segments radiaux',
			'sidebar/geometry/torus_geometry/tubularsegments': 'Segments tubulaires',
			'sidebar/geometry/torus_geometry/arc': 'Arc',

			'sidebar/geometry/torusKnot_geometry/radius': 'Rayon',
			'sidebar/geometry/torusKnot_geometry/tube': 'Tube',
			'sidebar/geometry/torusKnot_geometry/tubularsegments': 'Segments tubulaires',
			'sidebar/geometry/torusKnot_geometry/radialsegments': 'Segments radiaux',
			'sidebar/geometry/torusKnot_geometry/p': 'P',
			'sidebar/geometry/torusKnot_geometry/q': 'Q',

			'sidebar/geometry/tube_geometry/path': 'Chemin',
			'sidebar/geometry/tube_geometry/radius': 'Rayon',
			'sidebar/geometry/tube_geometry/tube': 'Tube',
			'sidebar/geometry/tube_geometry/tubularsegments': 'Segments tubulaires',
			'sidebar/geometry/tube_geometry/radialsegments': 'Segments radiaux',
			'sidebar/geometry/tube_geometry/closed': 'Fermé',
			'sidebar/geometry/tube_geometry/curvetype': 'Type de courbe',
			'sidebar/geometry/tube_geometry/tension': 'Tension',

			'sidebar/material/new': 'Nouveau',
			'sidebar/material/copy': 'Copier',
			'sidebar/material/paste': 'Coller',
			'sidebar/material/slot': 'Slot',
			'sidebar/material/type': 'Type',
			'sidebar/material/uuid': 'UUID',
			'sidebar/material/name': 'Nom',
			'sidebar/material/program': 'Programme',
			'sidebar/material/info': 'Info',
			'sidebar/material/vertex': 'Sommet',
			'sidebar/material/fragment': 'Fragment',
			'sidebar/material/color': 'Couleur',
			'sidebar/material/depthPacking': 'Encodage profondeur de couleur',
			'sidebar/material/roughness': 'Rugosité',
			'sidebar/material/metalness': 'Métal',
			'sidebar/material/reflectivity': 'Reflectivity',
			'sidebar/material/emissive': 'Émissif',
			'sidebar/material/specular': 'Spéculaire',
			'sidebar/material/shininess': 'Brillance',
			'sidebar/material/clearcoat': 'Vernis',
			'sidebar/material/clearcoatroughness': 'Rugosité du vernis',
			'sidebar/material/iridescence': 'Iridescence',
			'sidebar/material/iridescenceIOR': 'Thin-Film IOR',
			'sidebar/material/iridescenceThicknessMax': 'Thin-Film Thickness',
			'sidebar/material/sheen': 'Sheen',
			'sidebar/material/sheenroughness': 'Sheen Roughness',
			'sidebar/material/sheencolor': 'Sheen Color',
			'sidebar/material/transmission': 'Transmission',
			'sidebar/material/attenuationDistance': 'Attenuation Distance',
			'sidebar/material/attenuationColor': 'Attenuation Color',
			'sidebar/material/thickness': 'Thickness',
			'sidebar/material/vertexcolors': 'Couleurs aux Sommets',
			'sidebar/material/matcap': 'Matcap',
			'sidebar/material/map': 'Texture',
			'sidebar/material/alphamap': 'Texture de transparence',
			'sidebar/material/bumpmap': 'Texture de relief',
			'sidebar/material/normalmap': 'Texture de normales',
			'sidebar/material/clearcoatnormalmap': 'Texture des normales du vernis',
			'sidebar/material/displacementmap': 'Texture de déplacement',
			'sidebar/material/roughnessmap': 'Texture de rugosité',
			'sidebar/material/metalnessmap': 'Texture métallique',
			'sidebar/material/specularmap': 'Texture spéculaire',
			'sidebar/material/iridescencemap': 'Irid. Map',
			'sidebar/material/iridescencethicknessmap': 'Thin-Film Thickness Map',
			'sidebar/material/sheencolormap': 'Sheen Color Map',
			'sidebar/material/sheenroughnessmap': 'Sheen Rough. Map',
			'sidebar/material/envmap': 'Texture d\'environnement',
			'sidebar/material/lightmap': 'Texture d\'éclairage',
			'sidebar/material/aomap': 'Texture d\'occlusion ambiante',
			'sidebar/material/emissivemap': 'Texture d\'émission',
			'sidebar/material/gradientmap': 'Texture de gradient',
			'sidebar/material/transmissionmap': 'Transmission Map',
			'sidebar/material/thicknessmap': 'Thickness Map',
			'sidebar/material/side': 'Côté',
			'sidebar/material/size': 'Size',
			'sidebar/material/sizeAttenuation': 'Size Attenuation',
			'sidebar/material/flatShading': 'Flat Shading',
			'sidebar/material/blending': 'Mélange',
			'sidebar/material/opacity': 'Opacité',
			'sidebar/material/transparent': 'Transparence',
			'sidebar/material/forcesinglepass': 'Force Single Pass',
			'sidebar/material/alphatest': 'Test de transparence',
			'sidebar/material/depthtest': 'Depth Test',
			'sidebar/material/depthwrite': 'Depth Write',
			'sidebar/material/wireframe': 'Fil de fer',
			'sidebar/material/userdata': 'Données utilisateur',
			'sidebar/material/export': 'Exporter JSON',

			'sidebar/script/new': 'Nouveau',
			'sidebar/script/edit': 'Editer',
			'sidebar/script/remove': 'Supprimer',

			'sidebar/project': 'Projet',
			'sidebar/project/antialias': 'Anticrénelage',
			'sidebar/project/shadows': 'Ombres',
			'sidebar/project/toneMapping': 'Mappage des nuances',
			'sidebar/project/materials': 'Matériaux',
			'sidebar/project/Assign': 'Attribuer',

			'sidebar/project/app': 'App',
			'sidebar/project/app/play': 'Jouer',
			'sidebar/project/app/stop': 'Arrêter',
			'sidebar/project/app/title': 'Titre',
			'sidebar/project/app/editable': 'Modifiable',
			'sidebar/project/app/publish': 'Publier',

			'sidebar/project/image': 'Image',
			'sidebar/project/video': 'Video',

			'sidebar/project/shading': 'Shading',
			'sidebar/project/resolution': 'Resolution',
			'sidebar/project/duration': 'Duration',
			'sidebar/project/render': 'Render',

			'sidebar/settings': 'Paramètres',
			'sidebar/settings/language': 'Langue',

			'sidebar/settings/shortcuts': 'Shortcuts',
			'sidebar/settings/shortcuts/translate': 'Position',
			'sidebar/settings/shortcuts/rotate': 'Rotation',
			'sidebar/settings/shortcuts/scale': 'Échelle',
			'sidebar/settings/shortcuts/undo': 'Annuler',
			'sidebar/settings/shortcuts/focus': 'Focus',

			'sidebar/history': 'Historique',
			'sidebar/history/clear': 'Supprimer',
			'sidebar/history/persistent': 'Permanent',

			'toolbar/translate': 'Position',
			'toolbar/rotate': 'Rotation',
			'toolbar/scale': 'Échelle',
			'toolbar/local': 'Local',

			'viewport/controls/grid': 'Grille',
			'viewport/controls/helpers': 'Helpers',

			'viewport/info/objects': 'Objets',
			'viewport/info/vertices': 'Sommets',
			'viewport/info/triangles': 'Triangles',
			'viewport/info/rendertime': 'Render time'

		},

		zh: {

			'menubar/file': '文件',
			'menubar/file/new': '新建',
			'menubar/file/import': '导入',
			'menubar/file/export/drc': '导出DRC',
			'menubar/file/export/glb': '导出GLB',
			'menubar/file/export/gltf': '导出GLTF',
			'menubar/file/export/obj': '导出OBJ',
			'menubar/file/export/ply': '导出PLY',
			'menubar/file/export/ply_binary': '导出PLY(二进制)',
			'menubar/file/export/stl': '导出STL',
			'menubar/file/export/stl_binary': '导出STL(二进制)',
			'menubar/file/export/usdz': '导出USDZ',

			'menubar/edit': '编辑',
			'menubar/edit/undo': '撤销 (Ctrl+Z)',
			'menubar/edit/redo': '重做 (Ctrl+Shift+Z)',
			'menubar/edit/center': '居中',
			'menubar/edit/clone': '拷贝',
			'menubar/edit/delete': '删除 (Del)',

			'menubar/add': '添加',
			'menubar/add/group': '组',
			'menubar/add/plane': '平面',
			'menubar/add/box': '正方体',
			'menubar/add/capsule': '胶囊',
			'menubar/add/circle': '圆',
			'menubar/add/cylinder': '圆柱体',
			'menubar/add/ring': '环',
			'menubar/add/sphere': '球体',
			'menubar/add/dodecahedron': '十二面体',
			'menubar/add/icosahedron': '二十面体',
			'menubar/add/octahedron': '八面体',
			'menubar/add/tetrahedron': '四面体',
			'menubar/add/torus': '圆环体',
			'menubar/add/torusknot': '环面纽结体',
			'menubar/add/tube': '管',
			'menubar/add/lathe': '酒杯',
			'menubar/add/sprite': '精灵',
			'menubar/add/pointlight': '点光源',
			'menubar/add/spotlight': '聚光灯',
			'menubar/add/directionallight': '平行光',
			'menubar/add/hemispherelight': '半球光',
			'menubar/add/ambientlight': '环境光',
			'menubar/add/perspectivecamera': '透视相机',
			'menubar/add/orthographiccamera': '正交相机',

			'menubar/status/autosave': '自动保存',

			'menubar/examples': '示例',
			'menubar/examples/Arkanoid': '打砖块',
			'menubar/examples/Camera': ' 摄像机',
			'menubar/examples/Particles': '粒子',
			'menubar/examples/Pong': '乒乓球',
			'menubar/examples/Shaders': '着色器',

			'menubar/view': '视图',
			'menubar/view/fullscreen': '全屏',

			'menubar/help': '帮助',
			'menubar/help/source_code': '源码',
			'menubar/help/icons': '图标组件包',
			'menubar/help/about': '关于',
			'menubar/help/manual': '手册',

			'sidebar/animations': '动画',
			'sidebar/animations/play': '播放',
			'sidebar/animations/stop': '暂停',
			'sidebar/animations/timescale': '时间缩放',

			'sidebar/scene': '场景',
			'sidebar/scene/background': '背景',
			'sidebar/scene/environment': '环境',
			'sidebar/scene/fog': '雾',

			'sidebar/properties/object': '属性',
			'sidebar/properties/geometry': '几何组件',
			'sidebar/properties/material': '材质组件',
			'sidebar/properties/script': '脚本',

			'sidebar/object/type': '类型',
			'sidebar/object/new': '更新',
			'sidebar/object/uuid': '识别码',
			'sidebar/object/name': '名称',
			'sidebar/object/position': '位置',
			'sidebar/object/rotation': '旋转',
			'sidebar/object/scale': '缩放',
			'sidebar/object/fov': '视角',
			'sidebar/object/left': '左',
			'sidebar/object/right': '右',
			'sidebar/object/top': '上',
			'sidebar/object/bottom': '下',
			'sidebar/object/near': '近点',
			'sidebar/object/far': '远点',
			'sidebar/object/intensity': '强度',
			'sidebar/object/color': '颜色',
			'sidebar/object/groundcolor': '基色',
			'sidebar/object/distance': '距离',
			'sidebar/object/angle': '角度',
			'sidebar/object/penumbra': '边缘',
			'sidebar/object/decay': '衰减',
			'sidebar/object/shadow': '阴影',
			'sidebar/object/shadowBias': '阴影偏移',
			'sidebar/object/shadowNormalBias': '阴影法线偏移',
			'sidebar/object/shadowRadius': '阴影半径',
			'sidebar/object/cast': '产生',
			'sidebar/object/receive': '接受',
			'sidebar/object/visible': '可见性',
			'sidebar/object/frustumcull': '视锥体裁剪',
			'sidebar/object/renderorder': '渲染次序',
			'sidebar/object/userdata': '自定义数据',
			'sidebar/object/export': '导出JSON',

			'sidebar/geometry/type': '类型',
			'sidebar/geometry/new': '更新',
			'sidebar/geometry/uuid': '识别码',
			'sidebar/geometry/name': '名称',
			'sidebar/geometry/bounds': '界限',
			'sidebar/geometry/show_vertex_normals': '显示顶点法线',
			'sidebar/geometry/compute_vertex_normals': '计算顶点法线',
			'sidebar/geometry/compute_vertex_tangents': 'Compute Tangents',
			'sidebar/geometry/center': '居中',
			'sidebar/geometry/export': '导出JSON',

			'sidebar/geometry/box_geometry/width': '宽度',
			'sidebar/geometry/box_geometry/height': '高度',
			'sidebar/geometry/box_geometry/depth': '深度',
			'sidebar/geometry/box_geometry/widthseg': '宽度分段',
			'sidebar/geometry/box_geometry/heightseg': '高度分段',
			'sidebar/geometry/box_geometry/depthseg': '深度分段',

			'sidebar/geometry/buffer_geometry/attributes': '属性',
			'sidebar/geometry/buffer_geometry/index': '索引',
			'sidebar/geometry/buffer_geometry/morphAttributes': 'Morph Attributes',
			'sidebar/geometry/buffer_geometry/morphRelative': 'Morph Relative',

			'sidebar/geometry/capsule_geometry/radius': '半径',
			'sidebar/geometry/capsule_geometry/length': '长度',
			'sidebar/geometry/capsule_geometry/capseg': '胶囊分段',
			'sidebar/geometry/capsule_geometry/radialseg': '半径分段',

			'sidebar/geometry/circle_geometry/radius': '半径',
			'sidebar/geometry/circle_geometry/segments': '分段',
			'sidebar/geometry/circle_geometry/thetastart': '弧度起点',
			'sidebar/geometry/circle_geometry/thetalength': '弧度长度',

			'sidebar/geometry/cylinder_geometry/radiustop': '顶部半径',
			'sidebar/geometry/cylinder_geometry/radiusbottom': '底部半径',
			'sidebar/geometry/cylinder_geometry/height': '高度',
			'sidebar/geometry/cylinder_geometry/radialsegments': '径向分段',
			'sidebar/geometry/cylinder_geometry/heightsegments': '高度分段',
			'sidebar/geometry/cylinder_geometry/openended': '开端',

			'sidebar/geometry/extrude_geometry/curveSegments': '曲线段',
			'sidebar/geometry/extrude_geometry/steps': '细分点数',
			'sidebar/geometry/extrude_geometry/depth': '深度',
			'sidebar/geometry/extrude_geometry/bevelEnabled': '启用斜角',
			'sidebar/geometry/extrude_geometry/bevelThickness': '斜角厚度',
			'sidebar/geometry/extrude_geometry/bevelSize': '斜角大小',
			'sidebar/geometry/extrude_geometry/bevelOffset': '斜角偏移量',
			'sidebar/geometry/extrude_geometry/bevelSegments': '斜角分段',
			'sidebar/geometry/extrude_geometry/shape': '转换图形',

			'sidebar/geometry/dodecahedron_geometry/radius': '半径',
			'sidebar/geometry/dodecahedron_geometry/detail': '面片分段',

			'sidebar/geometry/icosahedron_geometry/radius': '半径',
			'sidebar/geometry/icosahedron_geometry/detail': '面片分段',

			'sidebar/geometry/octahedron_geometry/radius': '半径',
			'sidebar/geometry/octahedron_geometry/detail': '面片分段',

			'sidebar/geometry/tetrahedron_geometry/radius': '半径',
			'sidebar/geometry/tetrahedron_geometry/detail': '面片分段',

			'sidebar/geometry/lathe_geometry/segments': '分段',
			'sidebar/geometry/lathe_geometry/phistart': '经度起点',
			'sidebar/geometry/lathe_geometry/philength': '经度长度',
			'sidebar/geometry/lathe_geometry/points': '点',

			'sidebar/geometry/plane_geometry/width': '宽度',
			'sidebar/geometry/plane_geometry/height': '长度',
			'sidebar/geometry/plane_geometry/widthsegments': '宽度分段',
			'sidebar/geometry/plane_geometry/heightsegments': '长度分段',

			'sidebar/geometry/ring_geometry/innerRadius': '内半径',
			'sidebar/geometry/ring_geometry/outerRadius': '外半径',
			'sidebar/geometry/ring_geometry/thetaSegments': '弧度分段',
			'sidebar/geometry/ring_geometry/phiSegments': '经度分段',
			'sidebar/geometry/ring_geometry/thetastart': '弧度起点',
			'sidebar/geometry/ring_geometry/thetalength': '弧度长度',

			'sidebar/geometry/shape_geometry/curveSegments': '曲线段',
			'sidebar/geometry/shape_geometry/extrude': '拉伸',

			'sidebar/geometry/sphere_geometry/radius': '半径',
			'sidebar/geometry/sphere_geometry/widthsegments': '宽度分段',
			'sidebar/geometry/sphere_geometry/heightsegments': '长度分段',
			'sidebar/geometry/sphere_geometry/phistart': '经度起点',
			'sidebar/geometry/sphere_geometry/philength': '经度长度',
			'sidebar/geometry/sphere_geometry/thetastart': '纬度起点',
			'sidebar/geometry/sphere_geometry/thetalength': '纬度长度',

			'sidebar/geometry/torus_geometry/radius': '半径',
			'sidebar/geometry/torus_geometry/tube': '管厚',
			'sidebar/geometry/torus_geometry/radialsegments': '半径分段',
			'sidebar/geometry/torus_geometry/tubularsegments': '管厚分段',
			'sidebar/geometry/torus_geometry/arc': '弧度',

			'sidebar/geometry/torusKnot_geometry/radius': '半径',
			'sidebar/geometry/torusKnot_geometry/tube': '管厚',
			'sidebar/geometry/torusKnot_geometry/tubularsegments': '管厚分段',
			'sidebar/geometry/torusKnot_geometry/radialsegments': '半径分段',
			'sidebar/geometry/torusKnot_geometry/p': '管长弧度',
			'sidebar/geometry/torusKnot_geometry/q': '扭曲弧度',

			'sidebar/geometry/tube_geometry/path': '路径',
			'sidebar/geometry/tube_geometry/radius': '半径',
			'sidebar/geometry/tube_geometry/tube': '管厚',
			'sidebar/geometry/tube_geometry/tubularsegments': '管厚分段',
			'sidebar/geometry/tube_geometry/radialsegments': '半径分段',
			'sidebar/geometry/tube_geometry/closed': '闭合',
			'sidebar/geometry/tube_geometry/curvetype': '曲线类型',
			'sidebar/geometry/tube_geometry/tension': '张力',

			'sidebar/material/new': '更新',
			'sidebar/material/copy': '复制',
			'sidebar/material/paste': '粘贴',
			'sidebar/material/slot': '插槽',
			'sidebar/material/type': '类型',
			'sidebar/material/uuid': '识别码',
			'sidebar/material/name': '名称',
			'sidebar/material/program': '程序',
			'sidebar/material/info': '信息',
			'sidebar/material/vertex': '顶点',
			'sidebar/material/fragment': '片元',
			'sidebar/material/color': '颜色',
			'sidebar/material/depthPacking': '深度包装',
			'sidebar/material/roughness': '粗糙度',
			'sidebar/material/metalness': '金属度',
			'sidebar/material/reflectivity': '反射率',
			'sidebar/material/emissive': '自发光',
			'sidebar/material/specular': '高光',
			'sidebar/material/shininess': '高光大小',
			'sidebar/material/clearcoat': '清漆',
			'sidebar/material/clearcoatroughness': '清漆粗糙度',
			'sidebar/material/iridescence': '彩虹色',
			'sidebar/material/iridescenceIOR': '彩虹色折射率',
			'sidebar/material/iridescenceThicknessMax': '彩虹色厚度',
			'sidebar/material/sheen': 'Sheen',
			'sidebar/material/sheenroughness': 'Sheen Roughness',
			'sidebar/material/sheencolor': 'Sheen Color',
			'sidebar/material/transmission': '透光',
			'sidebar/material/attenuationDistance': '衰减距离',
			'sidebar/material/attenuationColor': '衰减色',
			'sidebar/material/thickness': '厚度',
			'sidebar/material/vertexcolors': '顶点颜色',
			'sidebar/material/matcap': '材质捕获',
			'sidebar/material/map': '贴图',
			'sidebar/material/alphamap': '透明贴图',
			'sidebar/material/bumpmap': '凹凸贴图',
			'sidebar/material/normalmap': '法线贴图',
			'sidebar/material/clearcoatnormalmap': '清漆法线贴图',
			'sidebar/material/displacementmap': '置换贴图',
			'sidebar/material/roughnessmap': '粗糙贴图',
			'sidebar/material/metalnessmap': '金属贴图',
			'sidebar/material/specularmap': '高光贴图',
			'sidebar/material/iridescencemap': '彩虹色贴图',
			'sidebar/material/iridescencethicknessmap': '彩虹色厚度贴图',
			'sidebar/material/sheencolormap': 'Sheen Color Map',
			'sidebar/material/sheenroughnessmap': 'Sheen Rough. Map',
			'sidebar/material/envmap': '环境贴图',
			'sidebar/material/lightmap': '光照贴图',
			'sidebar/material/aomap': '环境光遮蔽贴图',
			'sidebar/material/emissivemap': '自发光贴图',
			'sidebar/material/gradientmap': '渐变贴图',
			'sidebar/material/transmissionmap': '透光贴图',
			'sidebar/material/thicknessmap': '厚度贴图',
			'sidebar/material/side': '面',
			'sidebar/material/size': '大小',
			'sidebar/material/sizeAttenuation': '大小衰减',
			'sidebar/material/flatShading': '平面着色',
			'sidebar/material/blending': '混合',
			'sidebar/material/opacity': '透明度',
			'sidebar/material/transparent': '透明性',
			'sidebar/material/forcesinglepass': 'Force Single Pass',
			'sidebar/material/alphatest': 'α测试',
			'sidebar/material/depthtest': '深度测试',
			'sidebar/material/depthwrite': '深度缓冲',
			'sidebar/material/wireframe': '线框',
			'sidebar/material/userdata': '自定义数据',
			'sidebar/material/export': '导出JSON',

			'sidebar/script/new': '新建',
			'sidebar/script/edit': '编辑',
			'sidebar/script/remove': '删除',

			'sidebar/project': '项目',
			'sidebar/project/antialias': '抗锯齿',
			'sidebar/project/shadows': '阴影',
			'sidebar/project/toneMapping': '色调映射',
			'sidebar/project/materials': '材质',
			'sidebar/project/Assign': '应用',

			'sidebar/project/app': 'App',
			'sidebar/project/app/play': '启动',
			'sidebar/project/app/stop': '暂停',
			'sidebar/project/app/title': '标题',
			'sidebar/project/app/editable': '编辑性',
			'sidebar/project/app/publish': '发布',

			'sidebar/project/image': 'Image',
			'sidebar/project/video': '视频',

			'sidebar/project/shading': 'Shading',
			'sidebar/project/resolution': '分辨率',
			'sidebar/project/duration': '时长',
			'sidebar/project/render': '渲染',

			'sidebar/settings': '设置',
			'sidebar/settings/language': '语言',

			'sidebar/settings/shortcuts': '快捷键',
			'sidebar/settings/shortcuts/translate': '移动',
			'sidebar/settings/shortcuts/rotate': '旋转',
			'sidebar/settings/shortcuts/scale': '缩放',
			'sidebar/settings/shortcuts/undo': '撤销',
			'sidebar/settings/shortcuts/focus': '聚焦',

			'sidebar/history': '历史记录',
			'sidebar/history/clear': '清空',
			'sidebar/history/persistent': '本地存储',

			'toolbar/translate': '移动',
			'toolbar/rotate': '旋转',
			'toolbar/scale': '缩放',
			'toolbar/local': '本地',

			'viewport/controls/grid': '网格',
			'viewport/controls/helpers': '辅助',

			'viewport/info/objects': '物体',
			'viewport/info/vertices': '顶点',
			'viewport/info/triangles': '三角形',
			'viewport/info/rendertime': 'Render time'

		},

		ja: {

			'menubar/file': 'ファイル',
			'menubar/file/new': '新規',
			'menubar/file/import': 'インポート',
			'menubar/file/export/drc': 'エクスポート DRC',
			'menubar/file/export/glb': 'エクスポート GLB',
			'menubar/file/export/gltf': 'エクスポート GLTF',
			'menubar/file/export/obj': 'エクスポート OBJ',
			'menubar/file/export/ply': 'エクスポート PLY',
			'menubar/file/export/ply_binary': 'エクスポート PLY(バイナリ)',
			'menubar/file/export/stl': 'エクスポート STL',
			'menubar/file/export/stl_binary': 'エクスポート STL(バイナリ)',
			'menubar/file/export/usdz': 'エクスポート USDZ',

			'menubar/edit': '編集',
			'menubar/edit/undo': '元に戻す（Ctrl+Z）',
			'menubar/edit/redo': 'やり直す（Ctrl+Shift+Z）',
			'menubar/edit/center': '中央揃え',
			'menubar/edit/clone': '複製',
			'menubar/edit/delete': '削除（Del）',

			'menubar/add': '追加',
			'menubar/add/group': 'グループ',
			'menubar/add/plane': '平面',
			'menubar/add/box': '直方体',
			'menubar/add/capsule': 'カプセル',
			'menubar/add/circle': '円',
			'menubar/add/cylinder': '円柱',
			'menubar/add/ring': 'リング',
			'menubar/add/sphere': '球',
			'menubar/add/dodecahedron': '十二面体',
			'menubar/add/icosahedron': '二十面体',
			'menubar/add/octahedron': '八面体',
			'menubar/add/tetrahedron': '四面体',
			'menubar/add/torus': 'トーラス',
			'menubar/add/tube': 'チューブ',
			'menubar/add/torusknot': 'ノットトーラス',
			'menubar/add/lathe': '旋盤形',
			'menubar/add/sprite': 'スプライト',
			'menubar/add/pointlight': 'ポイントライト',
			'menubar/add/spotlight': 'スポットライト',
			'menubar/add/directionallight': 'ディレクショナルライト',
			'menubar/add/hemispherelight': 'ヘミスフィアライト',
			'menubar/add/ambientlight': 'アンビエントライト',
			'menubar/add/perspectivecamera': '透視投影カメラ',
			'menubar/add/orthographiccamera': '平行投影カメラ',

			'menubar/status/autosave': '自動保存',

			'menubar/examples': 'サンプル',
			'menubar/examples/Arkanoid': 'ブロック崩し',
			'menubar/examples/Camera': 'カメラ',
			'menubar/examples/Particles': 'パーティクル',
			'menubar/examples/Pong': 'ピンポン',
			'menubar/examples/Shaders': 'シェーダー',

			'menubar/view': '表示',
			'menubar/view/fullscreen': 'フルスクリーン',

			'menubar/help': 'ヘルプ',
			'menubar/help/source_code': 'ソースコード',
			'menubar/help/icons': 'アイコンパック',
			'menubar/help/about': 'Three.js について',
			'menubar/help/manual': 'マニュアル',

			'sidebar/animations': 'アニメーション',
			'sidebar/animations/play': '再生',
			'sidebar/animations/stop': '停止',
			'sidebar/animations/timescale': 'タイムスケール',

			'sidebar/scene': 'シーン',
			'sidebar/scene/background': '背景',
			'sidebar/scene/environment': '環境',
			'sidebar/scene/fog': '霧',

			'sidebar/properties/object': 'オブジェクト',
			'sidebar/properties/geometry': 'ジオメトリ',
			'sidebar/properties/material': 'マテリアル',
			'sidebar/properties/script': 'スクリプト',

			'sidebar/object/type': 'タイプ',
			'sidebar/object/new': '新規',
			'sidebar/object/uuid': 'UUID',
			'sidebar/object/name': '名前',
			'sidebar/object/position': '位置',
			'sidebar/object/rotation': '回転',
			'sidebar/object/scale': 'スケール',
			'sidebar/object/fov': 'Fov',
			'sidebar/object/left': '左',
			'sidebar/object/right': '右',
			'sidebar/object/top': '上',
			'sidebar/object/bottom': '下',
			'sidebar/object/near': '範囲の開始',
			'sidebar/object/far': '範囲の終了',
			'sidebar/object/intensity': '強度',
			'sidebar/object/color': '色',
			'sidebar/object/groundcolor': '地面の色',
			'sidebar/object/distance': '距離',
			'sidebar/object/angle': '角度',
			'sidebar/object/penumbra': '半影',
			'sidebar/object/decay': '減衰',
			'sidebar/object/shadow': '影',
			'sidebar/object/shadowBias': '影のバイアス',
			'sidebar/object/shadowNormalBias': '影のノーマルバイアス',
			'sidebar/object/shadowRadius': '影の半径',
			'sidebar/object/cast': 'キャスト',
			'sidebar/object/receive': 'レシーブ',
			'sidebar/object/visible': '表示',
			'sidebar/object/frustumcull': 'フラスタムカリング',
			'sidebar/object/renderorder': '描画順序',
			'sidebar/object/userdata': 'ユーザーデータ',
			'sidebar/object/export': 'JSONをエクスポート',

			'sidebar/geometry/type': 'タイプ',
			'sidebar/geometry/new': '新規',
			'sidebar/geometry/uuid': 'UUID',
			'sidebar/geometry/name': '名前',
			'sidebar/geometry/bounds': '境界',
			'sidebar/geometry/show_vertex_normals': '頂点法線を表示',
			'sidebar/geometry/compute_vertex_normals': '頂点法線を計算',
			'sidebar/geometry/compute_vertex_tangents': '接線を計算',
			'sidebar/geometry/center': '中央',
			'sidebar/geometry/export': 'JSONをエクスポート',

			'sidebar/geometry/box_geometry/width': '幅',
			'sidebar/geometry/box_geometry/height': '高さ',
			'sidebar/geometry/box_geometry/depth': '奥行き',
			'sidebar/geometry/box_geometry/widthseg': '幅の分割数',
			'sidebar/geometry/box_geometry/heightseg': '高さの分割数',
			'sidebar/geometry/box_geometry/depthseg': '奥行きの分割数',

			'sidebar/geometry/buffer_geometry/attributes': '属性',
			'sidebar/geometry/buffer_geometry/index': 'インデックス',
			'sidebar/geometry/buffer_geometry/morphAttributes': 'モーフ属性',
			'sidebar/geometry/buffer_geometry/morphRelative': '相対モーフ',

			'sidebar/geometry/capsule_geometry/radius': '半径',
			'sidebar/geometry/capsule_geometry/length': '長さ',
			'sidebar/geometry/capsule_geometry/capseg': 'キャップの分割数',
			'sidebar/geometry/capsule_geometry/radialseg': '円の分割数',

			'sidebar/geometry/circle_geometry/radius': '半径',
			'sidebar/geometry/circle_geometry/segments': 'セグメント',
			'sidebar/geometry/circle_geometry/thetastart': '開始角度',
			'sidebar/geometry/circle_geometry/thetalength': '角度の大きさ',

			'sidebar/geometry/cylinder_geometry/radiustop': '上部の半径',
			'sidebar/geometry/cylinder_geometry/radiusbottom': '下部の半径',
			'sidebar/geometry/cylinder_geometry/height': '高さ',
			'sidebar/geometry/cylinder_geometry/radialsegments': '円の分割数',
			'sidebar/geometry/cylinder_geometry/heightsegments': '高さの分割数',
			'sidebar/geometry/cylinder_geometry/openended': 'ふた',

			'sidebar/geometry/extrude_geometry/curveSegments': '分割数',
			'sidebar/geometry/extrude_geometry/steps': 'ステップ',
			'sidebar/geometry/extrude_geometry/depth': '深さ',
			'sidebar/geometry/extrude_geometry/bevelEnabled': 'ベベルを有効にするか？',
			'sidebar/geometry/extrude_geometry/bevelThickness': 'ベベルの厚さ',
			'sidebar/geometry/extrude_geometry/bevelSize': 'ベベルのサイズ',
			'sidebar/geometry/extrude_geometry/bevelOffset': 'ベベルのオフセット',
			'sidebar/geometry/extrude_geometry/bevelSegments': 'ベベルの分割数',
			'sidebar/geometry/extrude_geometry/shape': '形状に変換',

			'sidebar/geometry/dodecahedron_geometry/radius': '半径',
			'sidebar/geometry/dodecahedron_geometry/detail': '詳細',

			'sidebar/geometry/icosahedron_geometry/radius': '半径',
			'sidebar/geometry/icosahedron_geometry/detail': '詳細',

			'sidebar/geometry/octahedron_geometry/radius': '半径',
			'sidebar/geometry/octahedron_geometry/detail': '詳細',

			'sidebar/geometry/tetrahedron_geometry/radius': '半径',
			'sidebar/geometry/tetrahedron_geometry/detail': '詳細',

			'sidebar/geometry/lathe_geometry/segments': '分割数',
			'sidebar/geometry/lathe_geometry/phistart': '開始角度',
			'sidebar/geometry/lathe_geometry/philength': '角度の大きさ',
			'sidebar/geometry/lathe_geometry/points': 'ポイント',

			'sidebar/geometry/plane_geometry/width': '幅',
			'sidebar/geometry/plane_geometry/height': '高さ',
			'sidebar/geometry/plane_geometry/widthsegments': '幅の分割数',
			'sidebar/geometry/plane_geometry/heightsegments': '奥行きの分割数',

			'sidebar/geometry/ring_geometry/innerRadius': '内半径',
			'sidebar/geometry/ring_geometry/outerRadius': '外半径',
			'sidebar/geometry/ring_geometry/thetaSegments': '円の分割数',
			'sidebar/geometry/ring_geometry/phiSegments': 'リングの分割数',
			'sidebar/geometry/ring_geometry/thetastart': '開始角度',
			'sidebar/geometry/ring_geometry/thetalength': '角度の大きさ',

			'sidebar/geometry/shape_geometry/curveSegments': '分割数',
			'sidebar/geometry/shape_geometry/extrude': '押し出し',

			'sidebar/geometry/sphere_geometry/radius': '半径',
			'sidebar/geometry/sphere_geometry/widthsegments': '円の分割数',
			'sidebar/geometry/sphere_geometry/heightsegments': 'リングの分割数',
			'sidebar/geometry/sphere_geometry/phistart': '開始角度',
			'sidebar/geometry/sphere_geometry/philength': '角度の大きさ',
			'sidebar/geometry/sphere_geometry/thetastart': '開始角度',
			'sidebar/geometry/sphere_geometry/thetalength': '角度の大きさ',

			'sidebar/geometry/torus_geometry/radius': '半径',
			'sidebar/geometry/torus_geometry/tube': 'チューブの太さ',
			'sidebar/geometry/torus_geometry/radialsegments': '小セグメント数',
			'sidebar/geometry/torus_geometry/tubularsegments': '大セグメント数',
			'sidebar/geometry/torus_geometry/arc': '弧',

			'sidebar/geometry/torusKnot_geometry/radius': '半径',
			'sidebar/geometry/torusKnot_geometry/tube': 'チューブの太さ',
			'sidebar/geometry/torusKnot_geometry/tubularsegments': '小セグメント数',
			'sidebar/geometry/torusKnot_geometry/radialsegments': '大セグメント数',
			'sidebar/geometry/torusKnot_geometry/p': 'P',
			'sidebar/geometry/torusKnot_geometry/q': 'Q',

			'sidebar/geometry/tube_geometry/path': 'パス',
			'sidebar/geometry/tube_geometry/radius': '半径',
			'sidebar/geometry/tube_geometry/tube': 'チューブの太さ',
			'sidebar/geometry/tube_geometry/tubularsegments': '小セグメント数',
			'sidebar/geometry/tube_geometry/radialsegments': '大セグメント数',
			'sidebar/geometry/tube_geometry/closed': '閉じる',
			'sidebar/geometry/tube_geometry/curvetype': 'カーブタイプ',
			'sidebar/geometry/tube_geometry/tension': 'テンション',

			'sidebar/material/new': '新規作成',
			'sidebar/material/copy': 'コピー',
			'sidebar/material/paste': '貼り付け',
			'sidebar/material/slot': 'スロット',
			'sidebar/material/type': 'タイプ',
			'sidebar/material/uuid': 'UUID',
			'sidebar/material/name': '名前',
			'sidebar/material/program': 'プログラム',
			'sidebar/material/info': '情報',
			'sidebar/material/vertex': '頂点',
			'sidebar/material/fragment': 'フラグメント',
			'sidebar/material/color': '色',
			'sidebar/material/depthPacking': '深度パッキング',
			'sidebar/material/roughness': '粗さ',
			'sidebar/material/metalness': '金属度',
			'sidebar/material/reflectivity': '反射率',
			'sidebar/material/emissive': '発光',
			'sidebar/material/specular': '鏡面',
			'sidebar/material/shininess': '光沢',
			'sidebar/material/clearcoat': 'クリアコート',
			'sidebar/material/clearcoatroughness': 'クリアコートの粗さ',
			'sidebar/material/iridescence': '遊色効果',
			'sidebar/material/iridescenceIOR': '遊色効果のIOR',
			'sidebar/material/iridescenceThicknessMax': '遊色効果の厚さ',
			'sidebar/material/sheen': '光沢',
			'sidebar/material/sheenroughness': '光沢の粗さ',
			'sidebar/material/sheencolor': '光沢の色',
			'sidebar/material/transmission': '透過',
			'sidebar/material/attenuationDistance': '減衰距離',
			'sidebar/material/attenuationColor': '減衰色',
			'sidebar/material/thickness': '厚さ',
			'sidebar/material/vertexcolors': '頂点色',
			'sidebar/material/matcap': 'マットキャップ',
			'sidebar/material/map': 'マップ',
			'sidebar/material/alphamap': 'アルファマップ',
			'sidebar/material/bumpmap': 'バンプマップ',
			'sidebar/material/normalmap': 'ノーマルマップ',
			'sidebar/material/clearcoatmap': 'クリアコートマップ',
			'sidebar/material/clearcoatnormalmap': 'クリアコートノーマルマップ',
			'sidebar/material/clearcoatroughnessmap': 'クリアコート粗さマップ',
			'sidebar/material/displacementmap': '変位マップ',
			'sidebar/material/roughnessmap': '粗さマップ',
			'sidebar/material/metalnessmap': 'メタリックマップ',
			'sidebar/material/specularmap': '鏡面マップ',
			'sidebar/material/iridescencemap': '遊色効果マップ',
			'sidebar/material/iridescencethicknessmap': '遊色効果の厚さマップ',
			'sidebar/material/sheencolormap': '光沢色マップ',
			'sidebar/material/sheenroughnessmap': '光沢粗さマップ',
			'sidebar/material/envmap': '環境マップ',
			'sidebar/material/lightmap': 'ライトマップ',
			'sidebar/material/aomap': 'AOマップ',
			'sidebar/material/emissivemap': '発光マップ',
			'sidebar/material/gradientmap': 'グラデーションマップ',
			'sidebar/material/transmissionmap': '透過マップ',
			'sidebar/material/thicknessmap': '厚さマップ',
			'sidebar/material/side': '側面',
			'sidebar/material/size': 'サイズ',
			'sidebar/material/sizeAttenuation': 'サイズ減衰',
			'sidebar/material/flatShading': 'フラットシェーディング',
			'sidebar/material/blending': 'ブレンディング',
			'sidebar/material/opacity': '不透明度',
			'sidebar/material/transparent': '透明',
			'sidebar/material/forcesinglepass': 'シングルパスを強制',
			'sidebar/material/alphatest': 'アルファテスト',
			'sidebar/material/depthtest': '深度テスト',
			'sidebar/material/depthwrite': '深度書き込み',
			'sidebar/material/wireframe': 'ワイヤーフレーム',
			'sidebar/material/userdata': 'ユーザーデータ',
			'sidebar/material/export': 'JSONをエクスポート',

			'sidebar/script/new': '新規',
			'sidebar/script/edit': '編集',
			'sidebar/script/remove': '削除',

			'sidebar/project': 'プロジェクト',
			'sidebar/project/antialias': 'アンチエイリアス',
			'sidebar/project/shadows': 'シャドウ',
			'sidebar/project/toneMapping': 'トーンマッピング',
			'sidebar/project/materials': 'マテリアル',
			'sidebar/project/Assign': '割り当て',

			'sidebar/project/app': 'アプリ',
			'sidebar/project/app/play': '再生',
			'sidebar/project/app/stop': '停止',
			'sidebar/project/app/title': 'タイトル',
			'sidebar/project/app/editable': '編集可能',
			'sidebar/project/app/publish': 'アプリファイルとして保存',

			'sidebar/project/image': '画像',
			'sidebar/project/video': '動画',

			'sidebar/project/shading': 'シェーディング',
			'sidebar/project/resolution': '解像度',
			'sidebar/project/duration': '長さ',
			'sidebar/project/render': 'レンダー',

			'sidebar/settings': '設定',
			'sidebar/settings/language': '言語',

			'sidebar/settings/shortcuts': 'ショートカット',
			'sidebar/settings/shortcuts/translate': '移動',
			'sidebar/settings/shortcuts/rotate': '回転',
			'sidebar/settings/shortcuts/scale': 'スケール',
			'sidebar/settings/shortcuts/undo': '元に戻す',
			'sidebar/settings/shortcuts/focus': 'フォーカス',

			'sidebar/history': '履歴',
			'sidebar/history/clear': 'クリア',
			'sidebar/history/persistent': '永続的',

			'toolbar/translate': '移動',
			'toolbar/rotate': '回転',
			'toolbar/scale': 'スケール',
			'toolbar/local': 'ローカル',

			'viewport/controls/grid': 'グリッド',
			'viewport/controls/helpers': 'オーバーレイ表示',

			'viewport/info/objects': 'オブジェクト',
			'viewport/info/vertices': '頂点',
			'viewport/info/triangles': '三角形',
			'viewport/info/rendertime': 'レンダリング時間'

		}

	};

	return {

		getKey: function ( key ) {

			return values[ language ][ key ] || '???';

		}

	};

}

export { Strings };
