## 如何导入本项目

1. 将 luohuo-util/pom.xml 导入IDEA
2. 编译luohuo-util/pom.xml： mvn clean install -Dmaven.javadoc.skip=true -Dgpg.skip=true -Dmaven.source.skip=true
   -DskipTests=true

## 如何编译 luohuo-util ?

```
# 跳过 生成javadoc
mvn clean install -Dmaven.javadoc.skip=true -Dgpg.skip=true
# 跳过 生成源代码
mvn clean install -Dmaven.source.skip=true
# 跳过 发布jar到中央仓库
clean install -Dgpg.skip -f pom.xml

# 同时跳过 生成javadoc、生成源代码、发布jar到中央仓库、单元测试， 只编译源码到本地仓库
mvn clean install  -Dmaven.javadoc.skip=true -Dgpg.skip=true -Dmaven.source.skip=true -DskipTests=true -f pom.xml

# 编译 同时生成源代码和javadoc和发布
mvn clean install
```

## 如何解决 IDEA 控制台生成javadoc时乱码

```
# mac
IntelliJ IDEA -> Preferences  -> Build, Execution, Deployment -> Build Tools ->  Maven -> Runner 
在 Environment variables: 加入  JAVA_TOOL_OPTIONS=-Dfile.encoding=UTF-8

# window
File -> Settings -> Build, Execution, Deployment-> Build Tools ->  Maven -> Runner 
在VM Options： 加入  -Dfile.encoding=GBK

# 还不行就在命令行执行 mvn -version  看看 mvn 的编码是什么，改成一样的即可。
```

## 统一升级版本号

mvn versions:set -DnewVersion="3.0.0" -DskipTests -DgenerateBackupPoms=false

mvn versions:set -DnewVersion="3.0.0-SNAPSHOT" -DskipTests -DgenerateBackupPoms=false

