﻿#include "qthelperdata.h"
#include "qthelper.h"

int QtHelperData::strHexToDecimal(const QString &strHex)
{
    bool ok;
    return strHex.toInt(&ok, 16);
}

int QtHelperData::strDecimalToDecimal(const QString &strDecimal)
{
    bool ok;
    return strDecimal.toInt(&ok, 10);
}

int QtHelperData::strBinToDecimal(const QString &strBin)
{
    bool ok;
    return strBin.toInt(&ok, 2);
}

QString QtHelperData::strHexToStrBin(const QString &strHex)
{
    quint8 decimal = strHexToDecimal(strHex);
    QString bin = QString::number(decimal, 2);
    quint8 len = bin.length();

    if (len < 8) {
        for (int i = 0; i < 8 - len; ++i) {
            bin = "0" + bin;
        }
    }

    return bin;
}

QString QtHelperData::decimalToStrBin1(int decimal)
{
    QString bin = QString::number(decimal, 2);
    quint8 len = bin.length();
    if (len <= 8) {
        for (int i = 0; i < 8 - len; ++i) {
            bin = "0" + bin;
        }
    }

    return bin;
}

QString QtHelperData::decimalToStrBin2(int decimal)
{
    QString bin = QString::number(decimal, 2);
    quint8 len = bin.length();
    if (len <= 16) {
        for (int i = 0; i < 16 - len; ++i) {
            bin = "0" + bin;
        }
    }

    return bin;
}

QString QtHelperData::decimalToStrHex(int decimal)
{
    QString temp = QString::number(decimal, 16);
    if (temp.length() == 1) {
        temp = "0" + temp;
    }

    return temp;
}

QByteArray QtHelperData::intToByte(int data, bool reverse)
{
    quint8 data1 = (quint8)(0x000000ff & data);
    quint8 data2 = (quint8)((0x0000ff00 & data) >> 8);
    quint8 data3 = (quint8)((0x00ff0000 & data) >> 16);
    quint8 data4 = (quint8)((0xff000000 & data) >> 24);

    QByteArray result;
    result.resize(4);
    if (reverse) {
        result[0] = data1;
        result[1] = data2;
        result[2] = data3;
        result[3] = data4;
    } else {
        result[0] = data4;
        result[1] = data3;
        result[2] = data2;
        result[3] = data1;
    }
    return result;
}

int QtHelperData::byteToInt(const QByteArray &data, bool reverse)
{
    int result = 0;
    if (reverse) {
        result = data.at(0) & 0x000000ff;
        result |= ((data.at(1) << 8) & 0x0000ff00);
        result |= ((data.at(2) << 16) & 0x00ff0000);
        result |= ((data.at(3) << 24) & 0xff000000);
    } else {
        result = data.at(3) & 0x000000ff;
        result |= ((data.at(2) << 8) & 0x0000ff00);
        result |= ((data.at(1) << 16) & 0x00ff0000);
        result |= ((data.at(0) << 24) & 0xff000000);
    }
    return result;
}

QByteArray QtHelperData::ushortToByte(int data, bool reverse)
{
    quint8 data1 = (quint8)(0x000000ff & data);
    quint8 data2 = (quint8)((0x0000ff00 & data) >> 8);

    QByteArray result;
    result.resize(2);
    if (reverse) {
        result[0] = data1;
        result[1] = data2;
    } else {
        result[0] = data2;
        result[1] = data1;
    }
    return result;
}

int QtHelperData::byteToShort(const QByteArray &data, bool reverse)
{
    int result = 0;
    if (reverse) {
        result = data.at(0) & 0x000000ff;
        result |= ((data.at(1) << 8) & 0x0000ff00);
    } else {
        result = data.at(1) & 0x000000ff;
        result |= ((data.at(0) << 8) & 0x0000ff00);
    }
    if (result >= 32768) {
        result = result - 65536;
    }
    return result;
}

QString QtHelperData::getValue(quint8 value)
{
    QString result = QString::number(value);
    if (result.length() <= 1) {
        result = QString("0%1").arg(result);
    }
    return result;
}

QString QtHelperData::trimmed(const QString &text, int type)
{
    QString temp = text;
    QString pattern;
    if (type == -1) {
        pattern = "^ +\\s*";
    } else if (type == 0) {
        pattern = "\\s";
        //temp.replace(" ", "");
    } else if (type == 1) {
        pattern = "\\s* +$";
    } else if (type == 2) {
        temp = temp.trimmed();
    } else if (type == 3) {
        temp = temp.simplified();
    }

    //调用正则表达式移除空格
    if (!pattern.isEmpty()) {
#if (QT_VERSION >= QT_VERSION_CHECK(6,0,0))
        temp.remove(QRegularExpression(pattern));
#else
        temp.remove(QRegExp(pattern));
#endif
    }

    return temp;
}

QString QtHelperData::getXorEncryptDecrypt(const QString &value, char key)
{
    //矫正范围外的数据
    if (key < 0 || key >= 127) {
        key = 127;
    }

    //大概从5.9版本输出的加密密码字符串前面会加上 @String 字符
    QString result = value;
    if (result.startsWith("@String")) {
        result = result.mid(8, result.length() - 9);
    }

    for (int i = 0; i < result.length(); ++i) {
        result[i] = QChar(result.at(i).toLatin1() ^ key);
    }

    return result;
}

quint8 QtHelperData::getOrCode(const QByteArray &data)
{
    quint8 result = 0;
    int len = data.length();
    for (int i = 0; i < len; ++i) {
        result ^= (quint8)data.at(i);
    }

    return result;
}

quint8 QtHelperData::getCheckCode(const QByteArray &data)
{
    quint8 result = 0;
    int len = data.length();
    for (int i = 0; i < len; ++i) {
        result += (quint8)data.at(i);
    }

    return result % 256;
}

void QtHelperData::getFullData(QByteArray &buffer)
{
    //计算校验码
    quint8 checkCode = getCheckCode(buffer);
    //尾部插入校验码
    buffer.append(checkCode);
    //头部插入固定帧头
    buffer.insert(0, 0x16);
}

//函数功能：计算CRC16
//参数1：*data 16位CRC校验数据，
//参数2：len   数据流长度
//参数3：init  初始化值
//参数4：table 16位CRC查找表

//正序CRC计算
quint16 QtHelperData::getCrc16(quint8 *data, int len, quint16 init, const quint16 *table)
{
    quint16 crc_16 = init;
    quint8 temp;
    while (len-- > 0) {
        temp = crc_16 & 0xff;
        crc_16 = (crc_16 >> 8) ^ table[(temp ^ *data++) & 0xff];
    }

    return crc_16;
}

//逆序CRC计算
quint16 QtHelperData::getCrc16Rec(quint8 *data, int len, quint16 init, const quint16 *table)
{
    quint16 crc_16 = init;
    quint8 temp;
    while (len-- > 0) {
        temp = crc_16 >> 8;
        crc_16 = (crc_16 << 8) ^ table[(temp ^ *data++) & 0xff];
    }

    return crc_16;
}

//Modbus CRC16校验
quint16 QtHelperData::getModbus16(quint8 *data, int len)
{
    //MODBUS CRC-16表 8005 逆序
    const quint16 table_16[256] = {
        0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,
        0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,
        0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,
        0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,
        0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,
        0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,
        0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,
        0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,
        0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,
        0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,
        0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,
        0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,
        0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,
        0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,
        0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,
        0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,
        0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,
        0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,
        0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,
        0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,
        0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,
        0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,
        0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,
        0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,
        0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,
        0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,
        0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,
        0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,
        0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,
        0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,
        0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,
        0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040
    };

    return getCrc16(data, len, 0xFFFF, table_16);
}

//CRC16校验
QByteArray QtHelperData::getCrcCode(const QByteArray &data)
{
    quint16 result = getModbus16((quint8 *)data.data(), data.length());
    return QtHelperData::ushortToByte(result, true);
}

static QMap<char, QString> listChar;
void QtHelperData::initAscii()
{
    //0x20为空格,空格以下都是不可见字符
    if (listChar.count() == 0) {
        listChar.insert(0, "\\NUL");
        listChar.insert(1, "\\SOH");
        listChar.insert(2, "\\STX");
        listChar.insert(3, "\\ETX");
        listChar.insert(4, "\\EOT");
        listChar.insert(5, "\\ENQ");
        listChar.insert(6, "\\ACK");
        listChar.insert(7, "\\BEL");
        listChar.insert(8, "\\BS");
        listChar.insert(9, "\\HT");
        listChar.insert(10, "\\LF");
        listChar.insert(11, "\\VT");
        listChar.insert(12, "\\FF");
        listChar.insert(13, "\\CR");
        listChar.insert(14, "\\SO");
        listChar.insert(15, "\\SI");
        listChar.insert(16, "\\DLE");
        listChar.insert(17, "\\DC1");
        listChar.insert(18, "\\DC2");
        listChar.insert(19, "\\DC3");
        listChar.insert(20, "\\DC4");
        listChar.insert(21, "\\NAK");
        listChar.insert(22, "\\SYN");
        listChar.insert(23, "\\ETB");
        listChar.insert(24, "\\CAN");
        listChar.insert(25, "\\EM");
        listChar.insert(26, "\\SUB");
        listChar.insert(27, "\\ESC");
        listChar.insert(28, "\\FS");
        listChar.insert(29, "\\GS");
        listChar.insert(30, "\\RS");
        listChar.insert(31, "\\US");
        listChar.insert(0x5C, "\\");
        listChar.insert(0x7F, "\\DEL");
    }
}

QString QtHelperData::byteArrayToAsciiStr(const QByteArray &data)
{
    //先初始化字符表
    initAscii();

    QString temp;
    int len = data.length();
    for (int i = 0; i < len; ++i) {
        int byte = data.at(i);
        QString value = listChar.value(byte);
        if (!value.isEmpty()) {
        } else if (byte >= 0 && byte <= 0x7F) {
            value = QString("%1").arg(byte);
        } else {
            value = decimalToStrHex(byte);
            value = QString("\\x%1").arg(value.toUpper());
        }

        temp += value;
    }

    return temp.trimmed();
}

QByteArray QtHelperData::asciiStrToByteArray(const QString &data)
{
    //先初始化字符表
    initAscii();

    QByteArray buffer;
    QStringList list = data.split("\\");

    int count = list.count();
    for (int i = 1; i < count; ++i) {
        QString str = list.at(i);
        int key = 0;
        if (str.contains("x")) {
            key = strHexToDecimal(str.mid(1, 2));
        } else {
            key = listChar.key("\\" + str);
        }

        buffer.append(key);
    }

    //可能是纯字符串不带控制字符
    if (buffer.length() == 0) {
        buffer = data.toUtf8();
    }

    return buffer;
}

char QtHelperData::hexStrToChar(char data)
{
    if ((data >= '0') && (data <= '9')) {
        return data - 0x30;
    } else if ((data >= 'A') && (data <= 'F')) {
        return data - 'A' + 10;
    } else if ((data >= 'a') && (data <= 'f')) {
        return data - 'a' + 10;
    } else {
        return (-1);
    }
}

QByteArray QtHelperData::hexStrToByteArray(const QString &data)
{
    QByteArray senddata;
    int hexdata, lowhexdata;
    int hexdatalen = 0;
    int len = data.length();
    senddata.resize(len / 2);
    char lstr, hstr;

    for (int i = 0; i < len;) {
        hstr = data.at(i).toLatin1();
        if (hstr == ' ') {
            i++;
            continue;
        }

        i++;
        if (i >= len) {
            break;
        }

        lstr = data.at(i).toLatin1();
        hexdata = hexStrToChar(hstr);
        lowhexdata = hexStrToChar(lstr);

        if ((hexdata == 16) || (lowhexdata == 16)) {
            break;
        } else {
            hexdata = hexdata * 16 + lowhexdata;
        }

        i++;
        senddata[hexdatalen] = (char)hexdata;
        hexdatalen++;
    }

    senddata.resize(hexdatalen);
    return senddata;
}

QString QtHelperData::byteArrayToHexStr(const QByteArray &data)
{
    QString temp = "";
    QString hex = data.toHex();
    for (int i = 0; i < hex.length(); i = i + 2) {
        temp += hex.mid(i, 2) + " ";
    }

    return temp.trimmed().toUpper();
}
