const jaJP = {
  common: {
    login: 'ログイン',
    logout: 'ログアウト',
    accountOptions: 'システム設定',
    account: 'アカウント',
    integration: '連携',
    email: 'メールアドレス',
    password: 'パスワード',
    welcome: 'LangBot へおかえりなさい 👋',
    continueToLogin: 'ログインしてください',
    loginSuccess: 'ログインに成功しました',
    loginFailed:
      'ログインに失敗しました。メールアドレスまたはパスワードをご確認ください',
    enterEmail: 'メールアドレスを入力',
    enterPassword: 'パスワードを入力',
    invalidEmail: '有効なメールアドレスを入力してください',
    emptyPassword: 'パスワードを入力してください',
    language: '言語',
    helpDocs: 'ヘルプドキュメント',
    featureRequest: '機能リクエスト',
    create: '作成',
    edit: '編集',
    delete: '削除',
    add: '追加',
    select: '選択してください',
    cancel: 'キャンセル',
    submit: '送信',
    error: 'エラー',
    success: '成功',
    save: '保存',
    saving: '保存中...',
    confirm: '確認',
    confirmDelete: '削除の確認',
    deleteConfirmation: '本当に削除しますか？',
    selectOption: 'オプションを選択',
    required: '必須',
    enable: '有効にする',
    name: '名前',
    description: '説明',
    close: '閉じる',
    deleteSuccess: '削除に成功しました',
    deleteError: '削除に失敗しました：',
    addRound: 'ラウンドを追加',
    copy: 'コピー',
    copySuccess: 'コピーに成功しました',
    copyFailed: 'コピーに失敗しました',
    test: 'テスト',
    forgotPassword: 'パスワードを忘れた？',
    loading: '読み込み中...',
    or: 'または',
    loginWithSpace: 'Space でログイン',
    spaceLoginRecommended:
      'おすすめ：公式の安定したモデル API とクラウドサービスを利用',
    loginLocal: 'ローカルアカウントでログイン',
    loginWithPassword: 'パスワードでログイン',
    spaceLoginTitle: 'Space でログイン',
    spaceLoginDescription:
      'QRコードをスキャンするか、下のリンクにアクセスして認証してください',
    spaceLoginUserCode: '認証コード',
    spaceLoginExpires: 'コードは {{seconds}} 秒後に期限切れになります',
    spaceLoginWaiting: '認証を待っています...',
    spaceLoginSuccess: '認証に成功しました',
    spaceLoginFailed: 'Space ログインに失敗しました',
    spaceLoginExpired:
      '認証コードの有効期限が切れました。もう一度お試しください',
    spaceLoginCancel: 'キャンセル',
    spaceLoginVisitLink: 'リンクにアクセス',
    spaceLoginProcessing: 'Space でログイン中',
    spaceLoginProcessingDescription:
      'ログインを完了しています。しばらくお待ちください...',
    spaceLoginSuccessDescription: 'LangBot にリダイレクト中...',
    spaceLoginError: 'ログインに失敗しました',
    spaceLoginNoCode: '認証コードがありません',
    backToLogin: 'ログインに戻る',
    backToHome: 'ホームに戻る',
    spaceAccountCannotChangePassword:
      'Space アカウントはここでパスワードを変更できません',
    theme: 'テーマ',
    changePassword: 'パスワードを変更',
    currentPassword: '現在のパスワード',
    newPassword: '新しいパスワード',
    confirmNewPassword: '新しいパスワードを確認',
    enterCurrentPassword: '現在のパスワードを入力',
    enterNewPassword: '新しいパスワードを入力',
    enterConfirmPassword: '新しいパスワードを確認',
    currentPasswordRequired: '現在のパスワードは必須です',
    newPasswordRequired: '新しいパスワードは必須です',
    confirmPasswordRequired: '新しいパスワードを確認してください',
    passwordsDoNotMatch: '新しいパスワードが一致しません',
    changePasswordSuccess: 'パスワードの変更に成功しました',
    changePasswordFailed:
      'パスワードの変更に失敗しました。現在のパスワードを確認してください',
    apiIntegration: 'API統合',
    apiKeys: 'API キー',
    manageApiIntegration: 'API統合の管理',
    manageApiKeys: 'API キーの管理',
    createApiKey: 'API キーを作成',
    apiKeyName: 'API キー名',
    apiKeyDescription: 'API キーの説明',
    apiKeyValue: 'API キー値',
    apiKeyCreated: 'API キーの作成に成功しました',
    apiKeyDeleted: 'API キーの削除に成功しました',
    apiKeyDeleteConfirm: 'この API キーを削除してもよろしいですか？',
    apiKeyNameRequired: 'API キー名は必須です',
    copyApiKey: 'API キーをコピー',
    apiKeyCopied: 'API キーをクリップボードにコピーしました',
    noApiKeys: 'API キーが設定されていません',
    apiKeyHint:
      'API キーを使用すると、外部システムが LangBot Service API にアクセスできます',
    webhooks: 'Webhooks',
    createWebhook: 'Webhook を作成',
    webhookName: 'Webhook 名',
    webhookUrl: 'Webhook URL',
    webhookDescription: 'Webhook の説明',
    webhookEnabled: '有効',
    webhookCreated: 'Webhook が正常に作成されました',
    webhookDeleted: 'Webhook が正常に削除されました',
    webhookDeleteConfirm: 'この Webhook を削除してもよろしいですか？',
    webhookNameRequired: 'Webhook 名は必須です',
    webhookUrlRequired: 'Webhook URL は必須です',
    noWebhooks: 'Webhook が設定されていません',
    webhookHint:
      'Webhook を使用すると、LangBot は個人メッセージとグループメッセージイベントを外部システムにプッシュできます',
    actions: 'アクション',
    apiKeyCreatedMessage: 'この API キーをコピーしてください。',
    none: 'なし',
  },
  notFound: {
    title: 'ページが見つかりません',
    description:
      'お探しのページは存在しないようです。入力したURLが正しいか確認するか、ホームページに戻ってください。',
    back: '戻る',
    home: 'ホームに戻る',
    help: 'ヘルプドキュメントを見る',
  },
  models: {
    title: 'モデル設定',
    description: 'パイプラインで使用できるモデルを設定・管理',
    createModel: 'モデルを作成',
    editModel: 'モデルを編集',
    getModelListError: 'モデルリストの取得に失敗しました：',
    modelName: 'モデル名',
    modelProvider: 'モデルプロバイダー',
    modelBaseURL: 'ベースURL',
    modelAbilities: 'モデル機能',
    saveSuccess: '保存に成功しました',
    saveError: '保存に失敗しました：',
    createSuccess: '作成に成功しました',
    createError: '作成に失敗しました：',
    deleteSuccess: '削除に成功しました',
    deleteError: '削除に失敗しました：',
    deleteConfirmation: '本当にこのモデルを削除しますか？',
    modelNameRequired: 'モデル名は必須です',
    modelProviderRequired: 'モデルプロバイダーは必須です',
    requestURLRequired: 'リクエストURLは必須です',
    apiKeyRequired: 'APIキーは必須です',
    keyNameRequired: 'キー名は必須です',
    mustBeValidNumber: '有効な数値である必要があります',
    mustBeTrueOrFalse: 'true または false である必要があります',
    requestURL: 'リクエストURL',
    apiKey: 'APIキー',
    abilities: '機能',
    selectModelAbilities: 'モデル機能を選択',
    visionAbility: '視覚機能',
    functionCallAbility: '関数呼び出し',
    extraParameters: '追加パラメータ',
    addParameter: 'パラメータを追加',
    keyName: 'キー名',
    type: 'タイプ',
    value: '値',
    string: '文字列',
    number: '数値',
    boolean: 'ブール値',
    extraParametersDescription:
      'リクエストボディに追加されるパラメータ（max_tokens、temperature、top_p など）',
    selectModelProvider: 'モデルプロバイダーを選択',
    modelProviderDescription: 'プロバイダーが提供するモデル名をご入力ください',
    modelManufacturer: 'モデルメーカー',
    aggregationPlatform: 'アグリゲーションプラットフォーム',
    selfDeployed: 'セルフデプロイ',
    builtin: 'ビルトイン',
    selectModel: 'モデルを選択してください',
    testSuccess: 'テストに成功しました',
    testError: 'テストに失敗しました。モデル設定を確認してください',
    llmModels: 'LLM モデル',
    localProvider: 'ローカル',
    localProviderDescription: 'ローカルで設定・管理されているモデル',
    spaceProviderDescription: 'Space アカウントから同期されたモデル',
    spaceDisabledForLocalAccount: 'Space でログインしてクラウドモデルを使用',
    syncModels: '同期',
    syncSuccess: '同期完了：{{created}} 件作成、{{updated}} 件更新',
    syncError: '同期に失敗しました：',
    spaceModelReadOnly: 'Space モデルは読み取り専用です',
    noSpaceModels:
      'Space モデルがありません。同期ボタンをクリックして Space からモデルを取得してください。',
    noLocalModels:
      'ローカルモデルがありません。作成ボタンをクリックしてモデルを追加してください。',
    providerCount: '{{count}} 件のプロバイダー',
    addModel: 'モデルを追加',
    addLLMModel: 'LLMモデルを追加',
    addEmbeddingModel: '埋め込みモデルを追加',
    provider: 'プロバイダー',
    existingProvider: '既存のプロバイダー',
    newProvider: '新規プロバイダー',
    selectProvider: 'プロバイダーを選択',
    requester: 'プロバイダータイプ',
    selectRequester: 'プロバイダータイプを選択',
    langbotModelsDescription: 'LangBot Space が提供するクラウドモデル',
    credits: 'クレジット',
    loginWithSpace: 'Space でログイン',
    loginToUseModels: 'Space でログインしてクラウドモデルを使用',
    noModels: 'モデルがありません',
    editProvider: 'プロバイダーを編集',
    addProvider: 'プロバイダーを追加',
    addProviderHint:
      '他のソースのモデルを使用するにはプロバイダーを追加してください',
    addProviderHintSimple: 'モデルを使用するにはプロバイダーを追加してください',
    noProviders: 'プロバイダーがありません',
    providerName: 'プロバイダー名',
    providerNameRequired: 'プロバイダー名は必須です',
    requesterRequired: 'プロバイダータイプは必須です',
    providerSaved: 'プロバイダーを保存しました',
    providerCreated: 'プロバイダーを作成しました',
    providerSaveError: 'プロバイダーの保存に失敗しました：',
    providerDeleted: 'プロバイダーを削除しました',
    providerDeleteError: 'プロバイダーの削除に失敗しました：',
    deleteProviderConfirmation: 'このプロバイダーを削除してもよろしいですか？',
    loadError: 'データの読み込みに失敗しました',
    chat: 'チャット',
    embedding: '埋め込み',
    modelsCount: '{{count}} 個のモデル',
    expandModels: '展開',
    collapseModels: '折りたたむ',
  },
  bots: {
    title: 'ボット',
    description:
      'ボットの作成と管理を行います。LangBotと各プラットフォームを接続するためのエントリーポイントです',
    createBot: 'ボットを作成',
    editBot: 'ボットを編集',
    getBotListError: 'ボットリストの取得に失敗しました：',
    botName: 'ボット名',
    botDescription: 'ボットの説明',
    botNameRequired: 'ボット名は必須です',
    botDescriptionRequired: 'ボットの説明は必須です',
    adapterRequired: 'アダプターは必須です',
    defaultDescription: 'ボット',
    getBotConfigError: 'ボット設定の取得に失敗しました：',
    saveSuccess: '保存に成功しました',
    saveError: '保存に失敗しました：',
    createSuccess:
      '作成が完了しました。有効化するか、パイプラインの設定を行ってください',
    createError: '作成に失敗しました：',
    deleteSuccess: '削除に成功しました',
    deleteError: '削除に失敗しました：',
    deleteConfirmation: '本当にこのボットを削除しますか？',
    platformAdapter: 'プラットフォーム/アダプター選択',
    selectAdapter: 'アダプターを選択',
    adapterConfig: 'アダプター設定',
    bindPipeline: 'パイプラインを紐付け',
    selectPipeline: 'パイプラインを選択',
    selectBot: 'ボットを選択してください',
    botLogTitle: 'ボットログ',
    enableAutoRefresh: '自動更新を有効にする',
    session: 'セッション',
    yesterday: '昨日',
    earlier: 'それ以前',
    dateFormat: '{{month}}月{{day}}日',
    setBotEnableError: 'ボットの有効状態の設定に失敗しました',
    log: 'ログ',
    configuration: '設定',
    logs: 'ログ',
    webhookUrl: 'Webhook コールバック URL',
    webhookUrlCopied: 'Webhook URL をコピーしました',
    webhookUrlHint:
      '入力ボックスをクリックして全選択し、Ctrl+C (Mac: Cmd+C) でコピーするか、右側のボタンをクリックしてください',
    logLevel: 'ログレベル',
    allLevels: 'すべてのレベル',
    selectLevel: 'レベルを選択',
    levelsSelected: 'レベル選択済み',
  },
  plugins: {
    title: '拡張機能',
    description:
      'LangBotの機能を拡張するプラグインをインストール・設定。流水線設定で使用します',
    createPlugin: 'プラグインを作成',
    editPlugin: 'プラグインを編集',
    installed: 'インストール済み',
    marketplace: 'プラグインマーケット',
    arrange: '並び替え',
    install: 'インストール',
    installPlugin: 'プラグインをインストール',
    onlySupportGithub: '現在はGitHubからのインストールのみサポートしています',
    enterGithubLink: 'プラグインのGitHubリンクを入力してください',
    installing: 'プラグインをインストール中...',
    installSuccess: 'プラグインのインストールに成功しました',
    installFailed: 'プラグインのインストールに失敗しました：',
    searchPlugin: 'プラグインを検索',
    sortBy: '並び順',
    mostStars: 'スター数順',
    recentlyAdded: '最近追加',
    recentlyUpdated: '最近更新',
    noMatchingPlugins: '一致するプラグインが見つかりません',
    loading: '読み込み中...',
    getPluginListError: 'プラグインリストの取得に失敗しました：',
    noPluginInstalled: 'プラグインがインストールされていません',
    pluginConfig: 'プラグイン設定',
    pluginSort: 'プラグインの並び替え',
    pluginSortDescription:
      'プラグインの順序は、同一イベント内での処理順序に影響します。カードをドラッグして並び替えが可能です',
    pluginSortSuccess: 'プラグインの並び替えに成功しました',
    pluginSortError: 'プラグインの並び替えに失敗しました：',
    pluginNoConfig: 'プラグインに設定項目がありません。',
    systemDisabled: 'プラグインシステムが無効になっています',
    systemDisabledDesc:
      'プラグインシステムが無効になっています。プラグインシステムを有効にするか、ドキュメントに従って設定を変更してください',
    connectionError: 'プラグインシステム接続エラー',
    connectionErrorDesc:
      'プラグインシステム設定を確認するか、管理者に連絡してください',
    errorDetails: 'エラー詳細',
    loadingStatus: 'プラグインシステム状態を確認中...',
    failedToGetStatus: 'プラグインシステム状態の取得に失敗しました',
    pluginSystemNotReady:
      'プラグインシステムが準備されていません。この操作を実行できません',
    debugInfo: 'デバッグ情報',
    debugInfoTitle: 'プラグインデバッグ情報',
    debugUrl: 'デバッグURL',
    debugKey: 'デバッグキー',
    noDebugKey: '(未設定)',
    debugKeyDisabled:
      'デバッグキーが設定されていません。プラグインデバッグには認証が不要です',
    failedToGetDebugInfo: 'デバッグ情報の取得に失敗しました',
    copiedToClipboard: 'クリップボードにコピーしました',
    deleting: '削除中...',
    deletePlugin: 'プラグインを削除',
    cancel: 'キャンセル',
    saveConfig: '設定を保存',
    saving: '保存中...',
    confirmDeletePlugin:
      'プラグイン「{{author}}/{{name}}」を削除してもよろしいですか？',
    deleteDataCheckbox: 'プラグイン設定と永続化ストレージも削除する',
    confirmDelete: '削除を確認',
    deleteError: '削除に失敗しました：',
    close: '閉じる',
    deleteConfirm: '削除の確認',
    deleteSuccess: '削除に成功しました',
    modifyFailed: '変更に失敗しました：',
    componentName: {
      Tool: 'ツール',
      EventListener: 'イベント監視器',
      Command: 'コマンド',
      KnowledgeRetriever: '知識検索',
    },
    uploadLocal: 'ローカルアップロード',
    debugging: 'デバッグ中',
    uploadLocalPlugin: 'ローカルプラグインのアップロード',
    dragToUpload: 'ファイルをここにドラッグしてアップロード',
    unsupportedFileType:
      'サポートされていないファイルタイプです。.lbpkg と .zip ファイルのみサポートされています',
    uploadingPlugin: 'プラグインをアップロード中...',
    uploadSuccess: 'アップロード成功',
    uploadFailed: 'アップロード失敗',
    selectFileToUpload: 'アップロードするプラグインファイルを選択',
    askConfirm: 'プラグイン "{{name}}" ({{version}}) をインストールしますか？',
    fromGithub: 'GitHubから',
    fromLocal: 'ローカルから',
    fromMarketplace: 'プラグインマーケットから',
    componentsList: '部品：',
    noComponents: '部品がありません',
    delete: 'プラグインを削除',
    update: 'プラグインを更新',
    new: 'New',
    updateConfirm: '更新の確認',
    confirmUpdatePlugin:
      'プラグイン「{{author}}/{{name}}」を更新してもよろしいですか？',
    confirmUpdate: '更新を確認',
    updating: '更新中...',
    updateSuccess: 'プラグインの更新に成功しました',
    updateError: '更新に失敗しました：',
    saveConfigSuccessNormal: '設定を保存しました',
    saveConfigError: '設定の保存に失敗しました：',
    config: '設定',
    readme: 'ドキュメント',
    viewSource: 'ソースを表示',
    loadingReadme: 'ドキュメントを読み込み中...',
    noReadme: 'このプラグインはREADMEドキュメントを提供していません',
    fileUpload: {
      tooLarge: 'ファイルサイズが 10MB の制限を超えています',
      success: 'ファイルのアップロードに成功しました',
      failed: 'ファイルのアップロードに失敗しました',
      uploading: 'アップロード中...',
      chooseFile: 'ファイルを選択',
      addFile: 'ファイルを追加',
    },
    installFromGithub: 'GitHubから',
    enterRepoUrl: 'GitHubリポジトリのURLを入力してください',
    repoUrlPlaceholder: '例: https://github.com/owner/repo',
    fetchingReleases: 'リリース一覧を取得中...',
    selectRelease: 'リリースを選択',
    noReleasesFound: 'リリースが見つかりません',
    fetchReleasesError: 'リリース一覧の取得に失敗しました：',
    selectAsset: 'インストールするファイルを選択',
    noAssetsFound: 'このリリースには利用可能な .lbpkg ファイルがありません',
    fetchAssetsError: 'ファイル一覧の取得に失敗しました：',
    backToReleases: 'リリース一覧に戻る',
    backToRepoUrl: 'リポジトリURLに戻る',
    backToAssets: 'ファイル選択に戻る',
    releaseTag: 'タグ: {{tag}}',
    releaseName: '名前: {{name}}',
    publishedAt: '公開日: {{date}}',
    prerelease: 'プレリリース',
    assetSize: 'サイズ: {{size}}',
    confirmInstall: 'インストールを確認',
    installFromGithubDesc: 'GitHubリリースからプラグインをインストール',
  },
  market: {
    searchPlaceholder: 'プラグインを検索...',
    searchResults: '{{count}} 個のプラグインが見つかりました',
    totalPlugins: '合計 {{count}} 個のプラグイン',
    noPlugins: '利用可能なプラグインがありません',
    noResults: '関連するプラグインが見つかりません',
    loadingMore: 'さらに読み込み中...',
    loading: '読み込み中...',
    allLoaded: 'すべてのプラグインが表示されました',
    install: 'インストール',
    installConfirm:
      'プラグイン "{{name}}" ({{version}}) をインストールしますか？',
    downloadComplete: 'プラグイン "{{name}}" のダウンロードが完了しました',
    installFailed: 'インストールに失敗しました。後でもう一度お試しください',
    loadFailed:
      'プラグインリストの取得に失敗しました。後でもう一度お試しください',
    noDescription: '説明がありません',
    notFound: 'プラグイン情報が見つかりません',
    sortBy: '並び順',
    sort: {
      recentlyAdded: '最近追加',
      recentlyUpdated: '最近更新',
      mostDownloads: 'ダウンロード数多',
      leastDownloads: 'ダウンロード数少',
    },
    downloads: '回ダウンロード',
    download: 'ダウンロード',
    repository: 'リポジトリ',
    downloadFailed: 'ダウンロード失敗',
    noReadme: 'このプラグインはREADMEドキュメントを提供していません',
    description: '説明',
    tags: 'タグ',
    submissionTitle: 'プラグインの提出が審査中です： {{name}}',
    submissionPending: 'プラグインの提出が審査中です： {{name}}',
    submissionApproved: 'プラグインの提出が承認されました： {{name}}',
    submissionRejected: 'プラグインの提出が拒否されました： {{name}}',
    clickToRevoke: '取り消し',
    revokeSuccess: '取り消し成功',
    revokeFailed: '取り消し失敗',
    submissionDetails: 'プラグイン提出詳細',
    markAsRead: '既読',
    markAsReadSuccess: '既読に設定しました',
    markAsReadFailed: '既読に設定に失敗しました',
    filterByComponent: 'コンポーネント',
    allComponents: '全部コンポーネント',
    requestPlugin: 'プラグインをリクエスト',
    viewDetails: '詳細を表示',
  },
  mcp: {
    title: 'MCP',
    createServer: 'MCPサーバーを追加',
    editServer: 'MCPサーバーを編集',
    deleteServer: 'MCPサーバーを削除',
    confirmDeleteServer: 'このMCPサーバーを削除してもよろしいですか？',
    confirmDeleteTitle: 'MCPサーバーを削除',
    getServerListError: 'MCPサーバーリストの取得に失敗しました：',
    serverName: 'サーバー名',
    serverMode: '接続モード',
    stdio: 'Stdioモード',
    sse: 'SSEモード',
    noServerInstalled: 'MCPサーバーが設定されていません',
    serverNameRequired: 'サーバー名は必須です',
    commandRequired: 'コマンドは必須です',
    urlRequired: 'URLは必須です',
    timeoutMustBePositive: 'タイムアウトは正の数でなければなりません',
    command: 'コマンド',
    args: '引数',
    env: '環境変数',
    url: 'URL',
    headers: 'ヘッダー',
    timeout: 'タイムアウト',
    addArgument: '引数を追加',
    addEnvVar: '環境変数を追加',
    addHeader: 'ヘッダーを追加',
    keyName: 'キー名',
    value: '値',
    testing: 'テスト中...',
    connecting: '接続中...',
    testSuccess: '刷新に成功しました',
    testFailed: '刷新に失敗しました：',
    testError: '刷新エラー',
    refreshSuccess: '刷新に成功しました',
    refreshFailed: '刷新に失敗しました：',
    connectionSuccess: '接続に成功しました',
    connectionFailed: '接続に失敗しました，URLを確認してください',
    connectionFailedStatus: '接続失敗',
    toolsFound: '個のツール',
    unknownError: '不明なエラー',
    noToolsFound: 'ツールが見つかりません',
    parseResultFailed: 'テスト結果の解析に失敗しました',
    noResultReturned: 'テスト結果が返されませんでした',
    getTaskFailed: 'タスクステータスの取得に失敗しました',
    noTaskId: 'タスクIDを取得できませんでした',
    deleteSuccess: '削除に成功しました',
    deleteFailed: '削除に失敗しました：',
    deleteError: '削除に失敗しました：',
    saveSuccess: '保存に成功しました',
    saveError: '保存に失敗しました：',
    createSuccess: '作成に成功しました',
    createFailed: '作成に失敗しました：',
    createError: '作成に失敗しました：',
    loadFailed: '読み込みに失敗しました',
    modifyFailed: '変更に失敗しました：',
    toolCount: 'ツール：{{count}}',
    statusConnected: '接続済み',
    statusDisconnected: '未接続',
    statusError: '接続エラー',
    statusDisabled: '無効',
    loading: '読み込み中...',
    starCount: 'スター：{{count}}',
    install: 'インストール',
    installFromGithub: 'GitHubからMCPサーバーをインストール',
    add: '追加',
    name: '名前',
    nameRequired: '名前は必須です',
    sseTimeout: 'SSEタイムアウト',
    sseTimeoutDescription: 'SSE接続を確立するためのタイムアウト',
    extraParametersDescription:
      'MCPサーバーの特定の動作を設定するための追加パラメータ',
    timeoutMustBeNumber: 'タイムアウトは数値である必要があります',
    timeoutNonNegative: 'タイムアウトは負の数にできません',
    sseTimeoutMustBeNumber: 'SSEタイムアウトは数値である必要があります',
    sseTimeoutNonNegative: 'SSEタイムアウトは負の数にできません',
    updateSuccess: '更新に成功しました',
    updateFailed: '更新に失敗しました：',
  },
  pipelines: {
    title: 'パイプライン',
    description:
      'メッセージイベントの処理フローを定義し、ボットに紐付けて使用するパイプラインです',
    createPipeline: 'パイプラインを作成',
    editPipeline: 'パイプラインを編集',
    chat: 'チャット',
    configuration: '設定',
    debugChat: 'チャットデバッグ',
    getPipelineListError: 'パイプラインリストの取得に失敗しました：',
    daysAgo: '日前',
    today: '今日',
    updateTime: '更新日時',
    defaultBadge: 'デフォルト',
    sortBy: '並び順',
    newestCreated: '最新作成',
    earliestCreated: '最古作成',
    recentlyEdited: '最近編集',
    earliestEdited: '最古編集',
    basicInfo: '基本情報',
    aiCapabilities: 'AI機能',
    triggerConditions: 'トリガー条件',
    safetyControls: '安全制御',
    outputProcessing: '出力処理',
    nameRequired: '名前は必須です',
    descriptionRequired: '説明は必須です',
    createSuccess:
      '作成が完了しました。パイプラインの詳細パラメータを設定してください',
    createError: '作成に失敗しました：',
    saveSuccess: '保存に成功しました',
    saveError: '保存に失敗しました：',
    copySuffix: ' Copy',
    deleteConfirmation:
      '本当にこのパイプラインを削除しますか？このパイプラインに紐付けられたボットは動作しなくなります。',
    defaultPipelineCannotDelete: 'デフォルトパイプラインは削除できません',
    deleteSuccess: '削除に成功しました',
    deleteError: '削除に失敗しました：',
    copyConfirmTitle: 'コピーの確認',
    copyConfirmation:
      'このパイプラインをコピーしますか？すべての設定を含む新しいパイプラインが作成されます。',
    extensions: {
      title: 'プラグイン統合',
      loadError: 'プラグインリストの読み込みに失敗しました',
      saveSuccess: '保存に成功しました',
      saveError: '保存に失敗しました',
      noPluginsAvailable: '利用可能なプラグインがありません',
      disabled: '無効',
      noPluginsSelected: 'プラグインが選択されていません',
      addPlugin: 'プラグインを追加',
      selectPlugins: 'プラグインを選択',
      pluginsTitle: 'プラグイン',
      mcpServersTitle: 'MCPサーバー',
      noMCPServersSelected: 'MCPサーバーが選択されていません',
      addMCPServer: 'MCPサーバーを追加',
      selectMCPServers: 'MCPサーバーを選択',
      toolCount: '{{count}}個のツール',
      noPluginsInstalled: 'インストールされているプラグインがありません',
      noMCPServersConfigured: '設定されているMCPサーバーがありません',
      selectAll: 'すべて選択',
      enableAllPlugins: 'すべてのプラグインを有効にする',
      enableAllMCPServers: 'すべてのMCPサーバーを有効にする',
      allPluginsEnabled: 'すべてのプラグインが有効になっています',
      allMCPServersEnabled: 'すべてのMCPサーバーが有効になっています',
    },
    debugDialog: {
      title: 'パイプラインのチャット',
      selectPipeline: 'パイプラインを選択',
      sessionType: 'セッションタイプ',
      privateChat: 'プライベートチャット',
      groupChat: 'グループチャット',
      send: '送信',
      reset: '会話をリセット',
      inputPlaceholder: '{{type}}メッセージを送信...',
      noMessages: 'メッセージがありません',
      userMessage: 'ユーザー',
      botMessage: 'ボット',
      sendFailed: '送信に失敗しました',
      resetSuccess: '会話がリセットされました',
      resetFailed: 'リセットに失敗しました',
      loadMessagesFailed: 'メッセージの読み込みに失敗しました',
      loadPipelinesFailed: 'パイプラインの読み込みに失敗しました',
      atTips: 'ボットをメンション',
      streaming: 'ストリーミング',
      streamOutput: 'ストリーム',
      connected: 'WebSocket接続済み',
      disconnected: 'WebSocket未接続',
      connectionError: 'WebSocket接続エラー',
      connectionFailed: 'WebSocket接続に失敗しました',
      notConnected:
        'WebSocketに接続されていません。しばらくしてからやり直してください',
      imageUploadFailed: '画像のアップロードに失敗しました',
      reply: '返信',
      replyTo: '返信先',
      showMarkdown: 'Markdownで表示',
      showRaw: '原文で表示',
    },
  },
  knowledge: {
    title: '知識ベース',
    createKnowledgeBase: '知識ベースを作成',
    editKnowledgeBase: '知識ベースを編集',
    selectKnowledgeBase: '知識ベースを選択',
    selectKnowledgeBases: '知識ベースを選択',
    addKnowledgeBase: '知識ベースを追加',
    noKnowledgeBaseSelected: '知識ベースが選択されていません',
    empty: 'なし',
    editDocument: 'ドキュメント',
    description: 'LLMの回答品質向上のための知識ベースを設定します',
    metadata: 'メタデータ',
    documents: 'ドキュメント',
    kbNameRequired: '知識ベース名は必須です',
    kbDescriptionRequired: '知識ベースの説明は必須です',
    embeddingModelUUIDRequired: '埋め込みモデルは必須です',
    daysAgo: '日前',
    today: '今日',
    kbName: '知識ベース名',
    kbDescription: '知識ベースの説明',
    topK: 'Top K',
    topKRequired: 'Top Kは必須です',
    topKMax: 'Top Kの最大値は30です',
    topKdescription:
      '取得する関連性の高い上位K件の文書の数。1～30の範囲で設定できます',
    defaultDescription: '知識ベース',
    embeddingModelUUID: '埋め込みモデル',
    selectEmbeddingModel: '埋め込みモデルを選択',
    embeddingModelDescription:
      'テキストのベクトル化に使用する埋め込みモデルを管理します',
    updateTime: '更新日時',
    cannotChangeEmbeddingModel:
      '知識ベース作成後は埋め込みモデルを変更できません',
    updateKnowledgeBaseSuccess: '知識ベースの更新に成功しました',
    updateKnowledgeBaseFailed: '知識ベースの更新に失敗しました',
    documentsTab: {
      name: '名前',
      status: 'ステータス',
      noResults: 'ドキュメントがありません',
      dragAndDrop:
        'ファイルをここにドラッグ&ドロップするか、クリックしてアップロードしてください',
      uploading: 'アップロード中...',
      supportedFormats:
        'PDF、Word、TXT、Markdownなどのドキュメントファイルをサポートしています',
      uploadSuccess: 'ファイルのアップロードに成功しました！',
      uploadError: 'ファイルのアップロードに失敗しました。再度お試しください',
      uploadingFile: 'ファイルをアップロード中...',
      fileSizeExceeded:
        'ファイルサイズが10MBの制限を超えています。より小さいファイルに分割してください。',
      actions: 'アクション',
      delete: 'ドキュメントを削除',
      fileDeleteSuccess: 'ドキュメントの削除に成功しました',
      fileDeleteFailed: 'ドキュメントの削除に失敗しました',
      processing: '処理中',
      completed: '完了',
      failed: '失敗',
    },
    deleteKnowledgeBaseConfirmation:
      '本当にこの知識ベースを削除しますか？この知識ベースに紐付けられたドキュメントは削除されます。',
    retrieve: '検索テスト',
    retrieveTest: '検索テスト',
    query: '検索',
    queryPlaceholder: '検索内容を入力...',
    distance: '距離',
    content: '内容',
    fileName: 'ファイル名',
    noResults: '検索結果がありません',
    retrieveError: '検索に失敗しました',
    builtIn: '内蔵',
    external: '外部ナレッジベース',
    addExternal: '外部ナレッジベースを追加',
    createExternalSuccess: '外部ナレッジベースが正常に作成されました',
    updateExternalSuccess: '外部ナレッジベースが正常に更新されました',
    deleteExternalSuccess: '外部ナレッジベースが正常に削除されました',
    retriever: '検索器',
    selectRetriever: '検索器を選択...',
    retrieverConfiguration: '検索器設定',
    retrieverInstallInfo: 'ナレッジ検索器プラグインは',
    retrieverMarketLink: 'こちらからインストールできます',
  },
  register: {
    title: 'LangBot を初期化 👋',
    description: 'これはLangBotの初回起動です',
    adminAccountNote:
      'ここで初期化されたアカウントは管理者アカウントとして使用されます',
    register: '登録',
    initWithSpace: 'Space で初期化',
    spaceRecommended:
      'おすすめ：公式の安定したモデル API とクラウドサービスを利用',
    spaceInfoTip1:
      'Space は統一されたアカウント認証サービスを提供し、機密情報をアップロードすることはありません。',
    spaceInfoTip2:
      'Space アカウントでログインすると、LangBot Models などのクラウドサービスを利用でき、無料のモデル呼び出しクレジットで迅速に開始できます。',
    spaceInfoTip3:
      'ログイン方法は他の機能に影響しません。いつでも他のソースからモデルを設定して使用できます。',
    registerLocal: 'ローカルアカウントを登録',
    registerWithPassword: 'メールアドレスとパスワードで登録',
    initSuccess: '初期化に成功しました。ログインしてください',
    initFailed: '初期化に失敗しました：',
  },
  resetPassword: {
    title: 'パスワードをリセット 🔐',
    description:
      '復旧キーと新しいパスワードを入力して、アカウントのパスワードをリセットします',
    recoveryKey: '復旧キー',
    recoveryKeyDescription:
      '設定ファイル `data/config.yaml` の `system.recovery_key` に保存されています',
    newPassword: '新しいパスワード',
    enterRecoveryKey: '復旧キーを入力',
    enterNewPassword: '新しいパスワードを入力',
    recoveryKeyRequired: '復旧キーは必須です',
    newPasswordRequired: '新しいパスワードは必須です',
    resetPassword: 'パスワードをリセット',
    resetting: 'リセット中...',
    resetSuccess: 'パスワードのリセットに成功しました。ログインしてください',
    resetFailed:
      'パスワードのリセットに失敗しました。メールアドレスと復旧キーを確認してください',
    backToLogin: 'ログインに戻る',
  },
  embedding: {
    description: 'テキストのベクトル化に使用する埋め込みモデルを管理します',
    createModel: '埋め込みモデルを作成',
    editModel: '埋め込みモデルを編集',
    getModelListError: '埋め込みモデルリストの取得に失敗しました：',
    embeddingModels: '埋め込みモデル',
    extraParametersDescription:
      'リクエストボディに追加されるパラメータ（encoding_format、dimensions など）',
  },
  llm: {
    description: 'チャットメッセージの生成に使用するLLMモデルを管理します',
    llmModels: 'LLMモデル',
    extraParametersDescription:
      'リクエストボディに追加されるパラメータ（max_tokens、temperature、top_p など）',
  },
  version: {
    newVersionAvailable: '新しいバージョンが利用可能',
    viewUpdateGuide: 'アップデート方法を見る',
    noReleaseNotes: 'リリースノートはありません',
  },
  account: {
    settings: 'アカウント設定',
    setPassword: 'パスワードを設定',
    passwordSetSuccess: 'パスワードの設定に成功しました',
    passwordStatus: 'ローカルパスワード',
    passwordSet: '設定済み',
    passwordNotSet: '未設定',
    passwordSetDescription:
      'パスワードが設定されています。メールとパスワードでログインできます',
    spaceStatus: 'Space アカウント',
    spaceBound: '連携済み',
    spaceNotBound: '未連携',
    spaceBoundDescription:
      'Space アカウントと連携済み、公式モデル API とクラウドサービスが利用可能',
    bindSpace: 'Space アカウントを連携',
    bindSpaceDescription: '連携して公式モデル API とクラウドサービスを利用',
    bindSpaceButton: '連携',
    bindSpaceConfirmTitle: '連携を確認',
    bindSpaceConfirmDescription:
      'ローカルインスタンスを Space アカウントに連携しようとしています',
    bindSpaceWarning:
      '連携後、ログインメールアドレスは {{localEmail}} から Space アカウントのメールアドレスに変更されます。',
    bindSpaceSuccess: 'Space アカウントの連携に成功しました',
    bindSpaceFailed: 'Space アカウントの連携に失敗しました',
    bindSpaceInvalidState:
      '無効な連携リクエストです。アカウント設定から再度お試しください。',
    setPasswordHint:
      'パスワードを設定するとメールとパスワードでログインできます',
    spaceEmailMismatch:
      'Spaceログインのメールアドレスがローカルアカウントのメールアドレスと一致しません',
  },
};

export default jaJP;
