const enUS = {
  common: {
    login: 'Login',
    logout: 'Logout',
    accountOptions: 'Settings',
    account: 'Account',
    integration: 'Integration',
    email: 'Email',
    password: 'Password',
    welcome: 'Welcome back to LangBot 👋',
    continueToLogin: 'Login to continue',
    loginSuccess: 'Login successful',
    loginFailed: 'Login failed, please check your email and password',
    enterEmail: 'Enter email address',
    enterPassword: 'Enter password',
    invalidEmail: 'Please enter a valid email address',
    emptyPassword: 'Please enter your password',
    language: 'Language',
    helpDocs: 'Get Help',
    featureRequest: 'Feature Request',
    create: 'Create',
    edit: 'Edit',
    delete: 'Delete',
    add: 'Add',
    select: 'Select',
    cancel: 'Cancel',
    submit: 'Submit',
    error: 'Error',
    success: 'Success',
    save: 'Save',
    saving: 'Saving...',
    confirm: 'Confirm',
    confirmDelete: 'Confirm Delete',
    deleteConfirmation: 'Are you sure you want to delete this?',
    selectOption: 'Select an option',
    required: 'Required',
    enable: 'Enable',
    name: 'Name',
    description: 'Description',
    close: 'Close',
    deleteSuccess: 'Deleted successfully',
    deleteError: 'Delete failed: ',
    addRound: 'Add Round',
    copy: 'Copy',
    copySuccess: 'Copy Successfully',
    copyFailed: 'Copy Failed',
    test: 'Test',
    forgotPassword: 'Forgot Password?',
    loading: 'Loading...',
    or: 'or',
    loginWithSpace: 'Login with Space',
    spaceLoginRecommended:
      'Recommended: Use official stable model APIs and cloud services',
    loginLocal: 'Login with local account',
    loginWithPassword: 'Login with password',
    spaceLoginTitle: 'Login with Space',
    spaceLoginDescription:
      'Scan the QR code or visit the link below to authorize',
    spaceLoginUserCode: 'Your code',
    spaceLoginExpires: 'Code expires in {{seconds}} seconds',
    spaceLoginWaiting: 'Waiting for authorization...',
    spaceLoginSuccess: 'Authorization successful',
    spaceLoginFailed: 'Space login failed',
    spaceLoginExpired: 'Authorization code expired, please try again',
    spaceLoginCancel: 'Cancel',
    spaceLoginVisitLink: 'Visit link',
    spaceLoginProcessing: 'Logging in with Space',
    spaceLoginProcessingDescription:
      'Please wait while we complete your login...',
    spaceLoginSuccessDescription: 'Redirecting to LangBot...',
    spaceLoginError: 'Login Failed',
    spaceLoginNoCode: 'Missing authorization code',
    backToLogin: 'Back to Login',
    backToHome: 'Back to Home',
    spaceAccountCannotChangePassword:
      'Space accounts cannot change password here',
    theme: 'Theme',
    changePassword: 'Change Password',
    currentPassword: 'Current Password',
    newPassword: 'New Password',
    confirmNewPassword: 'Confirm New Password',
    enterCurrentPassword: 'Enter current password',
    enterNewPassword: 'Enter new password',
    enterConfirmPassword: 'Confirm new password',
    currentPasswordRequired: 'Current password is required',
    newPasswordRequired: 'New password is required',
    confirmPasswordRequired: 'Confirm password is required',
    passwordsDoNotMatch: 'Passwords do not match',
    changePasswordSuccess: 'Password changed successfully',
    changePasswordFailed:
      'Failed to change password, please check your current password',
    apiIntegration: 'API Integration',
    apiKeys: 'API Keys',
    manageApiIntegration: 'Manage API Integration',
    manageApiKeys: 'Manage API Keys',
    createApiKey: 'Create API Key',
    apiKeyName: 'API Key Name',
    apiKeyDescription: 'API Key Description',
    apiKeyValue: 'API Key Value',
    apiKeyCreated: 'API key created successfully',
    apiKeyDeleted: 'API key deleted successfully',
    apiKeyDeleteConfirm: 'Are you sure you want to delete this API key?',
    apiKeyNameRequired: 'API key name is required',
    copyApiKey: 'Copy API Key',
    apiKeyCopied: 'API key copied to clipboard',
    noApiKeys: 'No API keys configured',
    apiKeyHint:
      'API keys allow external systems to access LangBot Service APIs',
    webhooks: 'Webhooks',
    createWebhook: 'Create Webhook',
    webhookName: 'Webhook Name',
    webhookUrl: 'Webhook URL',
    webhookDescription: 'Webhook Description',
    webhookEnabled: 'Enabled',
    webhookCreated: 'Webhook created successfully',
    webhookDeleted: 'Webhook deleted successfully',
    webhookDeleteConfirm: 'Are you sure you want to delete this webhook?',
    webhookNameRequired: 'Webhook name is required',
    webhookUrlRequired: 'Webhook URL is required',
    noWebhooks: 'No webhooks configured',
    webhookHint:
      'Webhooks allow LangBot to push person and group message events to external systems',
    actions: 'Actions',
    apiKeyCreatedMessage: 'Please copy this API key.',
    none: 'None',
  },
  notFound: {
    title: 'Page not found',
    description: 'The page you are looking for does not exist.',
    back: 'Back',
    home: 'Home',
    help: 'Get Help',
  },
  models: {
    title: 'Models',
    description: 'Configure and manage models that can be used in pipelines',
    createModel: 'Create Model',
    editModel: 'Edit Model',
    getModelListError: 'Failed to get model list: ',
    modelName: 'Model Name',
    modelProvider: 'Model Provider',
    modelBaseURL: 'Base URL',
    modelAbilities: 'Model Abilities',
    saveSuccess: 'Saved successfully',
    saveError: 'Save failed: ',
    createSuccess: 'Created successfully',
    createError: 'Creation failed: ',
    deleteSuccess: 'Deleted successfully',
    deleteError: 'Delete failed: ',
    deleteConfirmation: 'Are you sure you want to delete this model?',
    modelNameRequired: 'Model name cannot be empty',
    modelProviderRequired: 'Model provider cannot be empty',
    requestURLRequired: 'Request URL cannot be empty',
    apiKeyRequired: 'API Key cannot be empty',
    keyNameRequired: 'Key name cannot be empty',
    mustBeValidNumber: 'Must be a valid number',
    mustBeTrueOrFalse: 'Must be true or false',
    requestURL: 'Request URL',
    apiKey: 'API Key',
    abilities: 'Abilities',
    selectModelAbilities: 'Select model abilities',
    visionAbility: 'Vision Ability',
    functionCallAbility: 'Function Call',
    extraParameters: 'Extra Parameters',
    addParameter: 'Add Parameter',
    keyName: 'Key Name',
    type: 'Type',
    value: 'Value',
    string: 'String',
    number: 'Number',
    boolean: 'Boolean',
    selectModelProvider: 'Select Model Provider',
    modelProviderDescription:
      'Please fill in the model name provided by the provider',
    modelManufacturer: 'Model Manufacturer',
    aggregationPlatform: 'Aggregation Platform',
    selfDeployed: 'Self-deployed',
    builtin: 'Built-in',
    selectModel: 'Select Model',
    testSuccess: 'Test successful',
    testError: 'Test failed, please check your model configuration',
    llmModels: 'LLM Models',
    localProvider: 'Local',
    localProviderDescription: 'Models configured and managed locally',
    spaceProviderDescription: 'Models synced from your Space account',
    spaceDisabledForLocalAccount: 'Login with Space to use cloud models',
    syncModels: 'Sync',
    syncSuccess: 'Sync complete: {{created}} created, {{updated}} updated',
    syncError: 'Sync failed: ',
    spaceModelReadOnly: 'Space models are read-only',
    noSpaceModels: 'No Space models. Click Sync to fetch models from Space.',
    noLocalModels: 'No local models. Click Create to add a model.',
    providerCount: '{{count}} providers',
    // New keys for provider-based structure
    addModel: 'Add Model',
    addLLMModel: 'Add LLM Model',
    addEmbeddingModel: 'Add Embedding Model',
    provider: 'Provider',
    existingProvider: 'Existing Provider',
    newProvider: 'New Provider',
    selectProvider: 'Select Provider',
    requester: 'Provider Type',
    selectRequester: 'Select Provider Type',
    langbotModelsDescription: 'Cloud models powered by LangBot Space',
    credits: 'Credits',
    loginWithSpace: 'Login with Space',
    loginToUseModels: 'Login with Space to use cloud models',
    noModels: 'No models configured',
    editProvider: 'Edit Provider',
    addProvider: 'Add Provider',
    addProviderHint: 'Add providers to use models from other sources',
    addProviderHintSimple: 'Add providers to use models',
    noProviders: 'No providers yet',
    providerName: 'Provider Name',
    providerNameRequired: 'Provider name is required',
    requesterRequired: 'Provider type is required',
    providerSaved: 'Provider saved',
    providerCreated: 'Provider created',
    providerSaveError: 'Failed to save provider: ',
    providerDeleted: 'Provider deleted',
    providerDeleteError: 'Failed to delete provider: ',
    deleteProviderConfirmation:
      'Are you sure you want to delete this provider?',
    loadError: 'Failed to load data',
    chat: 'Chat',
    embedding: 'Embedding',
    modelsCount: '{{count}} model(s)',
    expandModels: 'Expand',
    collapseModels: 'Collapse',
  },
  bots: {
    title: 'Bots',
    description:
      'Create and manage bots, which are the entry points for LangBot to connect with various platforms',
    createBot: 'Create Bot',
    editBot: 'Edit Bot',
    getBotListError: 'Failed to get bot list: ',
    botName: 'Bot Name',
    botDescription: 'Bot Description',
    botNameRequired: 'Bot name cannot be empty',
    botDescriptionRequired: 'Bot description cannot be empty',
    adapterRequired: 'Adapter cannot be empty',
    defaultDescription: 'A bot',
    getBotConfigError: 'Failed to get bot configuration: ',
    saveSuccess: 'Saved successfully',
    saveError: 'Save failed: ',
    createSuccess:
      'Created successfully. Please enable or modify the bound pipeline',
    createError: 'Creation failed: ',
    deleteSuccess: 'Deleted successfully',
    deleteError: 'Delete failed: ',
    deleteConfirmation: 'Are you sure you want to delete this bot?',
    platformAdapter: 'Platform/Adapter Selection',
    selectAdapter: 'Select Adapter',
    adapterConfig: 'Adapter Configuration',
    bindPipeline: 'Bind Pipeline',
    selectPipeline: 'Select Pipeline',
    selectBot: 'Select Bot',
    botLogTitle: 'Bot Log',
    enableAutoRefresh: 'Enable Auto Refresh',
    session: 'Session',
    yesterday: 'Yesterday',
    earlier: 'Earlier',
    dateFormat: '{{month}}/{{day}}',
    setBotEnableError: 'Failed to set bot enable status',
    log: 'Log',
    configuration: 'Configuration',
    logs: 'Logs',
    webhookUrl: 'Webhook Callback URL',
    webhookUrlCopied: 'Webhook URL copied',
    webhookUrlHint:
      'Click the input to select all, then press Ctrl+C (Mac: Cmd+C) to copy, or click the button',
    logLevel: 'Log Level',
    allLevels: 'All Levels',
    selectLevel: 'Select Level',
    levelsSelected: 'levels selected',
  },
  plugins: {
    title: 'Extensions',
    description:
      'Install and configure plugins to extend functionality, please select them in the pipeline configuration',
    createPlugin: 'Create Plugin',
    editPlugin: 'Edit Plugin',
    installed: 'Installed',
    marketplace: 'Marketplace',
    arrange: 'Sort Plugins',
    install: 'Install',
    installPlugin: 'Install Plugin',
    onlySupportGithub: 'Currently only supports installation from GitHub',
    enterGithubLink: 'Enter GitHub link of the plugin',
    installing: 'Installing plugin...',
    installSuccess: 'Plugin installed successfully',
    installFailed: 'Plugin installation failed:',
    searchPlugin: 'Search plugins',
    sortBy: 'Sort by',
    mostStars: 'Most stars',
    recentlyAdded: 'Recently added',
    recentlyUpdated: 'Recently updated',
    noMatchingPlugins: 'No matching plugins found',
    loading: 'Loading...',
    getPluginListError: 'Failed to get plugin list:',
    noPluginInstalled: 'No plugins installed',
    pluginConfig: 'Plugin Configuration',
    pluginSort: 'Plugin Sort',
    pluginSortDescription:
      'Plugin order affects the processing order within the same event, please drag the plugin card to sort',
    pluginSortSuccess: 'Plugin sort successful',
    pluginSortError: 'Plugin sort failed: ',
    pluginNoConfig: 'The plugin has no configuration items.',
    systemDisabled: 'Plugin System Disabled',
    systemDisabledDesc:
      'Plugin system is not enabled, please modify the configuration according to the documentation',
    connectionError: 'Plugin System Connection Error',
    connectionErrorDesc:
      'Please check the plugin system configuration or contact the administrator.',
    errorDetails: 'Error Details',
    loadingStatus: 'Checking plugin system status...',
    failedToGetStatus: 'Failed to get plugin system status',
    pluginSystemNotReady:
      'Plugin system is not ready, cannot perform this operation',
    debugInfo: 'Debug Info',
    debugInfoTitle: 'Plugin Debug Information',
    debugUrl: 'Debug URL',
    debugKey: 'Debug Key',
    noDebugKey: '(Not Set)',
    debugKeyDisabled:
      'Debug key is not set, plugin debugging does not require authentication',
    failedToGetDebugInfo: 'Failed to get debug information',
    copiedToClipboard: 'Copied to clipboard',
    deleting: 'Deleting...',
    deletePlugin: 'Delete Plugin',
    cancel: 'Cancel',
    saveConfig: 'Save Config',
    saving: 'Saving...',
    confirmDeletePlugin:
      'Are you sure you want to delete the plugin ({{author}}/{{name}})?',
    deleteDataCheckbox:
      'Also delete plugin configuration and persistence storage',
    confirmDelete: 'Confirm Delete',
    deleteError: 'Delete failed: ',
    close: 'Close',
    deleteConfirm: 'Delete Confirmation',
    deleteSuccess: 'Delete successful',
    modifyFailed: 'Modify failed: ',
    componentName: {
      Tool: 'Tool',
      EventListener: 'Event Listener',
      Command: 'Command',
      KnowledgeRetriever: 'Knowledge Retriever',
    },
    uploadLocal: 'Upload Local',
    debugging: 'Debugging',
    uploadLocalPlugin: 'Upload Local Plugin',
    dragToUpload: 'Drag plugin file here to upload',
    unsupportedFileType:
      'Unsupported file type, only .lbpkg and .zip files are supported',
    uploadingPlugin: 'Uploading plugin...',
    uploadSuccess: 'Upload successful',
    uploadFailed: 'Upload failed',
    selectFileToUpload: 'Select plugin file to upload',
    askConfirm: 'Are you sure to install plugin "{{name}}" ({{version}})?',
    fromGithub: 'From GitHub',
    fromLocal: 'From Local',
    fromMarketplace: 'From Marketplace',
    componentsList: 'Components: ',
    noComponents: 'No components',
    delete: 'Delete Plugin',
    update: 'Update Plugin',
    new: 'New',
    updateConfirm: 'Update Confirmation',
    confirmUpdatePlugin:
      'Are you sure you want to update the plugin ({{author}}/{{name}})?',
    confirmUpdate: 'Confirm Update',
    updating: 'Updating...',
    updateSuccess: 'Plugin updated successfully',
    updateError: 'Update failed: ',
    saveConfigSuccessNormal: 'Configuration saved successfully',
    saveConfigError: 'Configuration save failed: ',
    config: 'Configuration',
    readme: 'Documentation',
    viewSource: 'View Source',
    loadingReadme: 'Loading documentation...',
    noReadme: 'This plugin does not provide README documentation',
    fileUpload: {
      tooLarge: 'File size exceeds 10MB limit',
      success: 'File uploaded successfully',
      failed: 'File upload failed',
      uploading: 'Uploading...',
      chooseFile: 'Choose File',
      addFile: 'Add File',
    },
    installFromGithub: 'From GitHub',
    enterRepoUrl: 'Enter GitHub repository URL',
    repoUrlPlaceholder: 'e.g., https://github.com/owner/repo',
    fetchingReleases: 'Fetching releases...',
    selectRelease: 'Select Release',
    noReleasesFound: 'No releases found',
    fetchReleasesError: 'Failed to fetch releases: ',
    selectAsset: 'Select file to install',
    noAssetsFound: 'No .lbpkg files available in this release',
    fetchAssetsError: 'Failed to fetch assets: ',
    backToReleases: 'Back to releases',
    backToRepoUrl: 'Back to repository URL',
    backToAssets: 'Back to assets',
    releaseTag: 'Tag: {{tag}}',
    releaseName: 'Name: {{name}}',
    publishedAt: 'Published at: {{date}}',
    prerelease: 'Pre-release',
    assetSize: 'Size: {{size}}',
    confirmInstall: 'Confirm Install',
    installFromGithubDesc: 'Install plugin from GitHub Release',
  },
  market: {
    searchPlaceholder: 'Search plugins...',
    searchResults: 'Found {{count}} plugins',
    totalPlugins: 'Total {{count}} plugins',
    noPlugins: 'No plugins available',
    noResults: 'No relevant plugins found',
    loadingMore: 'Loading more...',
    loading: 'Loading...',
    allLoaded: 'All plugins displayed',
    install: 'Install',
    installConfirm:
      'Are you sure you want to install plugin "{{name}}" ({{version}})?',
    downloadComplete: 'Plugin "{{name}}" download completed',
    installFailed: 'Installation failed, please try again later',
    loadFailed: 'Failed to get plugin list, please try again later',
    noDescription: 'No description available',
    notFound: 'Plugin information not found',
    sortBy: 'Sort by',
    sort: {
      recentlyAdded: 'Recently Added',
      recentlyUpdated: 'Recently Updated',
      mostDownloads: 'Most Downloads',
      leastDownloads: 'Least Downloads',
    },
    downloads: 'downloads',
    download: 'Download',
    repository: 'Repository',
    downloadFailed: 'Download failed',
    noReadme: 'This plugin does not provide README documentation',
    description: 'Description',
    tags: 'Tags',
    submissionTitle: 'You have a plugin submission under review: {{name}}',
    submissionPending: 'Your plugin submission is under review: {{name}}',
    submissionApproved: 'Your plugin submission has been approved: {{name}}',
    submissionRejected: 'Your plugin submission has been rejected: {{name}}',
    clickToRevoke: 'Revoke',
    revokeSuccess: 'Revoke success',
    revokeFailed: 'Revoke failed',
    submissionDetails: 'Plugin Submission Details',
    markAsRead: 'Mark as Read',
    markAsReadSuccess: 'Marked as read',
    markAsReadFailed: 'Mark as read failed',
    filterByComponent: 'Component',
    allComponents: 'All Components',
    requestPlugin: 'Request Plugin',
    viewDetails: 'View Details',
  },
  mcp: {
    title: 'MCP',
    createServer: 'Add MCP Server',
    editServer: 'Edit MCP Server',
    deleteServer: 'Delete MCP Server',
    confirmDeleteServer: 'Are you sure you want to delete this MCP server?',
    confirmDeleteTitle: 'Delete MCP Server',
    getServerListError: 'Failed to get MCP server list: ',
    serverName: 'Server Name',
    serverMode: 'Connection Mode',
    stdio: 'Stdio Mode',
    sse: 'SSE Mode',
    noServerInstalled: 'No MCP servers configured',
    serverNameRequired: 'Server name cannot be empty',
    commandRequired: 'Command cannot be empty',
    urlRequired: 'URL cannot be empty',
    timeoutMustBePositive: 'Timeout must be a positive number',
    command: 'Command',
    args: 'Arguments',
    env: 'Environment Variables',
    url: 'URL',
    headers: 'Headers',
    timeout: 'Timeout',
    addArgument: 'Add Argument',
    addEnvVar: 'Add Environment Variable',
    addHeader: 'Add Header',
    keyName: 'Key Name',
    value: 'Value',
    testing: 'Testing...',
    connecting: 'Connecting...',
    testSuccess: 'Test successful',
    testFailed: 'Test failed: ',
    testError: 'Test error',
    refreshSuccess: 'Refresh successful',
    refreshFailed: 'Refresh failed: ',
    connectionSuccess: 'Connection successful',
    connectionFailed: 'Connection failed, please check URL',
    connectionFailedStatus: 'Connection Failed',
    toolsFound: 'tools',
    unknownError: 'Unknown error',
    noToolsFound: 'No tools found',
    parseResultFailed: 'Failed to parse test result',
    noResultReturned: 'Test returned no result',
    getTaskFailed: 'Failed to get task status',
    noTaskId: 'No task ID obtained',
    deleteSuccess: 'Deleted successfully',
    deleteFailed: 'Delete failed: ',
    deleteError: 'Delete failed: ',
    saveSuccess: 'Saved successfully',
    saveError: 'Save failed: ',
    createSuccess: 'Created successfully',
    createFailed: 'Creation failed: ',
    createError: 'Creation failed: ',
    loadFailed: 'Load failed',
    modifyFailed: 'Modify failed: ',
    toolCount: 'Tools: {{count}}',
    statusConnected: 'Connected',
    statusDisconnected: 'Disconnected',
    statusError: 'Connection Error',
    statusDisabled: 'Disabled',
    loading: 'Loading...',
    starCount: 'Stars: {{count}}',
    install: 'Install',
    installFromGithub: 'Install MCP Server from GitHub',
    add: 'Add',
    name: 'Name',
    nameRequired: 'Name cannot be empty',
    sseTimeout: 'SSE Timeout',
    sseTimeoutDescription: 'Timeout for establishing SSE connection',
    extraParametersDescription:
      'Additional parameters for configuring specific MCP server behavior',
    timeoutMustBeNumber: 'Timeout must be a number',
    timeoutNonNegative: 'Timeout cannot be negative',
    sseTimeoutMustBeNumber: 'SSE timeout must be a number',
    sseTimeoutNonNegative: 'SSE timeout cannot be negative',
    updateSuccess: 'Updated successfully',
    updateFailed: 'Update failed: ',
  },
  pipelines: {
    title: 'Pipelines',
    description:
      'Pipelines define the processing flow for message events, used to bind to bots',
    createPipeline: 'Create Pipeline',
    editPipeline: 'Edit Pipeline',
    chat: 'Chat',
    configuration: 'Configuration',
    debugChat: 'Debug Chat',
    getPipelineListError: 'Failed to get pipeline list: ',
    daysAgo: 'days ago',
    today: 'Today',
    updateTime: 'Updated ',
    defaultBadge: 'Default',
    sortBy: 'Sort by',
    newestCreated: 'Newest Created',
    earliestCreated: 'Earliest Created',
    recentlyEdited: 'Recently Edited',
    earliestEdited: 'Earliest Edited',
    basicInfo: 'Basic',
    aiCapabilities: 'AI',
    triggerConditions: 'Trigger',
    safetyControls: 'Safety',
    outputProcessing: 'Output',
    nameRequired: 'Name cannot be empty',
    descriptionRequired: 'Description cannot be empty',
    createSuccess: 'Created successfully. Please edit pipeline parameters',
    createError: 'Creation failed: ',
    saveSuccess: 'Saved successfully',
    saveError: 'Save failed: ',
    copySuffix: ' Copy',
    deleteConfirmation:
      'Are you sure you want to delete this pipeline? Bots bound to this pipeline will not work.',
    defaultPipelineCannotDelete: 'Default pipeline cannot be deleted',
    deleteSuccess: 'Deleted successfully',
    deleteError: 'Delete failed: ',
    copyConfirmTitle: 'Confirm Copy',
    copyConfirmation:
      'Are you sure you want to copy this pipeline? This will create a new pipeline with all configurations.',
    extensions: {
      title: 'Extensions',
      loadError: 'Failed to load plugins',
      saveSuccess: 'Saved successfully',
      saveError: 'Save failed',
      noPluginsAvailable: 'No plugins available',
      disabled: 'Disabled',
      noPluginsSelected: 'No plugins selected',
      addPlugin: 'Add Plugin',
      selectPlugins: 'Select Plugins',
      pluginsTitle: 'Plugins',
      mcpServersTitle: 'MCP Servers',
      noMCPServersSelected: 'No MCP servers selected',
      addMCPServer: 'Add MCP Server',
      selectMCPServers: 'Select MCP Servers',
      toolCount: '{{count}} tools',
      noPluginsInstalled: 'No installed plugins',
      noMCPServersConfigured: 'No configured MCP servers',
      selectAll: 'Select All',
      enableAllPlugins: 'Enable All Plugins',
      enableAllMCPServers: 'Enable All MCP Servers',
      allPluginsEnabled: 'All plugins enabled',
      allMCPServersEnabled: 'All MCP servers enabled',
    },
    debugDialog: {
      title: 'Pipeline Chat',
      selectPipeline: 'Select Pipeline',
      sessionType: 'Session Type',
      privateChat: 'Private Chat',
      groupChat: 'Group Chat',
      send: 'Send',
      reset: 'Reset Conversation',
      inputPlaceholder: 'Send {{type}} message...',
      noMessages: 'No messages',
      userMessage: 'User',
      botMessage: 'Bot',
      sendFailed: 'Send failed',
      resetSuccess: 'Conversation reset successfully',
      resetFailed: 'Reset failed',
      loadMessagesFailed: 'Failed to load messages',
      loadPipelinesFailed: 'Failed to load pipelines',
      atTips: 'Mention the bot',
      streaming: 'Streaming',
      streamOutput: 'Stream',
      connected: 'WebSocket connected',
      disconnected: 'WebSocket disconnected',
      connectionError: 'WebSocket connection error',
      connectionFailed: 'WebSocket connection failed',
      notConnected: 'WebSocket not connected, please try again later',
      imageUploadFailed: 'Image upload failed',
      reply: 'Reply',
      replyTo: 'Reply to',
      showMarkdown: 'Show Markdown',
      showRaw: 'Show Raw',
    },
  },
  knowledge: {
    title: 'Knowledge',
    createKnowledgeBase: 'Create Knowledge Base',
    editKnowledgeBase: 'Edit Knowledge Base',
    selectKnowledgeBase: 'Select Knowledge Base',
    selectKnowledgeBases: 'Select Knowledge Bases',
    addKnowledgeBase: 'Add Knowledge Base',
    noKnowledgeBaseSelected: 'No knowledge bases selected',
    empty: 'Empty',
    editDocument: 'Documents',
    description: 'Configuring knowledge bases for improved LLM responses',
    metadata: 'Metadata',
    documents: 'Documents',
    kbNameRequired: 'Knowledge base name cannot be empty',
    kbDescriptionRequired: 'Knowledge base description cannot be empty',
    embeddingModelUUIDRequired: 'Embedding model cannot be empty',
    daysAgo: 'days ago',
    today: 'Today',
    kbName: 'Knowledge Base Name',
    kbDescription: 'Knowledge Base Description',
    topK: 'Top K',
    topKRequired: 'Top K cannot be empty',
    topKMax: 'Top K maximum value is 30',
    topKdescription:
      'Used to specify the number of relevant documents to retrieve, ranging from 1 to 30.',
    defaultDescription: 'A knowledge base',
    embeddingModelUUID: 'Embedding Model',
    selectEmbeddingModel: 'Select Embedding Model',
    embeddingModelDescription:
      'Used to vectorize the text, you can configure it in the Models page',
    updateTime: 'Updated ',
    cannotChangeEmbeddingModel:
      'Knowledge base created cannot be modified embedding model',
    updateKnowledgeBaseSuccess: 'Knowledge base updated successfully',
    updateKnowledgeBaseFailed: 'Knowledge base update failed',
    documentsTab: {
      name: 'Name',
      status: 'Status',
      noResults: 'No documents',
      dragAndDrop: 'Drag and drop files here or click to upload',
      uploading: 'Uploading...',
      supportedFormats:
        'Supports PDF, Word, TXT, Markdown, HTML, ZIP and other document formats',
      uploadSuccess: 'File uploaded successfully!',
      uploadError: 'File upload failed, please try again',
      uploadingFile: 'Uploading file...',
      fileSizeExceeded:
        'File size exceeds 10MB limit. Please split into smaller files.',
      actions: 'Actions',
      delete: 'Delete File',
      fileDeleteSuccess: 'File deleted successfully',
      fileDeleteFailed: 'File deletion failed',
      processing: 'Processing',
      completed: 'Completed',
      failed: 'Failed',
    },
    deleteKnowledgeBaseConfirmation:
      'Are you sure you want to delete this knowledge base? All documents in this knowledge base will be deleted.',
    retrieve: 'Retrieve Test',
    retrieveTest: 'Retrieve Test',
    query: 'Query',
    queryPlaceholder: 'Enter query text...',
    distance: 'Distance',
    content: 'Content',
    fileName: 'File Name',
    noResults: 'No results',
    retrieveError: 'Retrieve failed',
    builtIn: 'Built-in',
    external: 'External',
    addExternal: 'Add External Knowledge Base',
    createExternalSuccess: 'External knowledge base created successfully',
    updateExternalSuccess: 'External knowledge base updated successfully',
    deleteExternalSuccess: 'External knowledge base deleted successfully',
    retriever: 'Retriever',
    selectRetriever: 'Select a retriever...',
    retrieverConfiguration: 'Retriever Configuration',
    retrieverInstallInfo: 'You can install Knowledge Retriever plugins from',
    retrieverMarketLink: 'here',
  },
  register: {
    title: 'Initialize LangBot 👋',
    description: 'This is your first time starting LangBot',
    adminAccountNote:
      'The account you use here will be set as the administrator account',
    register: 'Register',
    initWithSpace: 'Initialize with Space',
    spaceRecommended:
      'Recommended: Use official stable model APIs and cloud services',
    spaceInfoTip1:
      'Space provides unified account authentication services without uploading any of your sensitive information.',
    spaceInfoTip2:
      'Logging in with a Space account gives you access to LangBot Models and other cloud services, including free model call credits to help you get started quickly.',
    spaceInfoTip3:
      'Your login method does not affect other features. You can configure and use models from other sources at any time.',
    registerLocal: 'Register local account',
    registerWithPassword: 'Register with email and password',
    initSuccess: 'Initialization successful, please login',
    initFailed: 'Initialization failed: ',
  },
  resetPassword: {
    title: 'Reset Password 🔐',
    description:
      'Enter your recovery key and new password to reset your account password',
    recoveryKey: 'Recovery Key',
    recoveryKeyDescription:
      'Stored in `system.recovery_key` of config file `data/config.yaml`',
    newPassword: 'New Password',
    enterRecoveryKey: 'Enter recovery key',
    enterNewPassword: 'Enter new password',
    recoveryKeyRequired: 'Recovery key cannot be empty',
    newPasswordRequired: 'New password cannot be empty',
    resetPassword: 'Reset Password',
    resetting: 'Resetting...',
    resetSuccess: 'Password reset successfully, please login',
    resetFailed:
      'Password reset failed, please check your email and recovery key',
    backToLogin: 'Back to Login',
  },
  embedding: {
    description: 'Manage Embedding models for text vectorization',
    createModel: 'Create Embedding Model',
    editModel: 'Edit Embedding Model',
    getModelListError: 'Failed to get Embedding model list: ',
    embeddingModels: 'Embedding',
    extraParametersDescription:
      'Will be attached to the request body, such as encoding_format, dimensions, etc.',
  },
  llm: {
    description: 'Manage LLM models for conversation generation',
    llmModels: 'LLM',
    extraParametersDescription:
      'Will be attached to the request body, such as max_tokens, temperature, top_p, etc.',
  },
  version: {
    newVersionAvailable: 'New Version Available',
    viewUpdateGuide: 'View Update Guide',
    noReleaseNotes: 'No release notes available',
  },
  account: {
    settings: 'Account Settings',
    setPassword: 'Set Password',
    passwordSetSuccess: 'Password set successfully',
    passwordStatus: 'Local Password',
    passwordSet: 'Set',
    passwordNotSet: 'Not Set',
    passwordSetDescription:
      'Password is set, you can login with email and password',
    spaceStatus: 'Space Account',
    spaceBound: 'Bound',
    spaceNotBound: 'Not Bound',
    spaceBoundDescription:
      'Space account bound, official model APIs and cloud services available',
    bindSpace: 'Bind Space Account',
    bindSpaceDescription: 'Bind to use official model APIs and cloud services',
    bindSpaceButton: 'Bind',
    bindSpaceConfirmTitle: 'Confirm Binding',
    bindSpaceConfirmDescription:
      'You are about to bind your local instance to a Space account',
    bindSpaceWarning:
      'After binding, your login email will be changed from {{localEmail}} to the Space account email.',
    bindSpaceSuccess: 'Space account bound successfully',
    bindSpaceFailed: 'Failed to bind Space account',
    bindSpaceInvalidState:
      'Invalid bind request. Please try again from account settings.',
    setPasswordHint: 'Set a password to login with email and password',
    spaceEmailMismatch:
      'Space login email does not match the local account email',
  },
};

export default enUS;
