# Homer3
![Homer3](https://openfnirs.org/wp-content/uploads/2018/05/Figure_fNIRS2.jpg)

Homer3 is a open source MATLAB application used for analyzing fNIRS data to obtain estimates and maps of brain activation. It is a continuation of the work on the well-established HOMER2 software which itself evolved since the early 1990s, first as the Photon Migration Imaging Toolbox, then as HOMER.

Homer3 is developed and maintained by the [Boston University Neurophotonics Center](http://www.bu.edu/neurophotonics/).

To cite Homer3 in your research:

> ##### Huppert, T., Diamond, S., Franceschini, M., Boas, D. (2009). HomER: a review of time-series analysis methods for near-infrared spectroscopy of the brain. Applied optics 48(10). https://dx.doi.org/10.1364/ao.48.00d280

## Installation

Homer3 is composed only of MATLAB scripts, so the installation process for MATLAB users is as simple as downloading the code.

[Get the latest release of Homer3](https://github.com/BUNPC/Homer3/releases/latest/)

[Getting started with Homer3](https://github.com/BUNPC/Homer3/wiki/Getting-started-with-Homer3)

Note that cloning the repository or using the Download .zip button on the repository webpage WILL NOT download the submodule libraries that are a part of Homer3. Without these, the application will not run. These submodules must be downloaded manually from their respective repositories and placed in the \Homer3 folder.

## Support
Support for users of Homer3 is available via the [Homer3 & AtlasViewer community forum](https://openfnirs.org/community/homer3-forum/) hosted on openfnirs.org. This forum is for questions about how to use Homer3.

To report a bug or suggest a feature, please [create an issue](https://github.com/BUNPC/Homer3/issues/new/choose) here on GitHub.

## Documentation

Homer3 documentation is hosted via the [GitHub wiki](https://github.com/BUNPC/Homer3/wiki) and is a work in progress.

## Contributing to Homer3

We welcome contributions to Homer3 from the fNIRS community. See [CONTRIBUTING.md](.github/CONTRIBUTING.md) for development guidelines and [WORKFLOW.md](.github/WORKFLOW.md) for a walkthrough of the cloning and version control procedures recommended for development.

## License

Homer3 is [BSD licensed](https://opensource.org/licenses/BSD-3-Clause), but we ask that you cite the original publication in your research.
