# 自定义派遣脚本使用说明

## 使用方法

1. 进入 `./resource/base/pipeline/dispatch` 文件夹内（繁中服进入`./resource/zh-tw/pipeline/dispatch`），打开对应的据点派遣脚本。如想修改广陵的派遣阵容，就打开 `dispatch-guangling.json` 。

2. 在脚本内依次修改 `"找到XX（据点名）派遣角色1/2/3":{...}`大括号里的`"expected:"XX（派遣密探名）"` ，改为你想要上阵的密探名字。

3. 修改后保存文件，并检查其他据点文件内上阵角色是否有重复。
   默认阵容为：

   ```
   洛阳 - 飞云、高览、甘缇
   寿春 - 第五天、毛玠、李真
   广陵 - 蜂使、严颜、绣球
   下邳 - 周群、杨阜、楼班
   ```

4. 修改完成后可以备份一下 `dispatch` 文件夹，后续版本更新后，把备份过的文件夹覆盖回来即可。

## Tips

1. 在不修改其他内容的情况下，是通过 OCR（文字识别）来找密探名字的，有可能会识别失败，需要修改识别内容（`"expected"`的内容）
   - 例 1：`毛玠`只能识别出`毛`，见 `dispatch-shouchun.json`
   - 例 2：代号鸢港服中 `李真` 会被识别成 `李眞` ，需要加入一行替换词表
     `"replace": ["李眞", "李真"]`
     具体写法见 `dispatch-shouchun.json`
2. 如果 OCR + 修改参数还是识别不出来，可以考虑改为识图（找密探小头像）。具体做法参考`MAAframework - pipeline协议`相关部分。有需要的话可以在群里问。
3. 当前为测试版本，如果遇到其他问题也欢迎反馈！（频道内反馈或者在 github 上提 issue / discussion 皆可）
