const session = {
  not_found: '未找到會話。請返回並重新登錄。',
  invalid_credentials: '賬號或密碼錯誤，請重新輸入。',
  invalid_sign_in_method: '當前登錄方式不可用',
  invalid_connector_id: '找不到 ID 為 {{connectorId}} 的可用連接器。',
  insufficient_info: '登錄信息缺失，請檢查你的輸入。',
  connector_id_mismatch: '傳入的連接器 ID 與 session 中保存的記錄不一致',
  connector_session_not_found: '無法找到連接器登錄信息，請嘗試重新登錄。',
  verification_session_not_found: '驗證失敗，請重新驗證。',
  verification_expired: '當前頁面已超時。為確保你的賬號安全，請重新驗證。',
  verification_blocked_too_many_attempts: '短時間內嘗試次數太多。請過一會再試 {{relativeTime}}。',
  unauthorized: '請先登錄',
  unsupported_prompt_name: '不支持的 prompt name',
  forgot_password_not_enabled: '忘記密碼功能沒有開啟。',
  verification_failed: '驗證失敗，請重新驗證。',
  connector_validation_session_not_found: '找不到連接器用於驗證 token 的信息。',
  csrf_token_mismatch: 'CSRF token 不匹配。',
  identifier_not_found: '找不到用戶標識符。請返回並重新登錄。',
  interaction_not_found: '找不到互動會話。請返回並重新開始會話。',
  invalid_interaction_type: '此操作不支援當前的互動。請啟動一個新的會話。',
  not_supported_for_forgot_password: '此操作不支援忘記密碼。',
  identity_conflict: '偵測到身份不匹配。請啟動一個新的會話以使用不同的身份繼續。',
  identifier_not_verified:
    '提供的標識符 {{identifier}} 尚未驗證。請為此標識符創建驗證記錄並完成驗證過程。',
  mfa: {
    require_mfa_verification: '需要 MFA 驗證才能登錄。',
    mfa_sign_in_only: 'MFA 只能用於登錄互動。',
    pending_info_not_found: '未找到等待中的 MFA 資訊，請先啟動 MFA。',
    invalid_totp_code: '無效的 TOTP 驗證碼。',
    webauthn_verification_failed: 'WebAuthn 驗證失敗。',
    webauthn_verification_not_found: '未找到 WebAuthn 驗證。',
    bind_mfa_existed: 'MFA 已存在。',
    backup_code_can_not_be_alone: '備用碼不能作為唯一 MFA。',
    backup_code_required: '備用碼是必需的。',
    invalid_backup_code: '無效的備用碼。',
    mfa_policy_not_user_controlled: 'MFA 政策不受使用者控制。',
    mfa_factor_not_enabled: 'MFA 因素未啟用。',
    suggest_additional_mfa: '為更強的保護，建議新增另一種多重驗證方式。你可略過此步驟並繼續。',
  },
  sso_enabled: '該郵箱已開啟單點登錄，請使用 SSO 登錄。',
  captcha_required: '需要 Captcha。',
  captcha_failed: 'Captcha 驗證失敗。',
  email_blocklist: {
    disposable_email_validation_failed: '電子郵件地址驗證失敗。',
    invalid_email: '無效的電子郵件地址。',
    email_subaddressing_not_allowed: '不允許使用電子郵件子地址。',
    email_not_allowed: '電子郵件地址 "{{email}}" 受限。請選擇其他地址。',
  },
  google_one_tap: {
    cookie_mismatch: 'Google One Tap cookie 不匹配。',
    invalid_id_token: '無效的 Google ID Token。',
    unverified_email: '未驗證的電子郵件。',
  },
};

export default Object.freeze(session);
