const account_center = {
  header: {
    title: 'Центр облікового запису',
  },
  home: {
    title: 'Сторінку не знайдено',
    description: 'Ця сторінка недоступна.',
  },
  verification: {
    title: 'Перевірка безпеки',
    description:
      'Підтвердьте, що це ви, щоб захистити безпеку облікового запису. Будь ласка, оберіть спосіб підтвердження особи.',
    error_send_failed: 'Не вдалося надіслати код підтвердження. Спробуйте ще раз пізніше.',
    error_invalid_code: 'Код підтвердження недійсний або строк його дії минув.',
    error_verify_failed: 'Не вдалося підтвердити. Будь ласка, введіть код ще раз.',
    verification_required: 'Термін перевірки минув. Підтвердіть свою особу ще раз.',
    try_another_method: 'Спробуйте інший спосіб підтвердження',
  },
  password_verification: {
    title: 'Підтвердьте пароль',
    description: 'Щоб захистити обліковий запис, введіть пароль для підтвердження своєї особи.',
    error_failed: 'Перевірка не вдалася. Перевірте пароль.',
  },
  verification_method: {
    password: {
      name: 'Пароль',
      description: 'Підтвердьте свій пароль',
    },
    email: {
      name: 'Код підтвердження електронної пошти',
      description: 'Надіслати код підтвердження на вашу пошту',
    },
    phone: {
      name: 'Код підтвердження телефону',
      description: 'Надіслати код підтвердження на ваш номер телефону',
    },
  },
  email: {
    title: "Прив'язати email",
    description:
      "Прив'яжіть свій email, щоб входити або допомогти з відновленням облікового запису.",
    verification_title: 'Введіть код підтвердження email',
    verification_description: 'Код підтвердження надіслано на ваш email {{email_address}}.',
    success: "Основний email успішно прив'язано.",
    verification_required: 'Термін перевірки минув. Підтвердіть свою особу ще раз.',
  },
  phone: {
    title: "Прив'язати телефон",
    description:
      "Прив'яжіть номер телефону, щоб увійти або допомогти з відновленням облікового запису.",
    verification_title: 'Введіть код підтвердження SMS',
    verification_description: 'Код підтвердження надіслано на ваш телефон {{phone_number}}.',
    success: "Основний телефон успішно прив'язано.",
    verification_required: 'Термін перевірки минув. Підтвердіть свою особу ще раз.',
  },
  username: {
    title: "Встановити ім'я користувача",
    description: "Ім'я користувача може містити лише літери, цифри та символи підкреслення.",
    success: "Ім'я користувача успішно оновлено.",
  },
  password: {
    title: 'Встановити пароль',
    description: 'Створіть новий пароль, щоб захистити свій обліковий запис.',
    success: 'Пароль успішно оновлено.',
  },

  code_verification: {
    send: 'Надіслати код підтвердження',
    resend: 'Ще не отримали? <a>Надіслати код підтвердження ще раз</a>',
    resend_countdown: 'Ще не отримали?<span> Повторна відправка через {{seconds}} с.</span>',
  },

  email_verification: {
    title: 'Підтвердьте свою електронну пошту',
    prepare_description:
      'Підтвердіть, що це ви, щоб захистити безпеку облікового запису. Надішліть код підтвердження на свою електронну пошту.',
    email_label: 'Адреса електронної пошти',
    send: 'Надіслати код підтвердження',
    description: 'Код підтвердження надіслано на адресу {{email}}. Введіть код, щоб продовжити.',
    resend: 'Ще не отримали? <a>Надіслати код підтвердження ще раз</a>',
    resend_countdown: 'Ще не отримали?<span> Повторна відправка через {{seconds}} с.</span>',
    error_send_failed: 'Не вдалося надіслати код підтвердження. Спробуйте ще раз пізніше.',
    error_verify_failed: 'Не вдалося підтвердити. Будь ласка, введіть код ще раз.',
    error_invalid_code: 'Код підтвердження недійсний або строк його дії минув.',
  },
  phone_verification: {
    title: 'Підтвердьте свій телефон',
    prepare_description:
      'Підтвердьте, що це ви, щоб захистити безпеку облікового запису. Надішліть код підтвердження на свій телефон.',
    phone_label: 'Номер телефону',
    send: 'Надіслати код підтвердження',
    description:
      'Код підтвердження надіслано на ваш телефон {{phone}}. Введіть код, щоб продовжити.',
    resend: 'Ще не отримали? <a>Надіслати код підтвердження ще раз</a>',
    resend_countdown: 'Ще не отримали?<span> Повторна відправка через {{seconds}} с.</span>',
    error_send_failed: 'Не вдалося надіслати код підтвердження. Спробуйте ще раз пізніше.',
    error_verify_failed: 'Не вдалося підтвердити. Будь ласка, введіть код ще раз.',
    error_invalid_code: 'Код підтвердження недійсний або строк його дії минув.',
  },
  mfa: {
    totp_already_added:
      'Ви вже додали додаток для автентифікації. Будь ласка, спочатку видаліть існуючий.',
    totp_not_enabled:
      'Додаток для автентифікації не увімкнено. Будь ласка, зверніться до адміністратора, щоб увімкнути його.',
    backup_code_already_added:
      'У вас вже є активні резервні коди. Будь ласка, використайте або видаліть їх перед створенням нових.',
    backup_code_not_enabled:
      'Резервний код не увімкнено. Будь ласка, зверніться до адміністратора, щоб увімкнути його.',
    backup_code_requires_other_mfa:
      'Резервні коди вимагають попереднього налаштування іншого методу MFA.',
    passkey_not_enabled:
      'Passkey не увімкнено. Будь ласка, зверніться до адміністратора, щоб увімкнути його.',
  },
  update_success: {
    default: {
      title: 'Оновлено!',
      description: 'Вашу інформацію було оновлено.',
    },
    email: {
      title: 'Електронну пошту оновлено!',
      description: 'Вашу електронну адресу успішно оновлено.',
    },
    phone: {
      title: 'Номер телефону оновлено!',
      description: 'Ваш номер телефону успішно оновлено.',
    },
    username: {
      title: "Ім'я користувача змінено!",
      description: "Ваше ім'я користувача успішно оновлено.",
    },

    password: {
      title: 'Пароль змінено!',
      description: 'Ваш пароль успішно оновлено.',
    },
    social: {
      title: "Соціальний акаунт під'єднано!",
      description: "Ваш соціальний акаунт успішно під'єднано.",
    },
    totp: {
      title: 'Додаток для автентифікації додано!',
      description: "Ваш додаток для автентифікації успішно під'єднано до вашого акаунту.",
    },
    backup_code: {
      title: 'Резервні коди створено!',
      description: 'Ваші резервні коди збережено. Зберігайте їх у безпечному місці.',
    },
    backup_code_deleted: {
      title: 'Резервні коди видалено!',
      description: 'Ваші резервні коди було видалено з вашого облікового запису.',
    },
    passkey: {
      title: 'Passkey додано!',
      description: "Ваш passkey успішно під'єднано до вашого облікового запису.",
    },
    passkey_deleted: {
      title: 'Passkey видалено!',
      description: 'Ваш passkey було видалено з вашого облікового запису.',
    },
  },
  backup_code: {
    title: 'Резервні коди',
    description:
      'Ви можете використати один з цих резервних кодів для доступу до свого облікового запису, якщо у вас виникнуть проблеми під час двоетапної перевірки іншими способами. Кожен код можна використати лише один раз.',
    copy_hint: "Обов'язково скопіюйте їх і збережіть у надійному місці.",
    generate_new_title: 'Згенерувати нові резервні коди',
    generate_new: 'Згенерувати нові резервні коди',
    delete_confirmation_title: 'Видалити ваші резервні коди',
    delete_confirmation_description:
      'Якщо ви видалите ці резервні коди, ви не зможете використовувати їх для підтвердження.',
  },
  passkey: {
    title: 'Passkeys',
    added: 'Додано: {{date}}',
    last_used: 'Останнє використання: {{date}}',
    never_used: 'Ніколи',
    unnamed: 'Passkey без назви',
    renamed: 'Passkey успішно перейменовано.',
    add_another_title: 'Додати інший passkey',
    add_another_description:
      'Зареєструйте свій passkey за допомогою біометрії пристрою, ключів безпеки (наприклад, YubiKey) або інших доступних методів.',
    add_passkey: 'Додати passkey',
    delete_confirmation_title: 'Видалити passkey',
    delete_confirmation_description:
      'Ви впевнені, що хочете видалити "{{name}}"? Ви більше не зможете використовувати цей passkey для входу.',
    rename_passkey: 'Перейменувати passkey',
    rename_description: 'Введіть нову назву для цього passkey.',
  },
};

export default Object.freeze(account_center);
