/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.system.incus;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.hub.comp.StoreEntryComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreToggleComp;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.BindingsHelper;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.ext.system.incus.IncusInstallStore;
import java.util.List;
import javafx.beans.value.ObservableValue;

public class IncusInstallStoreProvider
implements DataStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.LXC;
    }

    public StoreEntryComp customEntryComp(StoreSection sec, boolean preferLarge) {
        StoreToggleComp nonRunning = StoreToggleComp.childrenToggle(null, (boolean)true, (StoreSection)sec, s -> ((IncusInstallStore.State)s.getState()).isShowNonRunning(), (s, aBoolean) -> {
            DataStoreState state = ((IncusInstallStore.State.StateBuilder)((Object)((Object)((IncusInstallStore.State)s.getState()).toBuilder().showNonRunning((boolean)aBoolean)))).build();
            s.setState(state);
        });
        return StoreEntryComp.create((StoreSection)sec, (Comp)nonRunning, (boolean)preferLarge);
    }

    public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp((ObservableValue)BindingsHelper.map((ObservableValue)w.getPersistentState(), o -> {
            IncusInstallStore.State state = (IncusInstallStore.State)((Object)((Object)o));
            if (state.isReachable()) {
                return SystemStateComp.State.SUCCESS;
            }
            return SystemStateComp.State.FAILURE;
        }));
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.GROUP;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        IncusInstallStore s = (IncusInstallStore)store.getStore().asNeeded();
        return s.getHost().get();
    }

    public ObservableValue<String> informationString(StoreSection section) {
        return BindingsHelper.map((ObservableValue)section.getWrapper().getPersistentState(), o -> {
            IncusInstallStore.State state = (IncusInstallStore.State)((Object)((Object)o));
            return state.isReachable() ? "incus v" + state.getServerVersion() : "Connection failed";
        });
    }

    public String getDisplayIconFileName(DataStore store) {
        return "system:lxd_icon.svg";
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return new IncusInstallStore((DataStoreEntryRef<ShellStore>)DataStorage.get().local().ref());
    }

    public String getId() {
        return "incusInstall";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(IncusInstallStore.class);
    }
}

