/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.prefs.ExternalApplicationHelper;
import io.xpipe.app.util.Hyperlinks;
import java.util.Locale;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Undefined.class), @JsonSubTypes.Type(value=Http.class), @JsonSubTypes.Type(value=Https.class), @JsonSubTypes.Type(value=Custom.class)})
public interface ServiceProtocolType {
    public String formatAddress(String var1);

    public void open(String var1) throws Exception;

    public String getTranslationKey();

    @JsonTypeName(value="custom")
    @JsonDeserialize(builder=CustomBuilder.class)
    public static final class Custom
    implements ServiceProtocolType {
        private final String commandTemplate;

        @Override
        public String formatAddress(String base) {
            return base;
        }

        @Override
        public void open(String url) throws Exception {
            if (this.commandTemplate == null || this.commandTemplate.isBlank()) {
                return;
            }
            String port = url.split(":")[1];
            Object format = this.commandTemplate.toLowerCase(Locale.ROOT).contains("$port") ? this.commandTemplate : this.commandTemplate + " localhost:$PORT";
            String toExecute = ExternalApplicationHelper.replaceVariableArgument((String)format, (String)"PORT", (String)port);
            ExternalApplicationHelper.startAsync((String)toExecute);
        }

        @Override
        public String getTranslationKey() {
            return "custom";
        }

        @Generated
        Custom(String commandTemplate) {
            this.commandTemplate = commandTemplate;
        }

        @Generated
        public static CustomBuilder builder() {
            return new CustomBuilder();
        }

        @Generated
        public String getCommandTemplate() {
            return this.commandTemplate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Custom)) {
                return false;
            }
            Custom other = (Custom)o;
            String this$commandTemplate = this.getCommandTemplate();
            String other$commandTemplate = other.getCommandTemplate();
            return !(this$commandTemplate == null ? other$commandTemplate != null : !this$commandTemplate.equals(other$commandTemplate));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $commandTemplate = this.getCommandTemplate();
            result = result * 59 + ($commandTemplate == null ? 43 : $commandTemplate.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceProtocolType.Custom(commandTemplate=" + this.getCommandTemplate() + ")";
        }

        @JsonTypeName(value="custom")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class CustomBuilder {
            @Generated
            private String commandTemplate;

            @Generated
            CustomBuilder() {
            }

            @Generated
            public CustomBuilder commandTemplate(String commandTemplate) {
                this.commandTemplate = commandTemplate;
                return this;
            }

            @Generated
            public Custom build() {
                return new Custom(this.commandTemplate);
            }

            @Generated
            public String toString() {
                return "ServiceProtocolType.Custom.CustomBuilder(commandTemplate=" + this.commandTemplate + ")";
            }
        }
    }

    @JsonTypeName(value="https")
    @JsonDeserialize(builder=HttpsBuilder.class)
    public static final class Https
    implements ServiceProtocolType {
        private final String path;

        @Override
        public String formatAddress(String base) {
            String url = "https://" + base;
            if (this.path != null && !this.path.isEmpty()) {
                url = url + (!this.path.startsWith("/") ? "/" : "") + this.path;
            }
            return url;
        }

        @Override
        public void open(String url) {
            Hyperlinks.open((String)url);
        }

        @Override
        public String getTranslationKey() {
            return "https";
        }

        @Generated
        Https(String path) {
            this.path = path;
        }

        @Generated
        public static HttpsBuilder builder() {
            return new HttpsBuilder();
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Https)) {
                return false;
            }
            Https other = (Https)o;
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceProtocolType.Https(path=" + this.getPath() + ")";
        }

        @JsonTypeName(value="https")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class HttpsBuilder {
            @Generated
            private String path;

            @Generated
            HttpsBuilder() {
            }

            @Generated
            public HttpsBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public Https build() {
                return new Https(this.path);
            }

            @Generated
            public String toString() {
                return "ServiceProtocolType.Https.HttpsBuilder(path=" + this.path + ")";
            }
        }
    }

    @JsonTypeName(value="http")
    @JsonDeserialize(builder=HttpBuilder.class)
    public static final class Http
    implements ServiceProtocolType {
        private final String path;

        @Override
        public String formatAddress(String base) {
            String url = "http://" + base;
            if (this.path != null && !this.path.isEmpty()) {
                url = url + (!this.path.startsWith("/") ? "/" : "") + this.path;
            }
            return url;
        }

        @Override
        public void open(String url) {
            Hyperlinks.open((String)url);
        }

        @Override
        public String getTranslationKey() {
            return "http";
        }

        @Generated
        Http(String path) {
            this.path = path;
        }

        @Generated
        public static HttpBuilder builder() {
            return new HttpBuilder();
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Http)) {
                return false;
            }
            Http other = (Http)o;
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceProtocolType.Http(path=" + this.getPath() + ")";
        }

        @JsonTypeName(value="http")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class HttpBuilder {
            @Generated
            private String path;

            @Generated
            HttpBuilder() {
            }

            @Generated
            public HttpBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public Http build() {
                return new Http(this.path);
            }

            @Generated
            public String toString() {
                return "ServiceProtocolType.Http.HttpBuilder(path=" + this.path + ")";
            }
        }
    }

    @JsonTypeName(value="none")
    @JsonDeserialize(builder=UndefinedBuilder.class)
    public static final class Undefined
    implements ServiceProtocolType {
        @Override
        public String formatAddress(String base) {
            return base;
        }

        @Override
        public void open(String url) {
        }

        @Override
        public String getTranslationKey() {
            return "undefined";
        }

        @Generated
        Undefined() {
        }

        @Generated
        public static UndefinedBuilder builder() {
            return new UndefinedBuilder();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Undefined;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "ServiceProtocolType.Undefined()";
        }

        @JsonTypeName(value="none")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class UndefinedBuilder {
            @Generated
            UndefinedBuilder() {
            }

            @Generated
            public Undefined build() {
                return new Undefined();
            }

            @Generated
            public String toString() {
                return "ServiceProtocolType.Undefined.UndefinedBuilder()";
            }
        }
    }
}

