/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.service;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.ext.SingletonSessionStoreProvider;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.app.util.StoreStateFormat;
import io.xpipe.core.FailableRunnable;
import io.xpipe.ext.base.host.HostAddressGatewayStore;
import io.xpipe.ext.base.service.AbstractServiceStore;
import io.xpipe.ext.base.service.CustomServiceGroupStore;
import io.xpipe.ext.base.service.ServiceProtocolType;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;

public abstract class AbstractServiceStoreProvider
implements SingletonSessionStoreProvider,
DataStoreProvider {
    public boolean showIncompleteInfo() {
        return true;
    }

    public DocumentationLink getHelpLink() {
        return DocumentationLink.SERVICES;
    }

    public boolean supportsSession(SingletonSessionStore<?> s) {
        AbstractServiceStore abs = (AbstractServiceStore)s;
        if (abs.getAddress() != null) {
            return abs.getGateway() != null && ((NetworkTunnelStore)abs.getGateway().getStore()).isLocallyTunnelable() && ((NetworkTunnelStore)abs.getGateway().getStore()).requiresTunnel();
        }
        if (abs.getHost() != null) {
            HostAddressGatewayStore a;
            DataStore dataStore = abs.getHost().getStore();
            if (dataStore instanceof HostAddressGatewayStore && (a = (HostAddressGatewayStore)dataStore).getTunnelGateway() != null && ((NetworkTunnelStore)a.getTunnelGateway().getStore()).requiresTunnel() && ((NetworkTunnelStore)a.getTunnelGateway().getStore()).isLocallyTunnelable() && abs.shouldTunnel()) {
                return true;
            }
            dataStore = abs.getHost().getStore();
            if (dataStore instanceof NetworkTunnelStore) {
                DataStore dataStore2;
                NetworkTunnelStore t = (NetworkTunnelStore)dataStore;
                if (!t.requiresTunnel()) {
                    return false;
                }
                if (!abs.shouldTunnel()) {
                    return false;
                }
                if (t.isLocallyTunnelable()) {
                    return true;
                }
                DataStoreEntryRef parent = t.getNetworkParent();
                if (!t.isLocallyTunnelable() && (dataStore2 = parent.getStore()) instanceof NetworkTunnelStore) {
                    NetworkTunnelStore nts = (NetworkTunnelStore)dataStore2;
                    return nts.isLocallyTunnelable();
                }
                return false;
            }
        }
        return false;
    }

    public FailableRunnable<Exception> launch(DataStoreEntry store) {
        return () -> {
            AbstractServiceStore serviceStore = (AbstractServiceStore)store.getStore().asNeeded();
            serviceStore.startSessionIfNeeded();
            String full = serviceStore.getServiceProtocolType().formatAddress(serviceStore.getOpenTargetUrl());
            serviceStore.getServiceProtocolType().open(full);
        };
    }

    public String displayName(DataStoreEntry entry) {
        AbstractServiceStore s = (AbstractServiceStore)entry.getStore().asNeeded();
        return DataStorage.get().getStoreEntryDisplayName(s.getHost().get()) + " - Port " + s.getRemotePort();
    }

    public List<String> getSearchableTerms(DataStore store) {
        AbstractServiceStore s = (AbstractServiceStore)store.asNeeded();
        ArrayList<String> l = new ArrayList<String>();
        l.add("" + s.getRemotePort());
        if (s.getLocalPort() != null) {
            l.add("" + s.getLocalPort());
        }
        if (s.getAddress() != null) {
            l.add(s.getAddress());
        }
        return l;
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.TUNNEL;
    }

    public DataStoreEntry getSyntheticParent(DataStoreEntry store) {
        AbstractServiceStore s = (AbstractServiceStore)store.getStore().asNeeded();
        return DataStorage.get().getOrCreateNewSyntheticEntry(s.getHost().get(), "Services", (DataStore)((CustomServiceGroupStore.CustomServiceGroupStoreBuilder)CustomServiceGroupStore.builder().parent(s.getHost())).build());
    }

    public ObservableValue<String> informationString(StoreSection section) {
        return Bindings.createStringBinding(() -> {
            String type;
            AbstractServiceStore s = (AbstractServiceStore)section.getWrapper().getEntry().getStore().asNeeded();
            String desc = this.formatService(s);
            String string = type = s.getServiceProtocolType() != null && !(s.getServiceProtocolType() instanceof ServiceProtocolType.Undefined) ? AppI18n.get((String)s.getServiceProtocolType().getTranslationKey(), (Object[])new Object[0]) : null;
            String state = !s.requiresTunnel() ? null : (s.isSessionRunning() ? AppI18n.get((String)"active", (Object[])new Object[0]) : (s.isSessionEnabled() ? AppI18n.get((String)"starting", (Object[])new Object[0]) : AppI18n.get((String)"inactive", (Object[])new Object[0])));
            return new StoreStateFormat(List.of(), desc, new String[]{type, state}).format();
        }, (Observable[])new Observable[]{section.getWrapper().getCache(), AppI18n.activeLanguage()});
    }

    public String getDisplayIconFileName(DataStore store) {
        return "base:service_icon.svg";
    }

    public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp((ObservableValue)Bindings.createObjectBinding(() -> {
            if (!w.getEntry().getValidity().isUsable()) {
                return SystemStateComp.State.OTHER;
            }
            AbstractServiceStore s = (AbstractServiceStore)w.getEntry().getStore().asNeeded();
            if (!s.requiresTunnel()) {
                return SystemStateComp.State.SUCCESS;
            }
            if (!s.isSessionEnabled() || s.isSessionEnabled() && !s.isSessionRunning()) {
                return SystemStateComp.State.OTHER;
            }
            return s.isSessionRunning() ? SystemStateComp.State.SUCCESS : SystemStateComp.State.FAILURE;
        }, (Observable[])new Observable[]{w.getCache()}));
    }

    protected String formatService(AbstractServiceStore s) {
        String desc = s.getLocalPort() != null ? "localhost:" + s.getLocalPort() + " <- :" + s.getRemotePort() : (s.isSessionRunning() ? "localhost:" + ((NetworkTunnelSession)s.getSession()).getLocalPort() + " <- :" + s.getRemotePort() : AppI18n.get((String)"servicePort", (Object[])new Object[]{s.getRemotePort()}));
        return desc;
    }
}

