/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.script;

import io.xpipe.app.comp.Comp;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreCreationCategory;
import io.xpipe.app.ext.DataStoreProvider;
import io.xpipe.app.ext.DataStoreUsageCategory;
import io.xpipe.app.ext.EnabledParentStoreProvider;
import io.xpipe.app.ext.GuiDialog;
import io.xpipe.app.hub.comp.StoreChoiceComp;
import io.xpipe.app.hub.comp.StoreEntryWrapper;
import io.xpipe.app.hub.comp.StoreSection;
import io.xpipe.app.hub.comp.StoreViewState;
import io.xpipe.app.hub.comp.SystemStateComp;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.DocumentationLink;
import io.xpipe.ext.base.script.ScriptGroupStore;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;

public class ScriptGroupStoreProvider
implements EnabledParentStoreProvider,
DataStoreProvider {
    public DocumentationLink getHelpLink() {
        return DocumentationLink.SCRIPTING;
    }

    public Comp<?> stateDisplay(StoreEntryWrapper w) {
        return new SystemStateComp((ObservableValue)new SimpleObjectProperty((Object)SystemStateComp.State.SUCCESS));
    }

    public DataStoreCreationCategory getCreationCategory() {
        return DataStoreCreationCategory.SCRIPT;
    }

    public DataStoreUsageCategory getUsageCategory() {
        return DataStoreUsageCategory.GROUP;
    }

    public DataStoreEntry getDisplayParent(DataStoreEntry store) {
        ScriptGroupStore scriptStore = (ScriptGroupStore)store.getStore().asNeeded();
        return scriptStore.getParent() != null ? scriptStore.getParent().get() : null;
    }

    public GuiDialog guiDialog(DataStoreEntry entry, Property<DataStore> store) {
        ScriptGroupStore st = (ScriptGroupStore)((DataStore)store.getValue()).asNeeded();
        SimpleObjectProperty group = new SimpleObjectProperty(st.getGroup());
        SimpleObjectProperty description = new SimpleObjectProperty((Object)st.getDescription());
        return new OptionsBuilder().name("description").description("scriptGroupDescriptionDescription").addString((Property)description).name("scriptGroup").description("scriptGroupGroupDescription").addComp((Comp)new StoreChoiceComp(entry, (ObjectProperty)group, ScriptGroupStore.class, null, StoreViewState.get().getAllScriptsCategory()), (Property)group).bind(() -> ((ScriptGroupStore.ScriptGroupStoreBuilder)((ScriptGroupStore.ScriptGroupStoreBuilder)ScriptGroupStore.builder().group((DataStoreEntryRef<ScriptGroupStore>)((DataStoreEntryRef)group.get()))).description((String)description.getValue())).build(), new Property[]{store}).buildDialog();
    }

    public ObservableValue<String> informationString(StoreSection section) {
        ScriptGroupStore scriptStore = (ScriptGroupStore)section.getWrapper().getEntry().getStore().asNeeded();
        return new SimpleStringProperty(scriptStore.getDescription());
    }

    public String getDisplayIconFileName(DataStore store) {
        return "proc:shellEnvironment_icon.svg";
    }

    public DataStore defaultStore(DataStoreCategory category) {
        return ScriptGroupStore.builder().build();
    }

    public String getId() {
        return "scriptGroup";
    }

    public List<Class<?>> getStoreClasses() {
        return List.of(ScriptGroupStore.class);
    }
}

