/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.base.TextFieldComp;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.prefs.AppPrefs;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.SshIdentityStateManager;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.control.TextField;
import lombok.Generated;

@JsonTypeName(value="sshAgent")
@JsonDeserialize(builder=OpenSshAgentStrategyBuilder.class)
public final class OpenSshAgentStrategy
implements SshIdentityStrategy {
    private final boolean forwardAgent;
    private final String publicKey;

    public static OptionsBuilder createOptions(Property<OpenSshAgentStrategy> p, SshIdentityStrategyChoiceConfig config) {
        FilePath socket = (FilePath)AppPrefs.get().defaultSshAgentSocket().getValue();
        SimpleBooleanProperty forward = new SimpleBooleanProperty(p.getValue() != null && ((OpenSshAgentStrategy)p.getValue()).isForwardAgent());
        SimpleStringProperty publicKey = new SimpleStringProperty(p.getValue() != null ? ((OpenSshAgentStrategy)p.getValue()).getPublicKey() : null);
        return new OptionsBuilder().nameAndDescription("agentSocket").addStaticString(socket != null ? socket : AppI18n.get((String)"agentSocketNotFound", (Object[])new Object[0])).hide(OsType.ofLocal() == OsType.WINDOWS).nameAndDescription("forwardAgent").addToggle((Property)forward).nonNull().hide(!config.isAllowAgentForward()).nameAndDescription("publicKey").addComp(new TextFieldComp((Property)publicKey).apply(struc -> ((TextField)struc.get()).setPromptText("ssh-rsa AAAAB3NzaC1yc2EAAAABJQAAAIBmhLUTJiP...== Your Comment")), (Property)publicKey).bind(() -> new OpenSshAgentStrategy(forward.get(), publicKey.get()), new Property[]{p});
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        if (parent.isLocal()) {
            SshIdentityStateManager.prepareLocalOpenSshAgent(parent, (FilePath)AppPrefs.get().defaultSshAgentSocket().getValue());
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
        builder.environment("SSH_AUTH_SOCK", sc -> {
            FilePath socket;
            if (sc.getOsType() == OsType.WINDOWS) {
                return null;
            }
            if (AppPrefs.get() != null && (socket = (FilePath)AppPrefs.get().defaultSshAgentSocket().getValue()) != null) {
                return socket.resolveTildeHome(sc.view().userHome()).toString();
            }
            return null;
        });
    }

    @Override
    public List<KeyValue> configOptions(ShellControl sc) throws Exception {
        Optional<FilePath> file = SshIdentityStrategy.getPublicKeyPath(sc, this.publicKey);
        return List.of(new KeyValue("IdentitiesOnly", file.isPresent() ? "yes" : "no"), new KeyValue("ForwardAgent", this.forwardAgent ? "yes" : "no"), new KeyValue("IdentityFile", file.isPresent() ? file.get().toString() : "none"), new KeyValue("PKCS11Provider", "none"));
    }

    @Generated
    OpenSshAgentStrategy(boolean forwardAgent, String publicKey) {
        this.forwardAgent = forwardAgent;
        this.publicKey = publicKey;
    }

    @Generated
    public static OpenSshAgentStrategyBuilder builder() {
        return new OpenSshAgentStrategyBuilder();
    }

    @Generated
    public boolean isForwardAgent() {
        return this.forwardAgent;
    }

    @Override
    @Generated
    public String getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSshAgentStrategy)) {
            return false;
        }
        OpenSshAgentStrategy other = (OpenSshAgentStrategy)o;
        if (this.isForwardAgent() != other.isForwardAgent()) {
            return false;
        }
        String this$publicKey = this.getPublicKey();
        String other$publicKey = other.getPublicKey();
        return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForwardAgent() ? 79 : 97);
        String $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpenSshAgentStrategy(forwardAgent=" + this.isForwardAgent() + ", publicKey=" + this.getPublicKey() + ")";
    }

    @JsonTypeName(value="sshAgent")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class OpenSshAgentStrategyBuilder {
        @Generated
        private boolean forwardAgent;
        @Generated
        private String publicKey;

        @Generated
        OpenSshAgentStrategyBuilder() {
        }

        @Generated
        public OpenSshAgentStrategyBuilder forwardAgent(boolean forwardAgent) {
            this.forwardAgent = forwardAgent;
            return this;
        }

        @Generated
        public OpenSshAgentStrategyBuilder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public OpenSshAgentStrategy build() {
            return new OpenSshAgentStrategy(this.forwardAgent, this.publicKey);
        }

        @Generated
        public String toString() {
            return "OpenSshAgentStrategy.OpenSshAgentStrategyBuilder(forwardAgent=" + this.forwardAgent + ", publicKey=" + this.publicKey + ")";
        }
    }
}

