/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity.ssh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.comp.Comp;
import io.xpipe.app.comp.base.ContextualFileReferenceChoiceComp;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.platform.OptionsBuilder;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FilePath;
import io.xpipe.core.KeyValue;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategyChoiceConfig;
import java.io.IOException;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

@JsonTypeName(value="customPkcs11")
@JsonDeserialize(builder=CustomPkcs11LibraryStrategyBuilder.class)
public final class CustomPkcs11LibraryStrategy
implements SshIdentityStrategy {
    private final FilePath file;

    public static String getOptionsNameKey() {
        return "customPkcs11Library";
    }

    public static OptionsBuilder createOptions(Property<CustomPkcs11LibraryStrategy> p, SshIdentityStrategyChoiceConfig config) {
        SimpleObjectProperty file = new SimpleObjectProperty(p.getValue() != null ? ((CustomPkcs11LibraryStrategy)p.getValue()).getFile() : null);
        return new OptionsBuilder().nameAndDescription("pkcs11Library").addComp((Comp)new ContextualFileReferenceChoiceComp((ObservableValue)(config.getFileSystem() != null ? config.getFileSystem() : new ReadOnlyObjectWrapper((Object)DataStorage.get().local().ref())), (Property)file, null, List.of(), e -> {
            if (config.getFileSystem() == null) {
                return e.equals((Object)DataStorage.get().local());
            }
            DataStoreEntryRef fs = (DataStoreEntryRef)config.getFileSystem().getValue();
            if (fs == null) {
                return e.equals((Object)DataStorage.get().local());
            }
            return e.equals((Object)fs.get());
        }, false), (Property)file).nonNull().bind(() -> new CustomPkcs11LibraryStrategy((FilePath)file.get()), new Property[]{p});
    }

    @Override
    public void checkComplete() throws ValidationException {
        Validators.nonNull((Object)this.file);
    }

    @Override
    public void prepareParent(ShellControl parent) throws Exception {
        parent.requireLicensedFeature(LicenseProvider.get().getFeature("pkcs11Identity"));
        if (!parent.getShellDialect().createFileExistsCommand(parent, this.file.toString()).executeAndCheck()) {
            throw (IOException)ErrorEventFactory.expected((Throwable)new IOException("PKCS11 library at " + String.valueOf(this.file) + " not found"));
        }
    }

    @Override
    public void buildCommand(CommandBuilder builder) {
        builder.setup(sc -> {
            FilePath dir = this.file.getParent();
            if (sc.getOsType() == OsType.WINDOWS) {
                builder.addToPath(dir, true);
            } else {
                builder.addToEnvironmentPath("LD_LIBRARY_PATH", dir, true);
            }
        });
    }

    @Override
    public List<KeyValue> configOptions(ShellControl sc) {
        return List.of(new KeyValue("IdentitiesOnly", "no"), new KeyValue("PKCS11Provider", "\"" + this.file.toString() + "\""), new KeyValue("IdentityFile", "none"), new KeyValue("IdentityAgent", "none"));
    }

    @Override
    public String getPublicKey() {
        return null;
    }

    @Generated
    public static CustomPkcs11LibraryStrategyBuilder builder() {
        return new CustomPkcs11LibraryStrategyBuilder();
    }

    @Generated
    public FilePath getFile() {
        return this.file;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomPkcs11LibraryStrategy)) {
            return false;
        }
        CustomPkcs11LibraryStrategy other = (CustomPkcs11LibraryStrategy)o;
        FilePath this$file = this.getFile();
        FilePath other$file = other.getFile();
        return !(this$file == null ? other$file != null : !this$file.equals(other$file));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilePath $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CustomPkcs11LibraryStrategy(file=" + String.valueOf(this.getFile()) + ")";
    }

    @Generated
    public CustomPkcs11LibraryStrategy(FilePath file) {
        this.file = file;
    }

    @JsonTypeName(value="customPkcs11")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class CustomPkcs11LibraryStrategyBuilder {
        @Generated
        private FilePath file;

        @Generated
        CustomPkcs11LibraryStrategyBuilder() {
        }

        @Generated
        public CustomPkcs11LibraryStrategyBuilder file(FilePath file) {
            this.file = file;
            return this;
        }

        @Generated
        public CustomPkcs11LibraryStrategy build() {
            return new CustomPkcs11LibraryStrategy(this.file);
        }

        @Generated
        public String toString() {
            return "CustomPkcs11LibraryStrategy.CustomPkcs11LibraryStrategyBuilder(file=" + String.valueOf(this.file) + ")";
        }
    }
}

