/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.UsernameStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import lombok.Generated;

@JsonTypeName(value="localIdentity")
@JsonDeserialize(builder=LocalIdentityStoreBuilderImpl.class)
public final class LocalIdentityStore
extends IdentityStore {
    private final String username;
    private final EncryptedValue<SecretRetrievalStrategy> password;
    private final EncryptedValue<SshIdentityStrategy> sshIdentity;

    @Override
    public UsernameStrategy.Fixed getUsername() {
        return new UsernameStrategy.Fixed(this.username);
    }

    @Override
    public SecretRetrievalStrategy getPassword() {
        return this.password != null ? (SecretRetrievalStrategy)this.password.getValue() : null;
    }

    @Override
    public SshIdentityStrategy getSshIdentity() {
        return this.sshIdentity != null ? (SshIdentityStrategy)this.sshIdentity.getValue() : null;
    }

    EncryptedValue<SecretRetrievalStrategy> getEncryptedPassword() {
        return this.password;
    }

    EncryptedValue<SshIdentityStrategy> getEncryptedSshIdentity() {
        return this.sshIdentity;
    }

    @Generated
    protected LocalIdentityStore(LocalIdentityStoreBuilder<?, ?> b) {
        super(b);
        this.username = b.username;
        this.password = b.password;
        this.sshIdentity = b.sshIdentity;
    }

    @Generated
    public static LocalIdentityStoreBuilder<?, ?> builder() {
        return new LocalIdentityStoreBuilderImpl();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalIdentityStore)) {
            return false;
        }
        LocalIdentityStore other = (LocalIdentityStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UsernameStrategy.Fixed this$username = this.getUsername();
        UsernameStrategy.Fixed other$username = other.getUsername();
        if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
            return false;
        }
        SecretRetrievalStrategy this$password = this.getPassword();
        SecretRetrievalStrategy other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        SshIdentityStrategy this$sshIdentity = this.getSshIdentity();
        SshIdentityStrategy other$sshIdentity = other.getSshIdentity();
        return !(this$sshIdentity == null ? other$sshIdentity != null : !this$sshIdentity.equals(other$sshIdentity));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocalIdentityStore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UsernameStrategy.Fixed $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        SecretRetrievalStrategy $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        SshIdentityStrategy $sshIdentity = this.getSshIdentity();
        result = result * 59 + ($sshIdentity == null ? 43 : $sshIdentity.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LocalIdentityStore(super=" + super.toString() + ", username=" + String.valueOf(this.getUsername()) + ", password=" + String.valueOf(this.getPassword()) + ", sshIdentity=" + String.valueOf(this.getSshIdentity()) + ")";
    }

    @Generated
    public static abstract class LocalIdentityStoreBuilder<C extends LocalIdentityStore, B extends LocalIdentityStoreBuilder<C, B>>
    extends IdentityStore.IdentityStoreBuilder<C, B> {
        @Generated
        private String username;
        @Generated
        private EncryptedValue<SecretRetrievalStrategy> password;
        @Generated
        private EncryptedValue<SshIdentityStrategy> sshIdentity;

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(EncryptedValue<SecretRetrievalStrategy> password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B sshIdentity(EncryptedValue<SshIdentityStrategy> sshIdentity) {
            this.sshIdentity = sshIdentity;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LocalIdentityStore.LocalIdentityStoreBuilder(super=" + super.toString() + ", username=" + this.username + ", password=" + String.valueOf(this.password) + ", sshIdentity=" + String.valueOf(this.sshIdentity) + ")";
        }
    }

    @JsonTypeName(value="localIdentity")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class LocalIdentityStoreBuilderImpl
    extends LocalIdentityStoreBuilder<LocalIdentityStore, LocalIdentityStoreBuilderImpl> {
        @Generated
        private LocalIdentityStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected LocalIdentityStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LocalIdentityStore build() {
            return new LocalIdentityStore(this);
        }
    }
}

