/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.action.AbstractAction;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.core.window.AppMainWindow;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.hub.action.HubLeafProvider;
import io.xpipe.app.hub.action.StoreAction;
import io.xpipe.app.hub.action.StoreActionCategory;
import io.xpipe.app.hub.comp.StoreCreationDialog;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.LocalIdentityStore;
import io.xpipe.ext.base.identity.SyncedIdentityStore;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import lombok.Generated;

public class LocalIdentityConvertHubLeafProvider
implements HubLeafProvider<LocalIdentityStore> {
    public StoreActionCategory getCategory() {
        return StoreActionCategory.CUSTOM;
    }

    public boolean isMajor() {
        return true;
    }

    public boolean isApplicable(DataStoreEntryRef<LocalIdentityStore> o) {
        return DataStorage.get().supportsSync();
    }

    public ObservableValue<String> getName(DataStoreEntryRef<LocalIdentityStore> store) {
        return AppI18n.observable((String)"sync", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon(DataStoreEntryRef<LocalIdentityStore> store) {
        return new LabelGraphic.IconGraphic("mdi2g-git");
    }

    public Class<?> getApplicableClass() {
        return LocalIdentityStore.class;
    }

    public AbstractAction createAction(DataStoreEntryRef<LocalIdentityStore> ref) {
        return ((Action.ActionBuilder)Action.builder().ref(ref)).build();
    }

    public String getId() {
        return "convertLocalIdentity";
    }

    @JsonDeserialize(builder=ActionBuilderImpl.class)
    public static class Action
    extends StoreAction<LocalIdentityStore> {
        public void executeImpl() {
            LocalIdentityStore st = (LocalIdentityStore)this.ref.getStore();
            IdentityStore synced = ((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)((SyncedIdentityStore.SyncedIdentityStoreBuilder)SyncedIdentityStore.builder().username(st.getUsername().get())).password((EncryptedValue.VaultKey<SecretRetrievalStrategy>)EncryptedValue.VaultKey.of((Object)st.getPassword()))).sshIdentity((EncryptedValue.VaultKey<SshIdentityStrategy>)EncryptedValue.VaultKey.of((Object)st.getSshIdentity()))).perUser(false)).build();
            StoreCreationDialog.showEdit((DataStoreEntry)this.ref.get(), (DataStore)synced, ignored -> {});
            Platform.runLater(() -> {
                Set found = AppMainWindow.get().getStage().getScene().getRoot().lookupAll(".git-sync-file-button");
                if (found.size() != 1) {
                    return;
                }
                Node first = (Node)found.iterator().next();
                if (first instanceof Button) {
                    Button b = (Button)first;
                    b.fire();
                }
            });
        }

        @Generated
        protected Action(ActionBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static ActionBuilder<?, ?> builder() {
            return new ActionBuilderImpl();
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class ActionBuilderImpl
        extends ActionBuilder<Action, ActionBuilderImpl> {
            @Generated
            private ActionBuilderImpl() {
            }

            @Override
            @Generated
            protected ActionBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Action build() {
                return new Action(this);
            }
        }

        @Generated
        public static abstract class ActionBuilder<C extends Action, B extends ActionBuilder<C, B>>
        extends StoreAction.StoreActionBuilder<LocalIdentityStore, C, B> {
            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "LocalIdentityConvertHubLeafProvider.Action.ActionBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

