/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.identity;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ValidationException;
import io.xpipe.app.secret.EncryptedValue;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreCategory;
import io.xpipe.app.storage.DataStoreCategoryConfig;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.identity.IdentityStore;
import io.xpipe.ext.base.identity.LocalIdentityStore;
import io.xpipe.ext.base.identity.ssh.NoIdentityStrategy;
import io.xpipe.ext.base.identity.ssh.SshIdentityStrategy;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=InPlace.class), @JsonSubTypes.Type(value=Ref.class)})
public interface IdentityValue {
    public static IdentityValue ofCategory(DataStoreCategory category) {
        DataStoreCategoryConfig effective = DataStorage.get().getEffectiveCategoryConfig(category);
        if (effective.getDefaultIdentityStore() == null) {
            return null;
        }
        Optional found = DataStorage.get().getStoreEntryIfPresent(effective.getDefaultIdentityStore());
        if (found.isEmpty() || !(((DataStoreEntry)found.get()).getStore() instanceof IdentityStore)) {
            return null;
        }
        return new Ref((DataStoreEntryRef<IdentityStore>)((DataStoreEntry)found.get()).ref());
    }

    public static IdentityValue ofBreakout(DataStoreEntry e) {
        DataStorage s = DataStorage.get();
        if (s == null) {
            return null;
        }
        DataStoreCategory cat = s.getStoreCategory(e);
        UUID uuid = cat.getConfig().getDefaultIdentityStore();
        Optional found = s.getStoreEntryIfPresent(uuid);
        if (found.isEmpty() || !(((DataStoreEntry)found.get()).getStore() instanceof IdentityStore)) {
            return null;
        }
        return new Ref((DataStoreEntryRef<IdentityStore>)((DataStoreEntry)found.get()).ref());
    }

    public static InPlace of(LocalIdentityStore identityStore) {
        return new InPlace(identityStore);
    }

    public static InPlace none() {
        IdentityStore s = ((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().password((EncryptedValue<SecretRetrievalStrategy>)EncryptedValue.of((Object)new SecretNoneStrategy()))).sshIdentity((EncryptedValue<SshIdentityStrategy>)EncryptedValue.of((Object)new NoIdentityStrategy()))).build();
        return IdentityValue.of((LocalIdentityStore)s);
    }

    public static InPlace of(String user) {
        return IdentityValue.of(user, null, null);
    }

    public static InPlace of(String user, SecretRetrievalStrategy password) {
        return IdentityValue.of(user, password, null);
    }

    public static InPlace of(String user, SecretRetrievalStrategy password, SshIdentityStrategy sshIdentity) {
        IdentityStore s = ((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)((LocalIdentityStore.LocalIdentityStoreBuilder)LocalIdentityStore.builder().username(user)).password((EncryptedValue<SecretRetrievalStrategy>)(password != null ? EncryptedValue.of((Object)password) : null))).sshIdentity((EncryptedValue<SshIdentityStrategy>)(sshIdentity != null ? EncryptedValue.of((Object)sshIdentity) : null))).build();
        return IdentityValue.of((LocalIdentityStore)s);
    }

    public void checkComplete() throws Throwable;

    public IdentityStore unwrap();

    public boolean isPerUser();

    default public void checkCompleteUser() throws ValidationException {
        Validators.nonNull((Object)(this.unwrap().getUsername().hasUser() ? new Object() : null), (String)"Identity username");
    }

    default public void checkCompletePassword() throws ValidationException {
        Validators.nonNull((Object)this.unwrap().getPassword(), (String)"Identity password");
        this.unwrap().getPassword().checkComplete();
    }

    default public void checkCompleteSshIdentity() throws ValidationException {
        Validators.nonNull((Object)this.unwrap().getSshIdentity(), (String)"Identity ssh key");
        this.unwrap().getSshIdentity().checkComplete();
    }

    @JsonTypeName(value="ref")
    @JsonDeserialize(builder=RefBuilder.class)
    public static final class Ref
    implements IdentityValue {
        private final DataStoreEntryRef<IdentityStore> ref;

        @Override
        public void checkComplete() throws Throwable {
            Validators.nonNull(this.ref);
            Validators.isType(this.ref, IdentityStore.class);
        }

        @Override
        public IdentityStore unwrap() {
            return this.ref != null && this.ref.getStore() != null ? (IdentityStore)this.ref.getStore() : LocalIdentityStore.builder().build();
        }

        @Override
        public boolean isPerUser() {
            return this.ref != null && this.ref.get().isPerUserStore();
        }

        @Generated
        Ref(DataStoreEntryRef<IdentityStore> ref) {
            this.ref = ref;
        }

        @Generated
        public static RefBuilder builder() {
            return new RefBuilder();
        }

        @Generated
        public DataStoreEntryRef<IdentityStore> getRef() {
            return this.ref;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ref)) {
                return false;
            }
            Ref other = (Ref)o;
            DataStoreEntryRef<IdentityStore> this$ref = this.getRef();
            DataStoreEntryRef<IdentityStore> other$ref = other.getRef();
            return !(this$ref == null ? other$ref != null : !this$ref.equals(other$ref));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DataStoreEntryRef<IdentityStore> $ref = this.getRef();
            result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IdentityValue.Ref(ref=" + String.valueOf(this.getRef()) + ")";
        }

        @JsonTypeName(value="ref")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class RefBuilder {
            @Generated
            private DataStoreEntryRef<IdentityStore> ref;

            @Generated
            RefBuilder() {
            }

            @Generated
            public RefBuilder ref(DataStoreEntryRef<IdentityStore> ref) {
                this.ref = ref;
                return this;
            }

            @Generated
            public Ref build() {
                return new Ref(this.ref);
            }

            @Generated
            public String toString() {
                return "IdentityValue.Ref.RefBuilder(ref=" + String.valueOf(this.ref) + ")";
            }
        }
    }

    @JsonTypeName(value="inPlace")
    @JsonDeserialize(builder=InPlaceBuilder.class)
    public static final class InPlace
    implements IdentityValue {
        private final LocalIdentityStore identityStore;

        @Override
        public void checkComplete() throws Throwable {
            Validators.nonNull((Object)this.identityStore);
        }

        @Override
        public LocalIdentityStore unwrap() {
            return this.identityStore != null ? this.identityStore : LocalIdentityStore.builder().build();
        }

        @Override
        public boolean isPerUser() {
            return false;
        }

        @Generated
        InPlace(LocalIdentityStore identityStore) {
            this.identityStore = identityStore;
        }

        @Generated
        public static InPlaceBuilder builder() {
            return new InPlaceBuilder();
        }

        @Generated
        public LocalIdentityStore getIdentityStore() {
            return this.identityStore;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InPlace)) {
                return false;
            }
            InPlace other = (InPlace)o;
            LocalIdentityStore this$identityStore = this.getIdentityStore();
            LocalIdentityStore other$identityStore = other.getIdentityStore();
            return !(this$identityStore == null ? other$identityStore != null : !((Object)this$identityStore).equals(other$identityStore));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalIdentityStore $identityStore = this.getIdentityStore();
            result = result * 59 + ($identityStore == null ? 43 : ((Object)$identityStore).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IdentityValue.InPlace(identityStore=" + String.valueOf(this.getIdentityStore()) + ")";
        }

        @JsonTypeName(value="inPlace")
        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class InPlaceBuilder {
            @Generated
            private LocalIdentityStore identityStore;

            @Generated
            InPlaceBuilder() {
            }

            @Generated
            public InPlaceBuilder identityStore(LocalIdentityStore identityStore) {
                this.identityStore = identityStore;
                return this;
            }

            @Generated
            public InPlace build() {
                return new InPlace(this.identityStore);
            }

            @Generated
            public String toString() {
                return "IdentityValue.InPlace.InPlaceBuilder(identityStore=" + String.valueOf(this.identityStore) + ")";
            }
        }
    }
}

