/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.host;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.HostAddress;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.host.HostAddressGatewayStore;
import io.xpipe.ext.base.host.HostAddressStore;
import lombok.Generated;

@JsonTypeName(value="abstractHost")
@JsonDeserialize(builder=AbstractHostStoreBuilderImpl.class)
public final class AbstractHostStore
implements DataStore,
HostAddressStore,
HostAddressGatewayStore {
    private final String host;
    private final DataStoreEntryRef<NetworkTunnelStore> gateway;

    public void checkComplete() throws Throwable {
        Validators.nonNull((Object)this.host);
    }

    @Override
    public HostAddress getHostAddress() {
        return HostAddress.of((String)this.host);
    }

    @Override
    public DataStoreEntryRef<NetworkTunnelStore> getTunnelGateway() {
        return this.gateway;
    }

    @Generated
    protected AbstractHostStore(AbstractHostStoreBuilder<?, ?> b) {
        this.host = b.host;
        this.gateway = b.gateway;
    }

    @Generated
    public static AbstractHostStoreBuilder<?, ?> builder() {
        return new AbstractHostStoreBuilderImpl();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public DataStoreEntryRef<NetworkTunnelStore> getGateway() {
        return this.gateway;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHostStore)) {
            return false;
        }
        AbstractHostStore other = (AbstractHostStore)o;
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        DataStoreEntryRef<NetworkTunnelStore> this$gateway = this.getGateway();
        DataStoreEntryRef<NetworkTunnelStore> other$gateway = other.getGateway();
        return !(this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        DataStoreEntryRef<NetworkTunnelStore> $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractHostStore(super=" + super.toString() + ", host=" + this.getHost() + ", gateway=" + String.valueOf(this.getGateway()) + ")";
    }

    @Generated
    public static abstract class AbstractHostStoreBuilder<C extends AbstractHostStore, B extends AbstractHostStoreBuilder<C, B>> {
        @Generated
        private String host;
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> gateway;

        @Generated
        public B host(String host) {
            this.host = host;
            return this.self();
        }

        @Generated
        public B gateway(DataStoreEntryRef<NetworkTunnelStore> gateway) {
            this.gateway = gateway;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractHostStore.AbstractHostStoreBuilder(host=" + this.host + ", gateway=" + String.valueOf(this.gateway) + ")";
        }
    }

    @JsonTypeName(value="abstractHost")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AbstractHostStoreBuilderImpl
    extends AbstractHostStoreBuilder<AbstractHostStore, AbstractHostStoreBuilderImpl> {
        @Generated
        private AbstractHostStoreBuilderImpl() {
        }

        @Override
        @Generated
        protected AbstractHostStoreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AbstractHostStore build() {
            return new AbstractHostStore(this);
        }
    }
}

