/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.virsh;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.ThreadHelper;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableFunction;
import io.xpipe.core.JacksonMapper;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.store.PauseableStore;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import io.xpipe.ext.proc.ssh.t;
import io.xpipe.ext.proc.virsh.a;
import io.xpipe.ext.proc.virsh.h;
import io.xpipe.ext.proc.virsh.j;
import io.xpipe.ext.proc.vm.e;
import io.xpipe.ext.proc.vm.h;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import lombok.Generated;

@JsonTypeName(value="virshDomain")
@JsonDeserialize(builder=b.class)
public final class d
extends e<io.xpipe.ext.proc.vm.h>
implements FixedChildStore,
NameableStore,
PauseableStore,
StartableStore,
StoppableStore {
    private final DataStoreEntryRef<h> hypervisor;
    private final String name;

    @Override
    public final void checkComplete() {
        super.checkComplete();
        Validators.nonNull(this.hypervisor);
        Validators.isType(this.hypervisor, h.class);
        this.hypervisor.checkComplete();
        Validators.nonNull((Object)this.name);
        Validators.notEmpty((String)this.name);
    }

    @Override
    public final DataStoreEntryRef<ShellStore> getHypervisorHost() {
        if (this.hypervisor != null) {
            return ((j)((h)this.hypervisor.getStore()).getInstall().getStore()).getHost();
        }
        return null;
    }

    @Override
    public final FailableFunction<CommandBuilder, Boolean, Exception> guestExecPredicate(ShellControl shellControl) {
        return object -> {
            object = object.buildBaseParts(shellControl);
            ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
            objectNode.put("path", (String)object.getFirst());
            objectNode.putArray("arg").addAll(object.subList(1, object.size()).stream().map(string -> {
                if (string.startsWith("'") && string.endsWith("'")) {
                    return string.substring(1, string.length() - 1);
                }
                return string;
            }).map(string -> JsonNodeFactory.instance.textNode(string)).toList());
            object = JsonNodeFactory.instance.objectNode();
            object.put("execute", "guest-exec");
            object.set("arguments", (JsonNode)objectNode);
            object = CommandBuilder.of().add(new String[]{"virsh", "-c"}).addQuoted(((h)this.getHypervisor().getStore()).getUri()).add(new String[]{"qemu-agent-command"}).addQuoted(this.getName()).addLiteral(object.toString());
            object = shellControl.command((CommandBuilder)object).readStdoutIfPossible();
            if (((Optional)object).isEmpty()) {
                return Boolean.FALSE;
            }
            if (((OptionalInt)(object = this.readPid((String)((Optional)object).get()))).isEmpty()) {
                return Boolean.FALSE;
            }
            for (int i2 = 0; i2 < 20; ++i2) {
                OptionalInt optionalInt = this.readExit(shellControl, ((OptionalInt)object).getAsInt());
                if (!optionalInt.isEmpty()) {
                    return optionalInt.getAsInt() == 0;
                }
                ThreadHelper.sleep((long)500L);
            }
            return Boolean.FALSE;
        };
    }

    @Override
    public final Class<io.xpipe.ext.proc.vm.h> getStateClass() {
        return io.xpipe.ext.proc.vm.h.class;
    }

    @Override
    public final void prepareGuestShell(ShellControl shellControl) {
        shellControl.requireLicensedFeature(LicenseProvider.get().getFeature("libvirt"));
    }

    @Override
    public final void updateGuestState(ShellControl shellControl) {
        Object object = ((h)this.getHypervisor().getStore()).commandView();
        this.refreshVmState((a.a)((Object)object));
        if (!((io.xpipe.ext.proc.vm.h)this.getState()).getRunning().booleanValue()) {
            return;
        }
        h.a<?, ?> a2 = ((io.xpipe.ext.proc.vm.h)this.getState()).toBuilder();
        if (this.getCustomIp() == null || !this.getCustomIp().use()) {
            if (((Optional)(object = ((a.a)((Object)object)).bq(this.name))).isEmpty()) {
                this.setState(((h.a)((Object)((h.a)((Object)a2.ip(null))).reachable(Boolean.FALSE))).build());
                throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Unable to determine external IP address for vm " + this.name + "\n\nIs the VM fully started up, has the network interface initialized, and is the QEMU guest agent running on the guest? For more information see https://wiki.libvirt.org/Qemu_guest_agent.html"));
            }
            a2.ip((String)((Optional)object).get());
            this.setState(a2.build());
        }
        boolean bl = t.isReachable(shellControl, this.getEffectiveIp(), this.getPort() != null ? this.getPort() : 22);
        a2.reachable(bl);
        if (!bl) {
            OsType.Any any = this.guestExecPredicate(shellControl);
            any = io.xpipe.ext.proc.util.e.a(any);
            a2.reachable(io.xpipe.ext.proc.vm.d.a(this, shellControl, any));
        }
        this.setState(a2.build());
    }

    private OptionalInt readPid(String string) {
        string = JacksonMapper.getDefault().readTree(string);
        if (!string.isObject()) {
            return OptionalInt.empty();
        }
        if (!(string = string.required("return")).has("pid")) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(string.get("pid").asInt());
    }

    private OptionalInt readExit(ShellControl object, int n2) {
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        objectNode.put("pid", n2);
        ObjectNode objectNode2 = JsonNodeFactory.instance.objectNode();
        objectNode2.put("execute", "guest-exec-status");
        objectNode2.set("arguments", (JsonNode)objectNode);
        objectNode2 = CommandBuilder.of().add(new String[]{"virsh", "-c"}).addQuoted(((h)this.getHypervisor().getStore()).getUri()).add(new String[]{"qemu-agent-command"}).addQuoted(this.getName()).addLiteral(objectNode2.toString());
        object = object.command((CommandBuilder)objectNode2).readStdoutIfPossible();
        if (((Optional)object).isEmpty()) {
            return OptionalInt.empty();
        }
        object = JacksonMapper.getDefault().readTree((String)((Optional)object).get());
        if (!object.isObject()) {
            return OptionalInt.empty();
        }
        if (!(object = object.required("return")).has("exitcode")) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(object.get("exitcode").asInt());
    }

    private void refreshVmState(a.a object) {
        Object object2 = (io.xpipe.ext.proc.vm.h)this.getState();
        object2 = ((io.xpipe.ext.proc.vm.h)((Object)object2)).toBuilder();
        object = object.br(this.name);
        ((h.a)((Object)object2)).stateString((String)object);
        boolean bl = "running".equals(object);
        ((h.a)((Object)object2)).running(bl);
        this.setState(((h.a)((Object)object2)).build());
    }

    public final void start() {
        LicenseProvider.get().getFeature("libvirt").throwIfUnsupported();
        a.a a2 = ((h)this.getHypervisor().getStore()).commandView();
        a2.f(this.name);
        this.refreshVmState(a2);
    }

    public final void stop() {
        LicenseProvider.get().getFeature("libvirt").throwIfUnsupported();
        a.a a2 = ((h)this.getHypervisor().getStore()).commandView();
        a2.g(this.name);
        this.refreshVmState(a2);
    }

    public final void pause() {
        LicenseProvider.get().getFeature("libvirt").throwIfUnsupported();
        a.a a2 = ((h)this.getHypervisor().getStore()).commandView();
        a2.P(this.name);
        this.refreshVmState(a2);
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(Objects.hash(this.name));
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (d)fixedChildStore;
        return ((a)this.toBuilder().identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    @Generated
    protected d(a<?, ?> a2) {
        super(a2);
        this.hypervisor = a2.hypervisor;
        this.name = a2.name;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<h> getHypervisor() {
        return this.hypervisor;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof d)) {
            return false;
        }
        Object object2 = (d)object;
        if (!((d)object2).canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getHypervisor();
        DataStoreEntryRef<h> dataStoreEntryRef = ((d)object2).getHypervisor();
        if (object == null ? dataStoreEntryRef != null : !object.equals(dataStoreEntryRef)) {
            return false;
        }
        object = this.getName();
        object2 = ((d)object2).getName();
        return !(object == null ? object2 != null : !object.equals(object2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof d;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getHypervisor();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getName();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "VirshDomainStore(super=" + super.toString() + ", hypervisor=" + String.valueOf(this.getHypervisor()) + ", name=" + this.getName() + ")";
    }

    @Generated
    public static abstract class a<C extends d, B extends a<C, B>>
    extends e.a<io.xpipe.ext.proc.vm.h, C, B> {
        @Generated
        private DataStoreEntryRef<h> hypervisor;
        @Generated
        private String name;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(d d2, a<?, ?> a2) {
            a2.hypervisor(d2.hypervisor);
            a2.name(d2.name);
        }

        @Generated
        public B hypervisor(DataStoreEntryRef<h> dataStoreEntryRef) {
            this.hypervisor = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B name(String string) {
            this.name = string;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "VirshDomainStore.VirshDomainStoreBuilder(super=" + super.toString() + ", hypervisor=" + String.valueOf(this.hypervisor) + ", name=" + this.name + ")";
        }
    }

    @JsonTypeName(value="virshDomain")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<d, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final d build() {
            return new d(this);
        }
    }
}

