/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.rdp;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.NetworkTunnelSession;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SingletonSessionStore;
import io.xpipe.app.ext.UserScopeStore;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.HostHelper;
import io.xpipe.app.util.RdpConfig;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.desktop.DesktopBaseStore;
import io.xpipe.ext.base.host.AbstractHostStore;
import io.xpipe.ext.base.host.AbstractHostTransformStore;
import io.xpipe.ext.base.host.HostAddressGatewayStore;
import io.xpipe.ext.base.host.HostAddressStore;
import io.xpipe.ext.base.identity.IdentityValue;
import io.xpipe.ext.proc.rdp.a;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

@JsonTypeName(value="rdpSimple")
@JsonDeserialize(builder=b.class)
public final class b
extends io.xpipe.ext.proc.rdp.a
implements SingletonSessionStore<NetworkTunnelSession>,
UserScopeStore,
DesktopBaseStore,
AbstractHostTransformStore {
    private final DataStoreEntryRef<HostAddressStore> associatedHost;
    private final String host;
    private final DataStoreEntryRef<NetworkTunnelStore> gateway;
    private final Integer port;
    private final String domain;
    private final String additionalOptions;
    private final IdentityValue identity;

    public final NetworkTunnelSession newSession() {
        DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef = this.getGateway();
        if (dataStoreEntryRef == null) {
            return null;
        }
        int n2 = HostHelper.findRandomOpenPortOnAllLocalInterfaces();
        return ((NetworkTunnelStore)dataStoreEntryRef.getStore()).createTunnelSession(n2, this.port.intValue(), this.getEffectiveHost());
    }

    public final Class<?> getSessionClass() {
        return NetworkTunnelSession.class;
    }

    public final String getEffectiveHost() {
        NetworkTunnelSession networkTunnelSession = (NetworkTunnelSession)this.getSession();
        if (networkTunnelSession != null) {
            return "localhost";
        }
        if (this.associatedHost != null) {
            return ((HostAddressStore)this.associatedHost.getStore()).getHostAddress().get();
        }
        return this.host;
    }

    public final int getEffectivePort() {
        NetworkTunnelSession networkTunnelSession = (NetworkTunnelSession)this.getSession();
        if (networkTunnelSession != null) {
            return networkTunnelSession.getLocalPort();
        }
        return this.port;
    }

    public final boolean isPerUser() {
        return this.identity != null && this.identity.isPerUser();
    }

    public final DataStoreEntryRef<NetworkTunnelStore> getGateway() {
        DataStore dataStore;
        if (this.associatedHost != null && (dataStore = this.associatedHost.getStore()) instanceof HostAddressGatewayStore && (dataStore = (HostAddressGatewayStore)dataStore).getTunnelGateway() != null) {
            return dataStore.getTunnelGateway();
        }
        return this.gateway;
    }

    public final void checkComplete() {
        if (this.associatedHost != null) {
            this.associatedHost.checkComplete();
        } else {
            Validators.nonNull((Object)this.host);
        }
        Validators.nonNull((Object)this.port);
        Validators.nonNull((Object)this.identity);
        this.identity.checkComplete();
        this.identity.checkCompleteUser();
        this.identity.checkCompletePassword();
        RdpConfig.parseContent((String)this.additionalOptions);
        if (this.gateway != null) {
            this.gateway.checkComplete();
        }
    }

    @Override
    protected final SecretRetrievalStrategy getPassword() {
        if (this.identity != null) {
            return this.identity.unwrap().getPassword();
        }
        return null;
    }

    @Override
    protected final RdpConfig retrieveConfig() {
        String string = this.getEffectiveHost() + ":" + this.getEffectivePort();
        Object object = RdpConfig.parseContent((String)this.additionalOptions);
        object = new LinkedHashMap<String, RdpConfig.TypedValue>(object.getContent());
        ((LinkedHashMap)object).putFirst("full address", new RdpConfig.TypedValue("s", string));
        ((LinkedHashMap)object).putFirst("username", new RdpConfig.TypedValue("s", this.identity.unwrap().getUsername().retrieveUsername()));
        return new RdpConfig((Map)object);
    }

    @Override
    protected final String getDisplayName() {
        return this.getSelfEntry().getName();
    }

    public final boolean supportsDesktopAccess() {
        return true;
    }

    public final boolean canConvertToAbstractHost() {
        return this.associatedHost == null;
    }

    public final AbstractHostStore createAbstractHostStore() {
        return AbstractHostStore.builder().host(this.host).gateway(this.gateway).build();
    }

    public final AbstractHostTransformStore withNewParent(DataStoreEntryRef<AbstractHostStore> dataStoreEntryRef) {
        return ((a)((a)((a)this.toBuilder().host(null)).gateway(null)).associatedHost((DataStoreEntryRef<HostAddressStore>)dataStoreEntryRef.asNeeded())).build();
    }

    @Generated
    protected b(a<?, ?> a2) {
        super(a2);
        this.associatedHost = a2.associatedHost;
        this.host = a2.host;
        this.gateway = a2.gateway;
        this.port = a2.port;
        this.domain = a2.domain;
        this.additionalOptions = a2.additionalOptions;
        this.identity = a2.identity;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<HostAddressStore> getAssociatedHost() {
        return this.associatedHost;
    }

    @Generated
    public final String getHost() {
        return this.host;
    }

    @Generated
    public final Integer getPort() {
        return this.port;
    }

    @Generated
    public final String getDomain() {
        return this.domain;
    }

    @Generated
    public final String getAdditionalOptions() {
        return this.additionalOptions;
    }

    @Generated
    public final IdentityValue getIdentity() {
        return this.identity;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof b)) {
            return false;
        }
        b b2 = (b)object;
        if (!b2.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getPort();
        Object object2 = b2.getPort();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getAssociatedHost();
        object2 = b2.getAssociatedHost();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getHost();
        object2 = b2.getHost();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getGateway();
        object2 = b2.getGateway();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getDomain();
        object2 = b2.getDomain();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getAdditionalOptions();
        object2 = b2.getAdditionalOptions();
        if (object == null ? object2 != null : !object.equals(object2)) {
            return false;
        }
        object = this.getIdentity();
        b2 = b2.getIdentity();
        return !(object == null ? b2 != null : !object.equals(b2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof b;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getPort();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAssociatedHost();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getHost();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getGateway();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getDomain();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getAdditionalOptions();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getIdentity();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "RdpDirectStore(super=" + super.toString() + ", associatedHost=" + String.valueOf(this.getAssociatedHost()) + ", host=" + this.getHost() + ", gateway=" + String.valueOf(this.getGateway()) + ", port=" + this.getPort() + ", domain=" + this.getDomain() + ", additionalOptions=" + this.getAdditionalOptions() + ", identity=" + String.valueOf(this.getIdentity()) + ")";
    }

    @Generated
    public static abstract class a<C extends b, B extends a<C, B>>
    extends a.a<C, B> {
        @Generated
        private DataStoreEntryRef<HostAddressStore> associatedHost;
        @Generated
        private String host;
        @Generated
        private DataStoreEntryRef<NetworkTunnelStore> gateway;
        @Generated
        private Integer port;
        @Generated
        private String domain;
        @Generated
        private String additionalOptions;
        @Generated
        private IdentityValue identity;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(b b2, a<?, ?> a2) {
            a2.associatedHost(b2.associatedHost);
            a2.host(b2.host);
            a2.gateway(b2.gateway);
            a2.port(b2.port);
            a2.domain(b2.domain);
            a2.additionalOptions(b2.additionalOptions);
            a2.identity(b2.identity);
        }

        @Generated
        public B associatedHost(DataStoreEntryRef<HostAddressStore> dataStoreEntryRef) {
            this.associatedHost = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B host(String string) {
            this.host = string;
            return (B)this.self();
        }

        @Generated
        public B gateway(DataStoreEntryRef<NetworkTunnelStore> dataStoreEntryRef) {
            this.gateway = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B port(Integer n2) {
            this.port = n2;
            return (B)this.self();
        }

        @Generated
        public B domain(String string) {
            this.domain = string;
            return (B)this.self();
        }

        @Generated
        public B additionalOptions(String string) {
            this.additionalOptions = string;
            return (B)this.self();
        }

        @Generated
        public B identity(IdentityValue identityValue) {
            this.identity = identityValue;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RdpDirectStore.RdpDirectStoreBuilder(super=" + super.toString() + ", associatedHost=" + String.valueOf(this.associatedHost) + ", host=" + this.host + ", gateway=" + String.valueOf(this.gateway) + ", port=" + this.port + ", domain=" + this.domain + ", additionalOptions=" + this.additionalOptions + ", identity=" + String.valueOf(this.identity) + ")";
        }
    }

    @JsonTypeName(value="rdpSimple")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<b, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final b build() {
            return new b(this);
        }
    }
}

