/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.proxmox;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.ext.DataStoreState;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.FixedHierarchyStore;
import io.xpipe.app.ext.NetworkTunnelStore;
import io.xpipe.app.ext.SelfReferentialStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.ext.StatefulDataStore;
import io.xpipe.app.process.CommandSupport;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.storage.DataStorage;
import io.xpipe.app.storage.DataStoreEntry;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.LicensedFeature;
import io.xpipe.app.util.Validators;
import io.xpipe.ext.base.service.AbstractServiceStore;
import io.xpipe.ext.base.service.FixedServiceCreatorStore;
import io.xpipe.ext.base.service.FixedServiceStore;
import io.xpipe.ext.base.service.ServiceProtocolType;
import io.xpipe.ext.proc.proxmox.f;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@JsonTypeName(value="proxmox")
@JsonDeserialize(builder=b.class)
public final class h
implements FixedHierarchyStore,
SelfReferentialStore,
StatefulDataStore<c>,
FixedServiceCreatorStore {
    private final DataStoreEntryRef<ShellStore> host;

    public final boolean allowManualServicesRefresh() {
        return false;
    }

    public final List<? extends DataStoreEntryRef<? extends AbstractServiceStore>> createFixedServices() {
        ArrayList<DataStoreEntryRef> arrayList = new ArrayList<DataStoreEntryRef>();
        if (this.host.getStore() instanceof NetworkTunnelStore) {
            FixedServiceStore fixedServiceStore = ((FixedServiceStore.FixedServiceStoreBuilder)((FixedServiceStore.FixedServiceStoreBuilder)FixedServiceStore.builder().remotePort(Integer.valueOf(8006))).host(this.host.asNeeded()).displayParent(this.getSelfEntry().ref()).serviceProtocolType((ServiceProtocolType)ServiceProtocolType.Https.builder().build())).build();
            arrayList.add(DataStoreEntry.createNew((String)"PVE dashboard", (DataStore)fixedServiceStore).ref());
            if (((ShellStore)this.getHost().getStore()).getOrStartSession().view().findProgram("proxmox-backup-manager").isPresent()) {
                fixedServiceStore = ((FixedServiceStore.FixedServiceStoreBuilder)((FixedServiceStore.FixedServiceStoreBuilder)FixedServiceStore.builder().remotePort(Integer.valueOf(8007))).host(this.host.asNeeded()).displayParent(this.getSelfEntry().ref()).serviceProtocolType((ServiceProtocolType)ServiceProtocolType.Https.builder().build())).build();
                arrayList.add(DataStoreEntry.createNew((String)"PBS dashboard", (DataStore)fixedServiceStore).ref());
            }
        }
        return arrayList;
    }

    public final Optional<LicensedFeature> checkLicenseRequirement() {
        List<DataStore> list;
        if (((c)this.getState()).isEnterprise()) {
            LicensedFeature licensedFeature = LicenseProvider.get().getFeature("proxmoxEnterprise");
            return Optional.of(licensedFeature);
        }
        LicensedFeature licensedFeature = LicenseProvider.get().getFeature("proxmox");
        if (!licensedFeature.isSupported() && (list = DataStorage.get().getStoreEntries().stream().filter(dataStoreEntry -> dataStoreEntry.getValidity().isUsable()).filter(dataStoreEntry2 -> dataStoreEntry2.getStore() instanceof h && DataStorage.get().getStoreChildren(dataStoreEntry2).stream().anyMatch(dataStoreEntry -> dataStoreEntry.getStore() instanceof ShellStore)).sorted(Comparator.comparing(dataStoreEntry -> dataStoreEntry.getStorageCreationDate())).map(dataStoreEntry -> dataStoreEntry.getStore()).toList()).indexOf(this) > 0) {
            return Optional.of(licensedFeature);
        }
        return Optional.empty();
    }

    public final void checkLicenseOrThrow() {
        Optional<LicensedFeature> optional = this.checkLicenseRequirement();
        if (optional.isPresent()) {
            optional.get().throwIfUnsupported();
        }
    }

    public final void checkComplete() {
        Validators.nonNull(this.host);
        Validators.isType(this.host, ShellStore.class);
        this.host.checkComplete();
    }

    public final List<? extends DataStoreEntryRef<? extends FixedChildStore>> listChildren() {
        ShellControl shellControl = ((ShellStore)this.getHost().getStore()).getOrStartSession();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        shellControl = shellControl.elevateIfNeeded(f.cd()).start();
        try {
            CommandSupport.isSupported(() -> f.D(shellControl), (String)"Proxmox pct and qm", (DataStoreEntry)this.host.get());
            String string = f.queryVersion(shellControl);
            boolean bl = f.E(shellControl);
            h h2 = this;
            h2.setState(((c.a)((Object)((c.a)((Object)((c)h2.getState()).toBuilder().pveVersion(string))).enterprise(bl))).build());
            arrayList.addAll(f.a((DataStoreEntryRef<h>)this.getSelfEntry().ref(), shellControl));
            arrayList.addAll(f.b((DataStoreEntryRef<h>)this.getSelfEntry().ref(), shellControl));
        }
        finally {
            if (shellControl != null) {
                shellControl.close();
            }
        }
        return arrayList;
    }

    @Generated
    protected h(a<?, ?> a2) {
        this.host = a2.host;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final DataStoreEntryRef<ShellStore> getHost() {
        return this.host;
    }

    @Generated
    public final boolean equals(Object dataStoreEntryRef) {
        if (dataStoreEntryRef == this) {
            return true;
        }
        if (!(dataStoreEntryRef instanceof h)) {
            return false;
        }
        dataStoreEntryRef = (h)dataStoreEntryRef;
        DataStoreEntryRef<ShellStore> dataStoreEntryRef2 = this.getHost();
        dataStoreEntryRef = dataStoreEntryRef.getHost();
        return !(dataStoreEntryRef2 == null ? dataStoreEntryRef != null : !dataStoreEntryRef2.equals(dataStoreEntryRef));
    }

    @Generated
    public final int hashCode() {
        DataStoreEntryRef<ShellStore> dataStoreEntryRef = this.getHost();
        int n2 = 59 + (dataStoreEntryRef == null ? 43 : dataStoreEntryRef.hashCode());
        return n2;
    }

    @Generated
    public final String toString() {
        return "ProxmoxStore(host=" + String.valueOf(this.getHost()) + ")";
    }

    @JsonDeserialize(builder=b.class)
    public static final class c
    extends DataStoreState {
        private final String pveVersion;
        private final boolean enterprise;
        private final boolean showNonRunning;

        @Generated
        protected c(a<?, ?> a2) {
            super(a2);
            this.pveVersion = a2.pveVersion;
            this.enterprise = a2.enterprise;
            this.showNonRunning = a2.showNonRunning;
        }

        @Generated
        public static a<?, ?> builder() {
            return new b();
        }

        @Generated
        public final a<?, ?> toBuilder() {
            return new b().$fillValuesFrom(this);
        }

        @Generated
        public final String getPveVersion() {
            return this.pveVersion;
        }

        @Generated
        public final boolean isEnterprise() {
            return this.enterprise;
        }

        @Generated
        public final boolean isShowNonRunning() {
            return this.showNonRunning;
        }

        @Generated
        public final String toString() {
            return "ProxmoxStore.State(pveVersion=" + this.getPveVersion() + ", enterprise=" + this.isEnterprise() + ", showNonRunning=" + this.isShowNonRunning() + ")";
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof c)) {
                return false;
            }
            Object object2 = (c)((Object)object);
            if (!object2.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.isEnterprise() != object2.isEnterprise()) {
                return false;
            }
            if (this.isShowNonRunning() != object2.isShowNonRunning()) {
                return false;
            }
            object = this.getPveVersion();
            object2 = object2.getPveVersion();
            return !(object == null ? object2 != null : !object.equals(object2));
        }

        @Generated
        protected final boolean canEqual(Object object) {
            return object instanceof c;
        }

        @Generated
        public final int hashCode() {
            int n2 = super.hashCode();
            n2 = n2 * 59 + (this.isEnterprise() ? 79 : 97);
            n2 = n2 * 59 + (this.isShowNonRunning() ? 79 : 97);
            String string = this.getPveVersion();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        @Generated
        public static abstract class a<C extends c, B extends a<C, B>>
        extends DataStoreState.DataStoreStateBuilder<C, B> {
            @Generated
            private String pveVersion;
            @Generated
            private boolean enterprise;
            @Generated
            private boolean showNonRunning;

            @Generated
            protected B $fillValuesFrom(C c2) {
                super.$fillValuesFrom(c2);
                a.$fillValuesFromInstanceIntoBuilder(c2, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(c c2, a<?, ?> a2) {
                a2.pveVersion(c2.pveVersion);
                a2.enterprise(c2.enterprise);
                a2.showNonRunning(c2.showNonRunning);
            }

            @Generated
            public B pveVersion(String string) {
                this.pveVersion = string;
                return (B)this.self();
            }

            @Generated
            public B enterprise(boolean bl) {
                this.enterprise = bl;
                return (B)this.self();
            }

            @Generated
            public B showNonRunning(boolean bl) {
                this.showNonRunning = bl;
                return (B)this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "ProxmoxStore.State.StateBuilder(super=" + super.toString() + ", pveVersion=" + this.pveVersion + ", enterprise=" + this.enterprise + ", showNonRunning=" + this.showNonRunning + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class b
        extends a<c, b> {
            @Generated
            private b() {
            }

            @Override
            @Generated
            public final c build() {
                return new c(this);
            }
        }
    }

    @Generated
    public static abstract class a<C extends h, B extends a<C, B>> {
        @Generated
        private DataStoreEntryRef<ShellStore> host;

        @Generated
        public B host(DataStoreEntryRef<ShellStore> dataStoreEntryRef) {
            this.host = dataStoreEntryRef;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ProxmoxStore.ProxmoxStoreBuilder(host=" + String.valueOf(this.host) + ")";
        }
    }

    @JsonTypeName(value="proxmox")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<h, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final h build() {
            return new h(this);
        }
    }
}

