/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.hyperv;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.ext.ConnectionFileSystem;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.ext.FixedChildStore;
import io.xpipe.app.ext.NameableStore;
import io.xpipe.app.ext.ShellStore;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellDialects;
import io.xpipe.app.secret.SecretNoneStrategy;
import io.xpipe.app.secret.SecretRetrievalStrategy;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.app.util.LicenseProvider;
import io.xpipe.app.util.Validators;
import io.xpipe.core.FailableFunction;
import io.xpipe.core.OsType;
import io.xpipe.ext.base.store.PauseableStore;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import io.xpipe.ext.proc.hyperv.a;
import io.xpipe.ext.proc.pss.d;
import io.xpipe.ext.proc.ssh.t;
import io.xpipe.ext.proc.vm.e;
import io.xpipe.ext.proc.vm.h;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonTypeName(value="hyperVVm")
@JsonDeserialize(builder=b.class)
public final class f
extends e<h>
implements FixedChildStore,
NameableStore,
PauseableStore,
StartableStore,
StoppableStore {
    private final DataStoreEntryRef<io.xpipe.ext.proc.hyperv.b> install;
    private final String name;
    private final String vmId;

    @Override
    public final boolean supportsDesktopAccess() {
        boolean bl = Boolean.TRUE.equals(((h)this.getState()).getReachable());
        return bl;
    }

    @Override
    public final void checkComplete() {
        super.checkComplete();
        Validators.nonNull((Object)this.vmId);
        Validators.nonNull(this.install);
        Validators.isType(this.install, io.xpipe.ext.proc.hyperv.b.class);
        this.install.checkComplete();
    }

    @Override
    public final ShellControl createGuestShell() {
        boolean bl = Boolean.TRUE.equals(((h)this.getState()).getReachable());
        if (bl) {
            return super.createGuestShell();
        }
        Object object = ((h)this.getState()).getOsType();
        if (object != OsType.WINDOWS) {
            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException("Unable to connect to VM as no running SSH server has been detected.\n\nHyper-V can't run commands on non Windows guest systems to start an SSH server automatically, so you have to do it by yourself."));
        }
        object = ((d.c)((d.c)((d.c)d.builder().gateway(((io.xpipe.ext.proc.hyperv.b)this.install.getStore()).getHost())).connectionMethod(d.e.builder().vmId(this.vmId).build())).identity(this.getIdentity())).build();
        object = object.standaloneControl();
        return object;
    }

    @Override
    public final DataStoreEntryRef<ShellStore> getHypervisorHost() {
        if (this.install != null) {
            return ((io.xpipe.ext.proc.hyperv.b)this.install.getStore()).getHost();
        }
        return null;
    }

    @Override
    public final FailableFunction<CommandBuilder, Boolean, Exception> guestExecPredicate(ShellControl shellControl) {
        SecretRetrievalStrategy secretRetrievalStrategy = this.getIdentity().unwrap().getPassword();
        if (secretRetrievalStrategy instanceof SecretNoneStrategy) {
            return commandBuilder -> Boolean.FALSE;
        }
        return commandBuilder -> {
            if ((secretRetrievalStrategy = secretRetrievalStrategy.query().query("Password for guest VM").getSecret()) == null) {
                return Boolean.FALSE;
            }
            secretRetrievalStrategy = secretRetrievalStrategy.getSecretValue();
            secretRetrievalStrategy = "$username = \"%s\"\n$password = convertto-securestring -String %s -AsPlainText -Force\n$cred = new-object -typename System.Management.Automation.PSCredential -argumentlist $username, $password\nInvoke-Command -VmID \"%s\" -Credential $cred -ScriptBlock { %s }\n".formatted(this.getIdentity().unwrap().getUsername(), ShellDialects.POWERSHELL.literalArgument((String)secretRetrievalStrategy), this.vmId, commandBuilder.buildFull(shellControl)).lines().collect(Collectors.joining(";"));
            secretRetrievalStrategy = shellControl.command((String)secretRetrievalStrategy);
            secretRetrievalStrategy.sensitive();
            secretRetrievalStrategy = secretRetrievalStrategy.readStdoutIfPossible();
            return secretRetrievalStrategy.isPresent();
        };
    }

    @Override
    public final Class<h> getStateClass() {
        return h.class;
    }

    @Override
    public final ShellControl prepareHostShell(ShellControl shellControl) {
        return shellControl.subShell(ShellDialects.POWERSHELL);
    }

    @Override
    public final void prepareGuestShell(ShellControl shellControl) {
        shellControl.requireLicensedFeature(LicenseProvider.get().getFeature("hyperV"));
    }

    @Override
    public final void updateGuestState(ShellControl object) {
        try {
            ShellControl shellControl;
            block14: {
                block13: {
                    Optional<String> optional;
                    block11: {
                        block12: {
                            object = ((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).commandView((ShellControl)object).aq(this.vmId);
                            shellControl = ((a.a)((Object)object)).getShellControl().start();
                            try {
                                ((a.a)((Object)object)).bJ().bH();
                                this.refreshVmState((a.a)((Object)object));
                                if (((h)this.getState()).getRunning().booleanValue()) break block11;
                                if (shellControl == null) break block12;
                            }
                            catch (Throwable throwable) {
                                if (shellControl != null) {
                                    try {
                                        shellControl.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            shellControl.close();
                        }
                        return;
                    }
                    h.a<?, ?> a2 = ((h)this.getState()).toBuilder();
                    if (this.getCustomIp() == null || !this.getCustomIp().use()) {
                        optional = ((a.a)((Object)object)).bL();
                        if (optional.isEmpty()) {
                            this.setState(((h.a)((Object)((h.a)((Object)a2.ip(null))).reachable(Boolean.FALSE))).build());
                            optional = "Unable to determine external IP address for VM " + this.name + ".\n\nIs the VM fully running, has the network adapter initialized, and is the Hyper-V integration service running on the guest?";
                            throw (IllegalStateException)ErrorEventFactory.expected((Throwable)new IllegalStateException((String)((Object)optional)));
                        }
                        a2.ip((String)optional.get());
                        this.setState(a2.build());
                    }
                    optional = ((a.a)((Object)object)).bQ();
                    a2.osName((String)((Object)optional));
                    optional = optional == null ? null : (((String)((Object)optional)).contains("Windows") ? OsType.WINDOWS : (((String)((Object)optional)).contains("BSD") ? OsType.BSD : OsType.LINUX));
                    a2.osType((OsType.Any)optional);
                    boolean bl = t.isReachable(((a.a)((Object)object)).getShellControl(), this.getEffectiveIp(), this.getPort() != null ? this.getPort() : 22);
                    a2.reachable(bl);
                    if (!bl && optional == OsType.WINDOWS) {
                        bl = io.xpipe.ext.proc.vm.d.a(this, shellControl, (OsType.Any)optional);
                        a2.reachable(bl);
                    }
                    this.setState(a2.build());
                    if (shellControl == null) break block13;
                    break block14;
                }
                return;
            }
            shellControl.close();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
    }

    private void refreshVmState(a.a object) {
        Object object2 = (h)this.getState();
        object2 = ((h)((Object)object2)).toBuilder();
        object = object.bM();
        ((h.a)((Object)object2)).stateString((String)object);
        boolean bl = "Running".equals(object);
        ((h.a)((Object)object2)).running(bl);
        this.setState(((h.a)((Object)object2)).build());
    }

    public final FileSystem createFileSystem() {
        ShellControl shellControl = this.standaloneControl();
        boolean bl = Boolean.TRUE.equals(((h)this.getState()).getReachable());
        if (bl) {
            return new ConnectionFileSystem(shellControl);
        }
        return new io.xpipe.ext.proc.pss.a(shellControl);
    }

    public final void start() {
        ((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).checkLicense();
        a.a a2 = ((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).commandView(((ShellStore)((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).getHost().getStore()).getOrStartSession()).aq(this.vmId);
        a2.bN();
        this.refreshVmState(a2);
    }

    public final void stop() {
        ((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).checkLicense();
        a.a a2 = ((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).commandView(((ShellStore)((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).getHost().getStore()).getOrStartSession()).aq(this.vmId);
        a2.bO();
        this.refreshVmState(a2);
    }

    public final void pause() {
        ((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).checkLicense();
        a.a a2 = ((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).commandView(((ShellStore)((io.xpipe.ext.proc.hyperv.b)this.getInstall().getStore()).getHost().getStore()).getOrStartSession()).aq(this.vmId);
        a2.bP();
        this.refreshVmState(a2);
    }

    public final OptionalInt getFixedId() {
        return OptionalInt.of(this.vmId.hashCode());
    }

    public final FixedChildStore merge(FixedChildStore fixedChildStore) {
        fixedChildStore = (f)fixedChildStore;
        return ((a)this.toBuilder().identity(this.identity != null ? this.identity : fixedChildStore.identity)).build();
    }

    @Generated
    protected f(a<?, ?> a2) {
        super(a2);
        this.install = a2.install;
        this.name = a2.name;
        this.vmId = a2.vmId;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Generated
    public final a<?, ?> toBuilder() {
        return new b().$fillValuesFrom(this);
    }

    @Generated
    public final DataStoreEntryRef<io.xpipe.ext.proc.hyperv.b> getInstall() {
        return this.install;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public final String getVmId() {
        return this.vmId;
    }

    @Override
    @Generated
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof f)) {
            return false;
        }
        Object object2 = (f)object;
        if (!((f)object2).canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = this.getInstall();
        Object object3 = ((f)object2).getInstall();
        if (object == null ? object3 != null : !object.equals(object3)) {
            return false;
        }
        object = this.getName();
        object3 = ((f)object2).getName();
        if (object == null ? object3 != null : !object.equals(object3)) {
            return false;
        }
        object = this.getVmId();
        object2 = ((f)object2).getVmId();
        return !(object == null ? object2 != null : !object.equals(object2));
    }

    @Override
    @Generated
    protected final boolean canEqual(Object object) {
        return object instanceof f;
    }

    @Override
    @Generated
    public final int hashCode() {
        int n2 = super.hashCode();
        Object object = this.getInstall();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getName();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        object = this.getVmId();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        return n2;
    }

    @Override
    @Generated
    public final String toString() {
        return "HyperVVmStore(super=" + super.toString() + ", install=" + String.valueOf(this.getInstall()) + ", name=" + this.getName() + ", vmId=" + this.getVmId() + ")";
    }

    @Generated
    public static abstract class a<C extends f, B extends a<C, B>>
    extends e.a<h, C, B> {
        @Generated
        private DataStoreEntryRef<io.xpipe.ext.proc.hyperv.b> install;
        @Generated
        private String name;
        @Generated
        private String vmId;

        @Override
        @Generated
        protected B $fillValuesFrom(C c2) {
            super.$fillValuesFrom(c2);
            a.$fillValuesFromInstanceIntoBuilder(c2, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(f f2, a<?, ?> a2) {
            a2.install(f2.install);
            a2.name(f2.name);
            a2.vmId(f2.vmId);
        }

        @Generated
        public B install(DataStoreEntryRef<io.xpipe.ext.proc.hyperv.b> dataStoreEntryRef) {
            this.install = dataStoreEntryRef;
            return (B)this.self();
        }

        @Generated
        public B name(String string) {
            this.name = string;
            return (B)this.self();
        }

        @Generated
        public B vmId(String string) {
            this.vmId = string;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "HyperVVmStore.HyperVVmStoreBuilder(super=" + super.toString() + ", install=" + String.valueOf(this.install) + ", name=" + this.name + ", vmId=" + this.vmId + ")";
        }
    }

    @JsonTypeName(value="hyperVVm")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class b
    extends a<f, b> {
        @Generated
        private b() {
        }

        @Override
        @Generated
        public final f build() {
            return new f(this);
        }
    }
}

