/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc;

import io.xpipe.app.process.ShellControl;
import io.xpipe.app.process.ShellView;
import io.xpipe.app.util.FixedSizeInputStream;
import io.xpipe.core.FilePath;
import io.xpipe.core.OsType;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.stream.Collectors;

public final class f
extends ShellView {
    public f(ShellControl shellControl) {
        super(shellControl);
    }

    public final byte[] readRawFile(FilePath filePath) {
        return Files.readAllBytes(filePath.asLocalPath());
    }

    public final String readTextFile(FilePath filePath) {
        try {
            return Files.readString(filePath.asLocalPath());
        }
        catch (MalformedInputException malformedInputException) {
            return super.readTextFile(filePath);
        }
    }

    public final void writeTextFile(FilePath filePath, String object) {
        String string = this.getDialect().getNewLine().getNewLineString();
        object = this.getDialect().getTextCharset().toBytes(((String)object).lines().collect(Collectors.joining(string)) + string);
        Files.write(filePath.toLocalPath(), (byte[])object, new OpenOption[0]);
    }

    public final void writeScriptFile(FilePath filePath, String object) {
        String string = this.getDialect().getNewLine().getNewLineString();
        object = this.getDialect().getScriptCharset().toBytes(((String)object).lines().collect(Collectors.joining(string)) + string);
        Files.write(filePath.toLocalPath(), (byte[])object, new OpenOption[0]);
        if (this.shellControl.getOsType() != OsType.WINDOWS) {
            Files.setPosixFilePermissions(filePath.toLocalPath(), Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void writeStreamFile(FilePath object, InputStream inputStream, long l2) {
        inputStream = new FixedSizeInputStream(inputStream, l2);
        object = Files.newOutputStream(object.toLocalPath(), new OpenOption[0]);
        try {
            inputStream.transferTo((OutputStream)object);
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object).close();
    }

    public final void mkdir(FilePath filePath) {
        Files.createDirectories(filePath.asLocalPath(), new FileAttribute[0]);
    }
}

