/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.proc.aws;

import com.fasterxml.jackson.databind.JsonNode;
import io.xpipe.app.ext.FileEntry;
import io.xpipe.app.ext.FileInfo;
import io.xpipe.app.ext.FileKind;
import io.xpipe.app.ext.FileSystem;
import io.xpipe.app.issue.ErrorEventFactory;
import io.xpipe.app.process.CommandBuilder;
import io.xpipe.app.process.CommandControl;
import io.xpipe.app.process.ProcessOutputException;
import io.xpipe.app.process.ShellControl;
import io.xpipe.core.FilePath;
import io.xpipe.core.JacksonMapper;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;

public final class p
implements FileSystem {
    private final ShellControl aW;
    private final String aX;
    private FilePath aY;
    private final Set<FilePath> aZ = new HashSet<FilePath>();
    private static final SimpleDateFormat ba = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.US);

    public p(ShellControl shellControl, String string) {
        this.aW = shellControl;
        this.aX = string;
    }

    private CommandControl command(CommandBuilder commandBuilder) {
        io.xpipe.ext.proc.aws.a a2 = new io.xpipe.ext.proc.aws.a(this.aW, null, null);
        commandBuilder = a2.build(commandBuilder2 -> commandBuilder2.add(commandBuilder));
        return commandBuilder;
    }

    private String a(FilePath filePath) {
        if (this.aX != null) {
            return this.aX;
        }
        if (!filePath.isRoot()) {
            return (String)filePath.split().getFirst();
        }
        return "?";
    }

    private a b(FilePath object) {
        object = this.c((FilePath)object);
        return a.s((String)object);
    }

    public final String c(FilePath object) {
        FilePath filePath;
        CommandBuilder commandBuilder = CommandBuilder.of().add(new String[]{"s3api", "head-object"}).add(new String[]{"--bucket"}).addQuoted(this.a((FilePath)object)).add(new String[]{"--key"});
        FilePath filePath2 = object;
        object = this;
        if (((p)object).aX != null) {
            filePath = filePath2.relativize(FilePath.of((String)"/"));
        } else {
            object = FilePath.of((String)("/" + ((p)object).a(filePath2)));
            filePath = filePath2.relativize((FilePath)object);
        }
        object = this.command(commandBuilder.addFile(filePath)).readStdoutOrThrow();
        return object;
    }

    public final boolean writeInstantIfPossible(FileSystem object, FilePath filePath, FilePath filePath2) {
        if (object.getShell().map(shellControl -> shellControl.isLocal()).orElse(Boolean.FALSE).booleanValue()) {
            if (this.fileExists(filePath2) && (object = this.b(filePath2)).an()) {
                return false;
            }
            this.command(CommandBuilder.of().add(new String[]{"s3", "cp"}).addFile(filePath).addQuoted(this.c(filePath2, false))).execute();
            return true;
        }
        return false;
    }

    public final boolean readInstantIfPossible(FilePath filePath, FileSystem object, FilePath filePath2) {
        if (object.getShell().map(shellControl -> shellControl.isLocal()).orElse(Boolean.FALSE).booleanValue()) {
            object = this.b(filePath);
            if (object.an()) {
                return false;
            }
            this.command(CommandBuilder.of().add(new String[]{"s3", "cp"}).addQuoted(this.c(filePath, false)).addFile(filePath2)).execute();
            return true;
        }
        return false;
    }

    public final String getSuffix() {
        return "S3";
    }

    public final boolean isRunning() {
        return this.aW.isRunning(true);
    }

    public final boolean supportsLinkCreation() {
        return false;
    }

    public final boolean supportsOwnerColumn() {
        return false;
    }

    public final boolean supportsModeColumn() {
        return false;
    }

    public final boolean supportsDirectorySizes() {
        return false;
    }

    public final boolean supportsChmod() {
        return false;
    }

    public final boolean supportsChown() {
        return false;
    }

    public final boolean supportsChgrp() {
        return false;
    }

    public final boolean supportsTerminalOpen() {
        return true;
    }

    public final boolean supportsTerminalWorkingDirectory() {
        return false;
    }

    public final Optional<ShellControl> getRawShellControl() {
        return Optional.of(this.aW);
    }

    public final ShellControl getTerminalShellControl() {
        return this.aW;
    }

    public final void chmod(FilePath filePath, String string, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public final void chown(FilePath filePath, String string, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public final void chgrp(FilePath filePath, String string, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public final void kill() {
        this.aW.kill();
    }

    public final void cd(FilePath filePath) {
        this.aY = filePath;
    }

    public final boolean requiresReinit() {
        return !this.aW.isRunning(true) || this.aW.isAnyStreamClosed();
    }

    public final void reinitIfNeeded() {
        this.aW.start();
        if (this.aW.isAnyStreamClosed()) {
            this.aW.restart();
        }
    }

    public final String getFileSeparator() {
        return "/";
    }

    public final FilePath makeFileSystemCompatible(FilePath filePath) {
        return filePath;
    }

    public final Optional<FilePath> pwd() {
        return Optional.of(this.aY);
    }

    public final FileSystem createTransferOptimizedFileSystem() {
        return this;
    }

    public final long getFileSize(FilePath object) {
        a a2 = this.b((FilePath)object);
        if (a2.an()) {
            return a2.ap();
        }
        object = this.getFileInfo((FilePath)object);
        return object.map(fileEntry -> fileEntry.getFileSizeLong().orElse(0L)).orElse(0L);
    }

    public final long getDirectorySize(FilePath filePath) {
        return 0L;
    }

    public final Optional<ShellControl> getShell() {
        return Optional.empty();
    }

    public final FileSystem open() {
        this.aW.start();
        this.aY = FilePath.of((String)"/");
        p p2 = this;
        CommandControl commandControl = this.command(CommandBuilder.of().add(new String[]{"s3", "ls"}).addQuoted(p2.c(p2.aY, true)));
        commandControl.execute();
        this.aW.checkLicenseOrThrow();
        return this;
    }

    public final InputStream openInput(FilePath object) {
        a a2 = this.b((FilePath)object);
        object = this.command(CommandBuilder.of().add(new String[]{"s3", "cp"}).addQuoted(this.c((FilePath)object, false)).add(new String[]{"-"}));
        object.setExitTimeout(Duration.ofMillis(Long.MAX_VALUE));
        object = object.startExternalStdout();
        if (a2.an()) {
            return new GZIPInputStream((InputStream)object);
        }
        return object;
    }

    public final OutputStream openOutput(FilePath filePath, long l2) {
        a a2;
        Path path = Files.createTempFile(null, null, new FileAttribute[0]);
        Object object = null;
        OutputStream outputStream = new FileOutputStream(path.toFile());
        if (this.fileExists(filePath) && (a2 = this.b(filePath)).an()) {
            outputStream = new GZIPOutputStream(outputStream);
            object = "gzip";
        }
        a2 = object;
        return new FilterOutputStream(this, outputStream, path, filePath, (String)((Object)a2)){
            private /* synthetic */ Path bb;
            private /* synthetic */ FilePath bc;
            private /* synthetic */ String bd;
            private /* synthetic */ p be;
            {
                this.bb = path;
                this.bc = filePath;
                this.bd = string;
                p p3 = p2;
                Objects.requireNonNull(p3);
                this.be = p3;
                super(outputStream);
            }

            @Override
            public final void close() {
                try {
                    super.close();
                    this.be.command(CommandBuilder.of().add(new String[]{"s3", "cp"}).addFile(this.bb).addQuoted(this.be.c(this.bc, false)).addIf(this.bd != null, new String[]{"--content-encoding", this.bd})).execute();
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
            }
        };
    }

    public final boolean fileExists(FilePath filePath) {
        FilePath filePath2 = filePath;
        if (filePath2.equals((Object)filePath2.getRoot())) {
            return false;
        }
        p p2 = this;
        List<FileEntry> list = p2.listFiles(p2, filePath.getParent()).toList();
        return list.stream().filter(fileEntry -> fileEntry.getPath().equals((Object)filePath)).findFirst().map(fileEntry -> fileEntry.getKind() == FileKind.FILE).orElse(Boolean.FALSE);
    }

    public final void delete(FilePath filePath) {
        boolean bl = this.directoryExists(filePath);
        this.aZ.removeIf(filePath2 -> filePath2.startsWith(filePath));
        this.command(CommandBuilder.of().add(new String[]{"s3", "rm"}).addQuoted(this.c(filePath, false)).addIf(bl, new String[]{"--recursive"})).execute();
    }

    public final void copy(FilePath filePath, FilePath filePath2) {
        boolean bl = this.directoryExists(filePath);
        this.command(CommandBuilder.of().add(new String[]{"s3", "cp"}).addQuoted(this.c(filePath, false)).addQuoted(this.c(filePath2, false)).addIf(bl, new String[]{"--recursive"})).execute();
    }

    public final void move(FilePath filePath, FilePath filePath3) {
        boolean bl = this.a(filePath, false);
        if (!bl && this.aZ.remove(filePath)) {
            this.aZ.add(filePath3);
            Object object = this.aZ.stream().filter(filePath2 -> filePath2.startsWith(filePath)).toList();
            object = object.iterator();
            while (object.hasNext()) {
                FilePath filePath4 = (FilePath)object.next();
                FilePath filePath5 = filePath3.join(new String[]{filePath4.relativize(filePath).toString()});
                this.aZ.remove(filePath4);
                this.aZ.add(filePath5);
            }
            return;
        }
        this.command(CommandBuilder.of().add(new String[]{"s3", "mv"}).addQuoted(this.c(filePath, false)).addQuoted(this.c(filePath3, false)).addIf(bl, new String[]{"--recursive"})).execute();
        this.aZ.remove(filePath);
        this.command(CommandBuilder.of().add(new String[]{"s3", "rm"}).addQuoted(this.c(filePath, false))).execute();
    }

    public final void mkdirs(FilePath filePath) {
        this.aZ.add(filePath);
    }

    public final void touch(FilePath filePath) {
        Path path = Files.createTempFile(null, null, new FileAttribute[0]);
        this.command(CommandBuilder.of().add(new String[]{"s3", "cp"}).addFile(path).addQuoted(this.c(filePath, false))).execute();
    }

    public final void symbolicLink(FilePath filePath, FilePath filePath2) {
        throw new UnsupportedOperationException();
    }

    public final boolean directoryExists(FilePath filePath) {
        return this.a(filePath, true);
    }

    public final boolean a(FilePath filePath, boolean bl) {
        FilePath filePath2 = filePath;
        if (filePath2.equals((Object)filePath2.getRoot())) {
            return true;
        }
        if (bl && this.aZ.contains(filePath)) {
            return true;
        }
        try {
            p p2 = this;
            List<FileEntry> list = p2.a(p2, filePath.getParent(), bl).toList();
            return list.stream().filter(fileEntry -> fileEntry.getPath().equals((Object)filePath)).findFirst().map(fileEntry -> fileEntry.getKind() == FileKind.DIRECTORY).orElse(Boolean.FALSE);
        }
        catch (ProcessOutputException processOutputException) {
            return true;
        }
    }

    public final void directoryAccessible(FilePath filePath) {
    }

    public final Optional<FileEntry> getFileInfo(FilePath filePath) {
        FilePath filePath2 = filePath;
        if (filePath2.equals((Object)filePath2.getRoot())) {
            return Optional.of(new FileEntry((FileSystem)this, filePath, Instant.EPOCH, "0", (FileInfo)new FileInfo.Unix("rwxr-xr-xw", Integer.valueOf(0), "root", Integer.valueOf(0), "root"), FileKind.DIRECTORY));
        }
        p p2 = this;
        List<FileEntry> list = p2.listFiles(p2, filePath.getParent()).toList();
        return list.stream().filter(fileEntry -> fileEntry.getPath().equals((Object)filePath)).findFirst();
    }

    private String b(FilePath object, boolean bl) {
        if (object == null || object.toString().isEmpty()) {
            if (this.aX != null) {
                return this.aX;
            }
            return "";
        }
        if ((object = object.isAbsolute() ? object.toString().substring(1) : object.toString()).isEmpty()) {
            if (this.aX != null) {
                return this.aX;
            }
            return "";
        }
        return (String)(this.aX != null ? this.aX + "/" : "") + String.valueOf(bl ? FilePath.of((String)object).toDirectory() : FilePath.of((String)object).removeTrailingSlash());
    }

    private String c(FilePath object, boolean bl) {
        object = this.b((FilePath)object, bl);
        return "s3://" + (String)object;
    }

    public final Stream<FileEntry> listFiles(FileSystem fileSystem, FilePath filePath) {
        return this.a(fileSystem, filePath, true);
    }

    private Stream<FileEntry> a(FileSystem fileSystem, FilePath filePath, boolean bl) {
        ArrayList<FileEntry> arrayList = new ArrayList<FileEntry>();
        String string = this.aZ.contains(filePath) ? this.command(CommandBuilder.of().add(new String[]{"s3", "ls"}).addQuoted(this.c(filePath, true))).readStdoutIfPossible().orElse("") : this.command(CommandBuilder.of().add(new String[]{"s3", "ls"}).addQuoted(this.c(filePath, true))).readStdoutOrThrow();
        for (String string2 : string.lines().toList()) {
            String string3;
            Object object;
            if (string2.isBlank()) continue;
            if (string2.strip().startsWith("PRE")) {
                String[] stringArray = string2.strip().split("\\s+", 2);
                if (stringArray.length != 2) continue;
                object = stringArray[1];
                arrayList.add(new FileEntry(fileSystem, filePath.join(new String[]{object}).removeTrailingSlash(), null, null, null, FileKind.DIRECTORY));
                continue;
            }
            String[] stringArray = string2.strip().split("\\s+", 4);
            if (stringArray.length != 3 && stringArray.length != 4) continue;
            object = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray.length == 4 ? stringArray[2] : null;
            String string6 = string3 = stringArray.length == 4 ? stringArray[3] : stringArray[2];
            if (stringArray.length == 3 && Pattern.matches("\\d+", string3)) continue;
            object = ba.parse((String)object + " " + string4).toInstant();
            arrayList.add(new FileEntry(fileSystem, filePath.join(new String[]{string3}), (Instant)object, string5, null, stringArray.length == 4 ? FileKind.FILE : FileKind.DIRECTORY));
        }
        if (bl) {
            for (FilePath filePath2 : this.aZ) {
                if (arrayList.stream().anyMatch(fileEntry -> fileEntry.getPath().equals((Object)filePath2)) || !filePath2.getParent().equals((Object)filePath)) continue;
                arrayList.add(new FileEntry(fileSystem, filePath2, null, null, null, FileKind.DIRECTORY));
            }
        }
        return arrayList.stream();
    }

    public final List<FilePath> listRoots() {
        return List.of(FilePath.of((String)"/"));
    }

    public final List<FilePath> listCommonDirectories() {
        return List.of();
    }

    public final void close() {
        if (!this.aW.isRunning(true)) {
            return;
        }
        try {
            if (!this.aW.getStdin().isClosed()) {
                this.aW.writeLine("quit");
                Thread.sleep(100L);
            }
            this.aW.close();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ErrorEventFactory.fromThrowable((Throwable)exception).omit().expected().handle();
            return;
        }
    }

    @Generated
    public final ShellControl aj() {
        return this.aW;
    }

    @Generated
    public final String ak() {
        return this.aX;
    }

    @Generated
    public final FilePath al() {
        return this.aY;
    }

    @Generated
    public final Set<FilePath> am() {
        return this.aZ;
    }

    public static final class io.xpipe.ext.proc.aws.p$a {
        private final long contentLength;
        private final String contentEncoding;

        public static io.xpipe.ext.proc.aws.p$a s(String string) {
            string = JacksonMapper.getDefault().readTree(string);
            return io.xpipe.ext.proc.aws.p$a.ao().contentLength(Optional.ofNullable(string.get("ContentLength")).map(JsonNode::asLong).orElse(0L)).contentEncoding(Optional.ofNullable(string.get("ContentEncoding")).map(JsonNode::asText).orElse(null)).build();
        }

        public final boolean an() {
            return "gzip".equals(this.contentEncoding);
        }

        @Generated
        io.xpipe.ext.proc.aws.p$a(long l2, String string) {
            this.contentLength = l2;
            this.contentEncoding = string;
        }

        @Generated
        public static a ao() {
            return new a();
        }

        @Generated
        public final long ap() {
            return this.contentLength;
        }

        @Generated
        public final String aq() {
            return this.contentEncoding;
        }

        @Generated
        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof io.xpipe.ext.proc.aws.p$a)) {
                return false;
            }
            object = (io.xpipe.ext.proc.aws.p$a)object;
            if (this.ap() != ((io.xpipe.ext.proc.aws.p$a)object).ap()) {
                return false;
            }
            String string = this.aq();
            object = ((io.xpipe.ext.proc.aws.p$a)object).aq();
            return !(string == null ? object != null : !string.equals(object));
        }

        @Generated
        public final int hashCode() {
            long l2 = this.ap();
            int n2 = 59 + (int)(l2 >>> 32 ^ l2);
            String string = this.aq();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        @Generated
        public final String toString() {
            return "AwsS3FileSystem.Head(contentLength=" + this.ap() + ", contentEncoding=" + this.aq() + ")";
        }

        @Generated
        public static class a {
            @Generated
            private long contentLength;
            @Generated
            private String contentEncoding;

            @Generated
            a() {
            }

            @Generated
            public a contentLength(long l2) {
                this.contentLength = l2;
                return this;
            }

            @Generated
            public a contentEncoding(String string) {
                this.contentEncoding = string;
                return this;
            }

            @Generated
            public io.xpipe.ext.proc.aws.p$a build() {
                return new io.xpipe.ext.proc.aws.p$a(this.contentLength, this.contentEncoding);
            }

            @Generated
            public String toString() {
                return "AwsS3FileSystem.Head.HeadBuilder(contentLength=" + this.contentLength + ", contentEncoding=" + this.contentEncoding + ")";
            }
        }
    }
}

