/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/JvmPlatformOverloadsConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;)V", "chooseMaximallySpecificCandidates", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "candidates", "discriminateGenerics", "", "discriminateAbstracts", "java"})
public final class JvmPlatformOverloadsConflictResolver
extends AbstractConeCallConflictResolver {
    public JvmPlatformOverloadsConflictResolver(@NotNull TypeSpecificityComparator specificityComparator, @NotNull InferenceComponents inferenceComponents) {
        Intrinsics.checkNotNullParameter((Object)specificityComparator, (String)"specificityComparator");
        Intrinsics.checkNotNullParameter((Object)inferenceComponents, (String)"inferenceComponents");
        super(specificityComparator, inferenceComponents);
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates2, boolean discriminateGenerics, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getInferenceComponents().getSession()).supportsFeature(LanguageFeature.PreferJavaFieldOverload)) {
            return candidates2;
        }
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : candidates2) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirProperty && ClassMembersKt.containingClass(((FirProperty)me).getSymbol()) != null) {
                for (Candidate otherCandidate : candidates2) {
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirField) || ClassMembersKt.containingClass(((FirField)other).getSymbol()) == null) continue;
                    continue block0;
                }
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }
}

