---
id: 67cd4cf8b5fe391b324ad11f
title: Step 5
challengeType: 0
dashedName: step-5
---

# --description--

Now that you have created the `isVisible` state variable, it is time to start using it. 

In prior lessons, you learned about inline conditional rendering which allows you to show different content based on a certain condition. It is a common pattern to use the logical AND (`&&`) operator to conditionally render a piece of text like this:

```jsx
function Notification({ message }) {
  return (
    <div>
      {message && <p>{message}</p>}
    </div>
  );
}
```

In this example, the paragraph element will only show if the message is truthy. Remember that "truthy" refers to any value that evaluates to `true` in a Boolean context.

For this step, you will need to conditionally render the paragraph element. When done correctly, you should see that the paragraph is no longer visible on the page.

# --hints--

You should conditionally render the paragraph so it only shows when `isVisible` is `true`. Refer back to the example if you need help. 

```js
  {
    React.useState = (arg) => ([false, () => {}]);
    const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src ===  "index.jsx").innerText;
    const exports = {};
    const _a = eval(script);
    const div = await __helpers.prepTestComponent(exports.ToggleApp);
    const pEl = div.querySelector("p#message");
    assert.notExists(pEl);
  }
  {
    React.useState = (arg) => ([true, () => {}]);
    const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src ===  "index.jsx").innerText;
    const exports = {};
    const _a = eval(script);
    const div = await __helpers.prepTestComponent(exports.ToggleApp);
    const pEl = div.querySelector("p#message");
    assert.exists(pEl);
  }
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Toggle Visibility</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
  <script 
    data-plugins="transform-modules-umd"
    type="text/babel"
    src="index.jsx"
  ></script>
  <link rel="stylesheet" href="styles.css" />
</head>
<body>
  <div id="root"></div>
  <script
    data-plugins="transform-modules-umd"
    type="text/babel"
    data-presets="react"
    data-type="module"
  >
    import { ToggleApp } from "./index.jsx";
    ReactDOM.createRoot(document.getElementById("root")).render(<ToggleApp />);
  </script>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #f4f4f4;
}

#toggle-container {
  text-align: center;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

#toggle-button {
  padding: 10px 20px;
  border: none;
  background: #007BFF;
  color: white;
  border-radius: 5px;
  cursor: pointer;
  transition: background 0.3s ease;
}

#toggle-button:hover {
  background: #0056b3;
}

#message {
  margin-top: 20px;
  font-size: 1.125rem;
  color: #333;
}
```

```jsx
const { useState } = React;

export const ToggleApp = () => {
  const [isVisible, setIsVisible] = useState(false);

  return (
    <div id="toggle-container">
      <button id="toggle-button">Message</button>
      --fcc-editable-region--
      <p id="message">I love freeCodeCamp!</p>
      --fcc-editable-region--
    </div>
  );
};
```
