---
id: 67cd49e05693111a41771f29
title: Step 4
challengeType: 0
dashedName: step-4
---

# --description--

In the prior lessons, you learned how to create state variables by using the `useState` hook and array destructuring:

```js
const [user, setUser] = useState("Jessica");
```

The convention for naming state variables is to use the `example` and `setExample` format.

`useState` returns an array of two values. The first value is the current state. The second value is the set function that will be used to update state. 

Create a new state variable and set function called `isVisible` and `setIsVisible`. Remember to use the array destructuring syntax as shown in the example. 

Then assign the `useState` hook with an initial value of `false`. 

# --hints--

You should use the array destructuring syntax for the `isVisible` and `setIsVisible` variables. Refer back to the example.

```js
assert.match(code, /(const|let|var)\s+\[\s*(isVisible)\s*,\s*(setIsVisible)\s*\]\s*/);
```

You should use the `useState` hook.

```js
  const abuseState = __helpers.spyOn(React, "useState");

  const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src ===  "index.jsx").innerText;

  const exports = {};
  const _a = eval(script);
  const _b = await __helpers.prepTestComponent(exports.ToggleApp);
  assert.isAtLeast(abuseState.calls.length, 1);
```

Your `useState` hook should have an initial value of `false`.

```js
  const abuseState = __helpers.spyOn(React, "useState");

  const script = [...document.querySelectorAll("script")].find((s) => s.dataset.src ===  "index.jsx").innerText;

  const exports = {};
  const _a = eval(script);
  const _b = await __helpers.prepTestComponent(exports.ToggleApp);
  assert.equal(abuseState.calls[0]?.[0], false);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8" />
  <title>Toggle Visibility</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
  <script 
    data-plugins="transform-modules-umd"
    type="text/babel"
    src="index.jsx"
  ></script>
  <link rel="stylesheet" href="styles.css" />
</head>
<body>
  <div id="root"></div>
  <script
    data-plugins="transform-modules-umd"
    type="text/babel"
    data-presets="react"
    data-type="module"
  >
    import { ToggleApp } from "./index.jsx";
    ReactDOM.createRoot(document.getElementById("root")).render(<ToggleApp />);
  </script>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  background-color: #f4f4f4;
}

#toggle-container {
  text-align: center;
  background: white;
  padding: 20px;
  border-radius: 10px;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

#toggle-button {
  padding: 10px 20px;
  border: none;
  background: #007BFF;
  color: white;
  border-radius: 5px;
  cursor: pointer;
  transition: background 0.3s ease;
}

#toggle-button:hover {
  background: #0056b3;
}

#message {
  margin-top: 20px;
  font-size: 1.125rem;
  color: #333;
}
```

```jsx
const { useState } = React;

export const ToggleApp = () => {
  --fcc-editable-region--

  --fcc-editable-region--
  
  return (
    <div id="toggle-container">
      <button id="toggle-button">Message</button>
      <p id="message">I love freeCodeCamp!</p>
    </div>
  );
};
```
