---
id: 6866740a0f532cc7e9e21877
title: Step 29
challengeType: 0
dashedName: step-29
---

# --description--

Let's move onto the `Most popular` badge. You need to place it in the upper right corner of the card, so you can use some of Tailwind's positioning utility classes to do that.

Here's how you would use CSS positioning in Tailwind:

```html
<div class="relative">
  <div class="absolute top-0 left-0 bg-blue-200 p-2">
    This element is positioned at the top-left corner
  </div>
</div>
```

Assign the class `relative` to the wrapper `div` and `absolute` to the `div` with the text `Most popular`.

# --hints--

Your wrapper `div` element for the premium plan should have the class `relative`.

```js
const premiumPlanWrapper = document.querySelectorAll("div")[3]

assert.isTrue(premiumPlanWrapper.classList.contains("relative"))
```

Your `div` element with the text `Most popular` should have the class `absolute`.

```js
const badgeDiv = document.querySelectorAll("div")[4]

assert.isTrue(badgeDiv.classList.contains("absolute"))
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Music App Pricing</title>
    <script src="https://cdn.tailwindcss.com"></script>
  </head>
  <body class="bg-gray-100">
    <main>
      <h1 class="mt-8 mb-12 text-center text-3xl md:text-5xl font-semibold text-gray-900">Choose your listening plan</h1>
      <div class="grid grid-cols-1 md:grid-cols-3 max-w-6xl mx-auto gap-8 mt-16">
        <div class="bg-gray-100 ring-1 ring-gray-300 grid grid-rows-[1fr_auto] rounded-xl p-8 gap-6">
          <div class="grid grid-rows-[auto_auto_auto_1fr] gap-y-2">
            <h2 class="text-lg font-semibold text-indigo-600">Listener</h2>
            <p class="text-4xl font-bold text-gray-900">$0<span class="text-base font-medium text-gray-500">/month</span></p>
            <p>
              Start exploring millions of songs with basic features and ads.
            </p>
            <ul class="mt-6 space-y-2 text-sm text-gray-700">
              <li>
                <span aria-hidden class="text-green-700 mr-2">&#10003;</span>Ad-supported streaming
              </li>
              <li>
                <span aria-hidden class="text-green-700 mr-2">&#10003;</span>Curated playlists
              </li>
            </ul>
          </div>
          <a
            href="#"
            class="block rounded-md bg-indigo-100 px-4 py-2 text-center font-semibold text-indigo-700 hover:bg-indigo-200"
          >
            Start listening
          </a>
        </div>
--fcc-editable-region--
        <div class=" bg-gray-950 text-white ring-2 ring-fuchsia-500 p-8 grid grid-rows-[1fr_auto] gap-6 rounded-xl scale-105">
          <div >Most Popular</div>
          <div>
            <h2>Premium</h2>
            <p>$9.99<span>/month</span></p>
            <p>
              Enjoy the full music experience with unlimited access and
              downloads.
            </p>
            <ul>
              <li><span>&#10003;</span>Ad-free listening</li>
              <li><span>&#10003;</span>Offline playback</li>
              <li><span>&#10003;</span>Unlimited skips</li>
            </ul>
          </div>
          <a href="#">Go Premium</a>
        </div>
--fcc-editable-region--
        <div>
          <div>
            <h2>Family</h2>
            <p>$14.99<span>/month</span></p>
            <p>
              Enjoy all of the features with a plan for up to 6 family members.
            </p>
            <ul>
              <li>
                <span>&#10003;</span>All Premium features
              </li>
              <li>
                <span>&#10003;</span>Up to 6 accounts
              </li>
              <li>
                <span>&#10003;</span>Individual playlists &
                libraries
              </li>
              <li>
                <span>&#10003;</span>Family Mix playlists
              </li>
            </ul>
          </div>
          <a href="#">Start Family Plan</a>
        </div>
      </div>
    </main>
  </body>
</html>
```
