---
id: 680900675ae3d54ee19590cb
title: Step 11
challengeType: 0
dashedName: step-11
---

# --description--

In a prior lesson, you learned how to render a list of options using the `map()` method like this:

```jsx
function FruitList() {
  const fruits = ["Apple", "Banana", "Cherry", "Date"];
  return (
    <ul>
      {fruits.map((fruit, index) => (
        <li key={`${fruit}-${index}`}>{fruit}</li>
      ))}
    </ul>
  );
}
```

Remember that the `key` must always be unique. It helps React identify which items have changed, and been added or removed.

After the first `option`, use an arrow function to map through the `powerSourceOptions` array using `source` as the parameter.

Then inside the `map()` method, create an `option` element with a `key` of `source` and a `value` of `source`. Lastly, use `{source}` to display the name of each power source in the dropdown.

# --hints--

You should map through `powerSourceOptions`.

```js
assert.match(code, /\{\s*powerSourceOptions\s*\.\s*map\s*\(/)
```

You should pass in `source` as the parameter of the map.

```js
assert.match(code, /\{\s*powerSourceOptions\s*\.\s*map\s*\(\s*(source|\(\s*source\s*\))\s*=>/)
```

You should create an `option` element with a `key` of `source` and `value` of `source`.

```js
assert.match(code, /<\s*option\s+(key\s*=\s*{\s*source\s*}\s*value\s*=\s*{\s*source\s*}|value\s*=\s*{\s*source\s*}\s*key\s*=\s*{\s*source\s*})\s*>\s*{\s*source\s*}\s*<\/\s*option\s*>/)
```

You should have a total of seven `option` elements.

```js
const optionElements = document?.querySelectorAll("option");
assert.lengthOf(optionElements, 7); 
```

For the last six `option` elements, each text content should correspond to one of the power source options from the `powerSourceOptions` array. 

```js
const optionElements = document?.querySelectorAll("option");

const powerSourceOptions = [
  "Bitten by a strange creature",
  "Radioactive exposure",
  "Science experiment",
  "Alien heritage",
  "Ancient artifact discovery",
  "Other"
];

for (let i = 0; i < powerSourceOptions.length; i++) {
  const option = optionElements[i+1]; 
  const expected = powerSourceOptions[i];

  assert.strictEqual(option?.textContent, expected);
  assert.strictEqual(option.value, expected);
}
```

# --seed--

## --seed-contents--

```html
<!doctype html>
<html>
  <head>
    <meta charset="UTF-8" />
    <title>Superhero Application Form</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.3/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      src="index.jsx"
    ></script>
    <link rel="stylesheet" href="styles.css" />
  </head>

  <body>
    <div id="root"></div>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { SuperheroForm } from './index.jsx';
      ReactDOM.createRoot(document.getElementById('root')).render(<SuperheroForm />);
    </script>
  </body>
</html>
```

```css
body {
  margin: 0;
  padding: 0;
  min-height: 100vh;
  font-family: Arial, sans-serif;
  display: flex;
  justify-content: center;
  align-items: center;
  background: linear-gradient(30deg, #ff9999 50%, #6699ff 50%)
}

.form-wrap {
  background-color: white;
  width: 400px;
  padding: 20px;
  border: 1px solid black;
  box-shadow: 5px 5px 10px black;
}

.form-wrap h2,
.form-wrap p {
  text-align: center;
}

.form-wrap p {
  position: relative;
  top: -18px;
}

.section {
  display: flex;
  margin-bottom: 30px;
}

.column {
  flex-direction: column;
}

.submit-wrap {
  text-align: center;
}

.submit-btn {
  display: block;
  margin: 0 auto;
  padding: 0.4rem 0.5rem;
  border: 1px solid black
}

.submit-btn:hover {
  cursor: pointer;
  background-color: #f3f3f3;
}

.submit-btn:disabled {
  cursor: not-allowed;
}
```

```jsx
const { useState } = React;

export const SuperheroForm = () => {

  const powerSourceOptions = [
    'Bitten by a strange creature',
    'Radioactive exposure',
    'Science experiment',
    'Alien heritage',
    'Ancient artifact discovery',
    'Other'
  ];

  const [heroName, setHeroName] = useState('');
  const [realName, setRealName] = useState('');
  const [powerSource, setPowerSource] = useState('');
  const [powers, setPowers] = useState([]);

  return (
    <div className='form-wrap'>
      <h2>Superhero Application Form</h2>
      <p>Please complete all fields</p>
      <form>
        <div className='section'>
          <label>
            Hero Name
            <input
              type='text'
              value={heroName}
              onChange={e => setHeroName(e.target.value)}
            />
          </label>
          <label>
            Real Name
            <input
              type='password'
              value={realName}
              onChange={e => setRealName(e.target.value)}
            />
          </label>
        </div>
        <label className='section column'>
          How did you get your powers?
          <select>
            <option value=''>
              Select one
            </option>
          --fcc-editable-region--
            
          --fcc-editable-region--
          </select>
        </label>
      </form>
    </div>
  )
};
```
