---
id: 66bb6467b4b7381178420970
title: Step 17
challengeType: 0
dashedName: step-17
---

# --description--

While this expression does match `1 hundred dollars`, it will not match `1  hundred  dollars`, or `10 dollars`.

Spam messages can and will find a way to exploit flaws in your detection. Time to improve your regex.

Replace the first literal space with the `\s*` expression. The `\s` character class matches whitespace, such as spaces, tabs, and new lines. The `*` quantifier means "match the previous character 0 or more times".

Replace the second literal space with `\s+`. The `+` quantifier means "match the previous character at least one time".

# --hints--

Your `dollarRegex` must not use literal spaces. 

```js
assert.notMatch(dollarRegex.source, / /);
```

Your `dollarRegex` must allow any number of spaces before the dollar quantity, and one or more spaces after.

```js
let dollarStr = '10hundred dollars'
assert.deepEqual(dollarStr.match(dollarRegex), dollarStr.match(/[0-9]+\s*(hundred|thousand|million|billion)?\s+dollars/i));
dollarStr = '10 hundred   dollars'
assert.deepEqual(dollarStr.match(dollarRegex), dollarStr.match(/[0-9]+\s*(hundred|thousand|million|billion)?\s+dollars/i));
dollarStr = '10    hundred dollars'
assert.deepEqual(dollarStr.match(dollarRegex), dollarStr.match(/[0-9]+\s*(hundred|thousand|million|billion)?\s+dollars/i));
dollarStr = '10 hundreddollars'
assert.notMatch(dollarStr, dollarRegex)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width" />
    <title>Learn Regular Expressions by Building a Spam Filter</title>
    <link rel="stylesheet" href="styles.css" />
  </head>

  <body>
    <header class="main-text">
      <h1 class="title">Is this Spam?</h1>
      <p class="description">
        Enter a phrase to check if it would be marked as spam or not.
      </p>
    </header>

    <main>
      <label class="message-label" for="message-input">Message: </label>
      <textarea
        placeholder="Enter message here"
        value=""
        type="text"
        name="message"
        id="message-input"
        rows="10"
        cols="40"
      ></textarea>
      <button class="btn" id="check-message-btn" type="button">
        Check message
      </button>
      <p id="result-message"></p>
    </main>

    <footer class="footer">&copy; freeCodeCamp</footer>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --golden-yellow: #fecc4c;
  --yellow: #ffcc4c;
  --gold: #feac32;
  --orange: #ffac33;
  --dark-orange: #f89808;
}

body {
  background-color: var(--dark-grey);
  color: var(--light-grey);
}

body,
#message-input:placeholder-shown {
  text-align: center;
}

textarea {
  max-width: 90%;
}

.main-text {
  margin: 25px 0;
}

.title {
  font-size: 2.5rem;
}

.description {
  margin-top: 15px;
  font-size: 1.4rem;
}

.message-label {
  display: block;
  margin-bottom: 20px;
  font-size: 1.5rem;
}

#message-input:placeholder-shown,
textarea {
  font-size: 1.1rem;
}

.btn {
  display: block;
  cursor: pointer;
  width: 200px;
  margin: 10px auto;
  color: var(--dark-grey);
  background-color: var(--gold);
  background-image: linear-gradient(var(--golden-yellow), var(--orange));
  border-color: var(--gold);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(var(--yellow), var(--dark-orange));
}

#result {
  font-size: 2rem;
  margin: 20px 0;
}

.footer {
  margin-top: 10px;
}
```

```js
const messageInput = document.getElementById("message-input");
const result = document.getElementById("result-message");
const checkMessageButton = document.getElementById("check-message-btn");

const helpRegex = /please help|assist me/i;
--fcc-editable-region--
const dollarRegex = /[0-9]+ (hundred|thousand|million|billion)? dollars/i;
--fcc-editable-region--

const denyList = [helpRegex, dollarRegex];

const isSpam = (msg) => denyList.some((regex) => regex.test(msg));

checkMessageButton.addEventListener("click", () => {
  if (messageInput.value === "") {
    alert("Please enter a message.");
    return;
  }

  result.textContent = isSpam(messageInput.value)
    ? "Oh no! This looks like a spam message."
    : "This message does not seem to contain any spam.";
  messageInput.value = "";
});
```
