---
id: 641cdf57c3f7ee276e1d9b32
title: Step 4
challengeType: 0
dashedName: step-4
---

# --description--

Back in your event listener, you need to update the text of the `result` element. You can use a ternary operator to achieve this task.

Here is an example of assigning the result of a ternary operator to an element's text content:

```js
el.textContent = condition ? "Use this text if the condition is true" : "Use this text if the condition is false";
```

After the `if` statement, update the text of the `result` element based on the truthiness of calling `isSpam()` with `messageInput.value` as the argument. If true, set the `textContent` property on the `result` element to `"Oh no! This looks like a spam message."`. Otherwise, set it to `"This message does not seem to contain any spam."`

Then set the `messageInput` element's `value` property to an empty string.

# --hints--

When you click your `checkMessageButton` and the `isSpam(messageInput.value)` is truthy, you should set the `textContent` property of `result` to `"Oh no! This looks like a spam message."`.

```js
const temp = isSpam;
isSpam = (msg) => true;
messageInput.value = "spam";
try {
  checkMessageButton.dispatchEvent(new Event("click"));
  assert.equal(document.querySelector("#result-message").textContent, "Oh no! This looks like a spam message.");
} finally {
  isSpam = temp;
}
```

When you click your `checkMessageButton` and the `isSpam(messageInput.value)` is falsy, you should set the `textContent` property of `result` to `"This message does not seem to contain any spam."`.

```js
messageInput.value = "spam";
checkMessageButton.dispatchEvent(new Event("click"));
assert.equal(document.querySelector("#result-message").textContent, "This message does not seem to contain any spam.");
```

After setting the `textContent` of `result`, you should reset the `value` property on the `messageInput` element to an empty string.

```js
messageInput.value = "spam";
checkMessageButton.dispatchEvent(new Event("click"));
assert.isEmpty(messageInput.value);

messageInput.value = "spam";
const temp = isSpam;
isSpam = (msg) => true;
try {
  checkMessageButton.dispatchEvent(new Event("click"));
  assert.isEmpty(messageInput.value);
} finally {
  isSpam = temp;
}
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width" />
    <title>Learn Regular Expressions by Building a Spam Filter</title>
    <link rel="stylesheet" href="styles.css" />
  </head>

  <body>
    <header class="main-text">
      <h1 class="title">Is this Spam?</h1>
      <p class="description">
        Enter a phrase to check if it would be marked as spam or not.
      </p>
    </header>

    <main>
      <label class="message-label" for="message-input">Message: </label>
      <textarea
        placeholder="Enter message here"
        value=""
        type="text"
        name="message"
        id="message-input"
        rows="10"
        cols="40"
      ></textarea>
      <button class="btn" id="check-message-btn" type="button">
        Check message
      </button>
      <p id="result-message"></p>
    </main>

    <footer class="footer">&copy; freeCodeCamp</footer>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --golden-yellow: #fecc4c;
  --yellow: #ffcc4c;
  --gold: #feac32;
  --orange: #ffac33;
  --dark-orange: #f89808;
}

body {
  background-color: var(--dark-grey);
  color: var(--light-grey);
}

body,
#message-input:placeholder-shown {
  text-align: center;
}

textarea {
  max-width: 90%;
}

.main-text {
  margin: 25px 0;
}

.title {
  font-size: 2.5rem;
}

.description {
  margin-top: 15px;
  font-size: 1.4rem;
}

.message-label {
  display: block;
  margin-bottom: 20px;
  font-size: 1.5rem;
}

#message-input:placeholder-shown,
textarea {
  font-size: 1.1rem;
}

.btn {
  display: block;
  cursor: pointer;
  width: 200px;
  margin: 10px auto;
  color: var(--dark-grey);
  background-color: var(--gold);
  background-image: linear-gradient(var(--golden-yellow), var(--orange));
  border-color: var(--gold);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(var(--yellow), var(--dark-orange));
}

#result {
  font-size: 2rem;
  margin: 20px 0;
}

.footer {
  margin-top: 10px;
}
```

```js
const messageInput = document.getElementById("message-input");
const result = document.getElementById("result-message");
const checkMessageButton = document.getElementById("check-message-btn");

const isSpam = (msg) => false;

--fcc-editable-region--
checkMessageButton.addEventListener("click", () => {
  if (messageInput.value === "") {
    alert("Please enter a message.");
    return;
  }


});
--fcc-editable-region--
```
