---
id: 69046179fba35c03dec84fb6
title: Step 24
challengeType: 20
dashedName: step-24
---

# --description--

Now you'll use the `join()` method to combine the string representations of the node numbers into a single readable path.

The `join()` method takes an iterable (like your generator expression) and combines all elements into one string, placing the separator between each element. For example:

```py
numbers = ['1', '2', '3']
route = ' -> '.join(numbers) # route will be '1 -> 2 -> 3'
```

Create a variable called `path` and assign it the result of joining `string_path` using `' -> '` as the separator.

# --hints--

You should create a variable called `path`.

```js
({
test: () => {
  assert(
    runPython(`
func = _Node(_code).find_function("shortest_path")
for_loop = func.find_for_loops()[-1]
for_loop.find_bodies()[0].has_variable("path")
      `)
);
    }
});
```

You use `join` to join the items in `string_path` with `' -> '` as the separator and assign the result to `path`.

```js
({
  test: () => {
    runPython(`
func = _Node(_code).find_function("shortest_path")
for_loop = func.find_for_loops()[-1]
assert for_loop.find_bodies()[0].find_variable("path").is_equivalent('path = " -> ".join(string_path)')
    `);
    }
});
```

# --seed--

## --seed-contents--

```py
INF = float('inf')
adj_matrix = [
    [0, 5, 3, INF, 11, INF],
    [5, 0, 1, INF, INF, 2],
    [3, 1, 0, 1, 5, INF],
    [INF, INF, 1, 0, 9, 3],
    [11, INF, 5, 9, 0, INF],
    [INF, 2, INF, 3, INF, 0],
]

def shortest_path(matrix, start_node, target_node=None):
    n = len(matrix)
    distances = [INF] * n
    distances[start_node] = 0
    paths = [[node_no] for node_no in range(n)]
    visited = [False] * n

    for _ in range(n):
        min_distance = INF
        current = -1
        for node_no in range(n):
            if not visited[node_no] and distances[node_no] < min_distance:
                min_distance = distances[node_no]
                current = node_no

        if current == -1:
            break
        visited[current] = True

        for node_no in range(n):
            distance = matrix[current][node_no]
            if distance != INF and not visited[node_no]:
                new_distance = distances[current] + distance
                if new_distance < distances[node_no]:
                    distances[node_no] = new_distance
                    paths[node_no] = paths[current] + [node_no]

--fcc-editable-region--
    targets = [target_node] if target_node is not None else range(n)
    for node_no in targets:
        if node_no == start_node or distances[node_no] == INF:
            continue
        string_path = (str(n) for n in paths[node_no])
        
--fcc-editable-region--
```
