---
id: 687b45e16f38ad5f4e4bd799
title: Step 23
challengeType: 20
dashedName: step-23
---

# --description--

Now that you've determined a node should be displayed, you need to format its path so it can be printed clearly. For this you will use a generator expression.

A generator expression is similar to a list comprehension, but instead of creating a list, it generates each value one at a time. It uses parentheses `()` instead of square brackets `[]`. For example:

```py
numbers = [1, 2, 3]
squared = (x**2 for x in numbers)  # Generator expression
```

Inside the loop after the `if` statement, create a variable called `string_path`. Assign it a generator expression that converts each node number in `paths[node_no]` to a string using `str()`. 

The generator expression should iterate over each node number `n` in `paths[node_no]`.

# --hints--

You should create a variable called `string_path`.

```js
({
    test: () => {
      assert(
        runPython(`
func = _Node(_code).find_function("shortest_path")
for_loop = func.find_for_loops()[-1]
for_loop.find_bodies()[0].has_variable("string_path")
      `)
      );
    }
});
```

You should assign a generator expression to `string_path`.

```js
({
  test: () => {
      runPython(`
      import ast
      assert isinstance(_Node(_code).find_function("shortest_path").find_for_loops()[1].find_bodies()[0].find_variable("string_path").tree.value, ast.GeneratorExp)
      `)
 }
})
```

Your generator expression should iterate over `paths[node_no]`.

```js
({
    test: () => {
        runPython(`
func = _Node(_code).find_function("shortest_path")
for_loop = func.find_for_loops()[-1]
path_var = for_loop.find_bodies()[0].find_variable("string_path")
assert path_var.find_comp_iters()[0].is_equivalent("paths[node_no]")
      `);
    }
});
```

Your generator expression should use `n` as the iteration variable to iterate over `paths[node_no]`.

```js
({
  test: () => {
      runPython(`
func = _Node(_code).find_function("shortest_path")
for_loop = func.find_for_loops()[-1]
string_path_var = for_loop.find_bodies()[0].find_variable("string_path")
assert string_path_var.find_comp_targets()[0].is_equivalent("n")
      `);
    }
});
```

Your generator expression should evaluate `str(n)` for each `n` in `paths[node_no]`.

```js
({
  test: () => {
      runPython(`
func = _Node(_code).find_function("shortest_path")
for_loop = func.find_for_loops()[-1]
string_path_var = for_loop.find_bodies()[0].find_variable("string_path")
assert string_path_var.find_comp_expr().is_equivalent("str(n)")
      `);
    }
});
```

# --seed--

## --seed-contents--

```py
INF = float('inf')
adj_matrix = [
    [0, 5, 3, INF, 11, INF],
    [5, 0, 1, INF, INF, 2],
    [3, 1, 0, 1, 5, INF],
    [INF, INF, 1, 0, 9, 3],
    [11, INF, 5, 9, 0, INF],
    [INF, 2, INF, 3, INF, 0],
]

def shortest_path(matrix, start_node, target_node=None):
    n = len(matrix)
    distances = [INF] * n
    distances[start_node] = 0
    paths = [[node_no] for node_no in range(n)]
    visited = [False] * n

    for _ in range(n):
        min_distance = INF
        current = -1
        for node_no in range(n):
            if not visited[node_no] and distances[node_no] < min_distance:
                min_distance = distances[node_no]
                current = node_no

        if current == -1:
            break
        visited[current] = True

        for node_no in range(n):
            distance = matrix[current][node_no]
            if distance != INF and not visited[node_no]:
                new_distance = distances[current] + distance
                if new_distance < distances[node_no]:
                    distances[node_no] = new_distance
                    paths[node_no] = paths[current] + [node_no]

--fcc-editable-region--
    targets = [target_node] if target_node is not None else range(n)
    for node_no in targets:
        if node_no == start_node or distances[node_no] == INF:
            continue

--fcc-editable-region--
```
