---
id: 687b43c0e20d695e0b8cca5b
title: Step 22
challengeType: 20
dashedName: step-22
---

# --description--

At this point, you only want to display results for nodes that are not the start node and are reachable from it.

Add a conditional that checks if `node_no` equals `start_node` **or** if `distances[node_no]` equals `INF`.

If either condition is true, use `continue` to skip to the next iteration of the loop.

# --hints--

You should add a conditional statement inside the loop.

```js
({
    test: () => {
        runPython(`
func = _Node(_code).find_function("shortest_path")
last_loop = func.find_for_loops()[-1]
assert last_loop.find_bodies()[0].find_ifs()[0]
      `);
    }
});
```

Your `if` statement should check if `node_no` is equal to `start_node` *or* if `distances[node_no]` is equal to `INF`.

```js
({
    test: () => {
              runPython(`
func = _Node(_code).find_function("shortest_path")
if_cond = func.find_for_loops()[-1].find_bodies()[0].find_ifs()[0].find_conditions()[0]
conditions = [
  'node_no == start_node or distances[node_no] == INF',
  'start_node == node_no or distances[node_no] == INF',
  'start_node == node_no or INF == distances[node_no]',
  'node_no == start_node or INF == distances[node_no]',  
  'distances[node_no] == INF or node_no == start_node',
  'distances[node_no] == INF or start_node == node_no',
  'INF == distances[node_no] or start_node == node_no',
  'INF == distances[node_no] or node_no == start_node',
]
assert any(if_cond.is_equivalent(condition) for condition in conditions)
      `);
    }
});
```

You should use `continue` to skip to the next iteration of the loop.

```js
({
    test: () => {
        runPython(`  
func = _Node(_code).find_function("shortest_path")  
if_stmt = func.find_for_loops()[-1].find_bodies()[0].find_ifs()[0].find_bodies()[0]  
assert if_stmt.has_stmt("continue")  
      `);
    }
});
```

# --seed--

## --seed-contents--

```py
INF = float('inf')
adj_matrix = [
    [0, 5, 3, INF, 11, INF],
    [5, 0, 1, INF, INF, 2],
    [3, 1, 0, 1, 5, INF],
    [INF, INF, 1, 0, 9, 3],
    [11, INF, 5, 9, 0, INF],
    [INF, 2, INF, 3, INF, 0],
]

def shortest_path(matrix, start_node, target_node=None):
    n = len(matrix)
    distances = [INF] * n
    distances[start_node] = 0
    paths = [[node_no] for node_no in range(n)]
    visited = [False] * n

    for _ in range(n):
        min_distance = INF
        current = -1
        for node_no in range(n):
            if not visited[node_no] and distances[node_no] < min_distance:
                min_distance = distances[node_no]
                current = node_no

        if current == -1:
            break
        visited[current] = True

        for node_no in range(n):
            distance = matrix[current][node_no]
            if distance != INF and not visited[node_no]:
                new_distance = distances[current] + distance
                if new_distance < distances[node_no]:
                    distances[node_no] = new_distance
                    paths[node_no] = paths[current] + [node_no]

--fcc-editable-region--
    targets = [target_node] if target_node is not None else range(n)
    for node_no in targets:
        pass

--fcc-editable-region--
```
