---
id: 68777816e95d4936f129819f
title: Step 17
challengeType: 20
dashedName: step-17
---

# --description--

Before trying to update the distance to a neighbor, you need to verify that the neighbor is both reachable and unvisited. Then you'll calculate what the total distance would be to reach that neighbor through the current node.

Inside the `for` loop, add an `if` statement that checks:

- The `distance` is not equal to `INF` (meaning there's an edge between the nodes)
- The neighbor `node_no` has not been visited yet

Inside the `if` block, create a variable named `new_distance` and assign it the sum of `distances[current]` (the shortest distance to the current node) and `distance` (the distance from the current node to the neighbor).

# --hints--

You should have an `if` statement that checks if `distance` is not equal to `INF` and if the neighbor node has not been visited.

```js
({
    test: () => {
      assert(
        runPython(`_Node(_code).find_function("shortest_path").find_for_loops()[0].find_bodies()[0].find_for_loops()[1].find_bodies()[0].find_ifs()[0].find_conditions()[0].is_equivalent("distance != INF and not visited[node_no]") 
      `)
      );
    }
});
```

You should create a variable named `new_distance` inside the `if` block.

```js
({
    test: () => {
      assert(
        runPython(
          `_Node(_code).find_function("shortest_path").find_for_loops()[0].find_bodies()[0].find_for_loops()[1].find_bodies()[0].find_ifs()[0].find_bodies()[0].has_variable("new_distance")`
        )
      );
    }
});
```

You should assign `new_distance` the sum of `distances[current]` and `distance`.

```js
({
    test: () => {
      assert(
        runPython(
          `_Node(_code).find_function("shortest_path").find_for_loops()[0].find_bodies()[0].find_for_loops()[1].find_bodies()[0].find_ifs()[0].find_bodies()[0].find_variable("new_distance").is_equivalent("new_distance = distances[current] + distance")`
        )
      );
    }
});
```

# --seed--

## --seed-contents--

```py
INF = float('inf')
adj_matrix = [
    [0, 5, 3, INF, 11, INF],
    [5, 0, 1, INF, INF, 2],
    [3, 1, 0, 1, 5, INF],
    [INF, INF, 1, 0, 9, 3],
    [11, INF, 5, 9, 0, INF],
    [INF, 2, INF, 3, INF, 0],
]

def shortest_path(matrix, start_node, target_node=None):
    n = len(matrix)
    distances = [INF] * n
    distances[start_node] = 0
    paths = [[node_no] for node_no in range(n)]
    visited = [False] * n

    for _ in range(n):
        min_distance = INF
        current = -1
        for node_no in range(n):
            if not visited[node_no] and distances[node_no] < min_distance:
              min_distance = distances[node_no]
              current = node_no

        if current == -1:
            break
        visited[current] = True

--fcc-editable-region--
        for node_no in range(n):  
            distance = matrix[current][node_no]

--fcc-editable-region--
```
