---
id: 67f647f3ce657ae05908d6c9
title: Step 2
challengeType: 0
dashedName: step-2
---

# --description--

Within the `return` statement of the `ShoppingList` component, add a `div` element with a `className` of `container`.

Inside the `div`, nest an `h1` element with the text `Shopping List`, and below that, nest an empty `form` element.

# --hints--

Your `ShoppingList` component should return a `div` element with a `className` of `container`.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  assert.equal(testElem.firstElementChild?.tagName, 'DIV');
  assert.isTrue(
    [...testElem.firstElementChild.classList].includes('container')
  );
```

Your `div` should contain an `h1` element with the text `Shopping List`.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  const h1 = testElem.querySelector('h1');
  assert.exists(h1);
  assert.equal(h1.textContent.toLowerCase().trim(), 'shopping list');
```

Your `div` should also contain an empty `form` element.

```js
  const testElem = await __helpers.prepTestComponent(window.index.ShoppingList);
  const form = testElem.querySelector('form');
  assert.exists(form);
  assert.equal(form.tagName, 'FORM');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Shopping List</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react/18.3.1/umd/react.development.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/react-dom/18.3.1/umd/react-dom.development.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-standalone/7.26.5/babel.min.js"></script>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
      src="index.jsx"
    ></script>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <main id="app-container"></main>
    <script
      data-plugins="transform-modules-umd"
      type="text/babel"
      data-presets="react"
      data-type="module"
    >
      import { ShoppingList } from "./index.jsx";
      const appContainer = document.getElementById("app-container");
      const root = ReactDOM.createRoot(appContainer);
      root.render(<ShoppingList />);
    </script>
  </body>
</html>

```

```css
:root {
  --dark-grey: #1b1b32;
  --light-grey: #f5f6f7;
  --dark-orange: #f89808;
  --yellow: #f1be32;
  --golden-yellow: #feac32;
}

*,
*::before,
*::after {
  box-sizing: border-box;
}

body {
  font-family: Arial, sans-serif;
  line-height: 1.5;
  color: var(--dark-grey);
  background-color: var(--dark-grey);
}

main,
.container {
  display: flex;
  flex-direction: column;
  align-items: center;
}

.container {
  background-color: var(--light-grey);
  width: 90%;
  margin: 20px;
  padding: 10px;
}

h1 {
  color: var(--dark-grey);
}

form {
  text-align: center;
}

button {
  cursor: pointer;
}

button {
  cursor: pointer;
  width: 100px;
  margin: 3px;
  color: var(--dark-grey);
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}

button:hover {
  background-image: linear-gradient(#ffcc4c, #f89808);
}

input {
  color: var(--dark-grey);
  margin-left: 5px;
  padding: 3px;
}

li {
  text-align: left;
  margin: 10px 0;
}

.selected-item {
  font-weight: bold;
}

@media (min-width: 425px) {
  .container {
    width: 400px;
  }
}

```

```jsx
--fcc-editable-region--
const { useState } = React;

export const ShoppingList = () => {
  return (

  );
};
--fcc-editable-region--
```
